/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1beta2.BaseBigQueryReadClient;
import com.google.cloud.bigquery.storage.v1beta2.BaseBigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1beta2.DataFormat;
import com.google.cloud.bigquery.storage.v1beta2.MockBigQueryRead;
import com.google.cloud.bigquery.storage.v1beta2.ProjectName;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.ReadSession;
import com.google.cloud.bigquery.storage.v1beta2.ReadStream;
import com.google.cloud.bigquery.storage.v1beta2.ReadStreamName;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1beta2.StreamStats;
import com.google.cloud.bigquery.storage.v1beta2.TableName;
import com.google.cloud.bigquery.storage.v1beta2.ThrottleState;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseBigQueryReadClientTest {
    private static MockBigQueryRead mockBigQueryRead;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private BaseBigQueryReadClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockBigQueryRead = new MockBigQueryRead();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockBigQueryRead));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        BaseBigQueryReadSettings settings = ((BaseBigQueryReadSettings.Builder)((BaseBigQueryReadSettings.Builder)BaseBigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = BaseBigQueryReadClient.create((BaseBigQueryReadSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createReadSessionTest() throws Exception {
        ReadSession expectedResponse = ReadSession.newBuilder().setName("name3373707").setExpireTime(Timestamp.newBuilder().build()).setDataFormat(DataFormat.forNumber((int)0)).setTable(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).setTableModifiers(ReadSession.TableModifiers.newBuilder().build()).setReadOptions(ReadSession.TableReadOptions.newBuilder().build()).addAllStreams(new ArrayList()).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        ReadSession readSession = ReadSession.newBuilder().build();
        int maxStreamCount = 940837515;
        ReadSession actualResponse = this.client.createReadSession(parent, readSession, maxStreamCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryRead.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReadSessionRequest actualRequest = (CreateReadSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)readSession, (Object)actualRequest.getReadSession());
        Assert.assertEquals((long)maxStreamCount, (long)actualRequest.getMaxStreamCount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReadSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryRead.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            ReadSession readSession = ReadSession.newBuilder().build();
            int maxStreamCount = 940837515;
            this.client.createReadSession(parent, readSession, maxStreamCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReadSessionTest2() throws Exception {
        ReadSession expectedResponse = ReadSession.newBuilder().setName("name3373707").setExpireTime(Timestamp.newBuilder().build()).setDataFormat(DataFormat.forNumber((int)0)).setTable(TableName.of((String)"[PROJECT]", (String)"[DATASET]", (String)"[TABLE]").toString()).setTableModifiers(ReadSession.TableModifiers.newBuilder().build()).setReadOptions(ReadSession.TableReadOptions.newBuilder().build()).addAllStreams(new ArrayList()).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        ReadSession readSession = ReadSession.newBuilder().build();
        int maxStreamCount = 940837515;
        ReadSession actualResponse = this.client.createReadSession(parent, readSession, maxStreamCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryRead.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateReadSessionRequest actualRequest = (CreateReadSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)readSession, (Object)actualRequest.getReadSession());
        Assert.assertEquals((long)maxStreamCount, (long)actualRequest.getMaxStreamCount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReadSessionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryRead.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ReadSession readSession = ReadSession.newBuilder().build();
            int maxStreamCount = 940837515;
            this.client.createReadSession(parent, readSession, maxStreamCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readRowsTest() throws Exception {
        ReadRowsResponse expectedResponse = ReadRowsResponse.newBuilder().setRowCount(1340416618L).setStats(StreamStats.newBuilder().build()).setThrottleState(ThrottleState.newBuilder().build()).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().setReadStream(ReadStreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SESSION]", (String)"[STREAM]").toString()).setOffset(-1019779949L).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void readRowsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryRead.addException((Exception)exception);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().setReadStream(ReadStreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SESSION]", (String)"[STREAM]").toString()).setOffset(-1019779949L).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void splitReadStreamTest() throws Exception {
        SplitReadStreamResponse expectedResponse = SplitReadStreamResponse.newBuilder().setPrimaryStream(ReadStream.newBuilder().build()).setRemainderStream(ReadStream.newBuilder().build()).build();
        mockBigQueryRead.addResponse((AbstractMessage)expectedResponse);
        SplitReadStreamRequest request = SplitReadStreamRequest.newBuilder().setName(ReadStreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SESSION]", (String)"[STREAM]").toString()).setFraction(-1.653751294E9).build();
        SplitReadStreamResponse actualResponse = this.client.splitReadStream(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryRead.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SplitReadStreamRequest actualRequest = (SplitReadStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((double)request.getFraction(), (double)actualRequest.getFraction(), (double)1.0E-4);
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void splitReadStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryRead.addException((Exception)exception);
        try {
            SplitReadStreamRequest request = SplitReadStreamRequest.newBuilder().setName(ReadStreamName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SESSION]", (String)"[STREAM]").toString()).setFraction(-1.653751294E9).build();
            this.client.splitReadStream(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

