/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.cloud.bigquery.storage.v1beta2.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteGrpc;
import com.google.cloud.bigquery.storage.v1beta2.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.WriteStream;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.Uninterruptibles;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

class FakeBigQueryWriteImpl
extends BigQueryWriteGrpc.BigQueryWriteImplBase {
    private static final Logger LOG = Logger.getLogger(FakeBigQueryWriteImpl.class.getName());
    private final LinkedBlockingQueue<AppendRowsRequest> requests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<GetWriteStreamRequest> writeRequests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<FlushRowsRequest> flushRequests = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Response> responses = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<WriteStream> writeResponses = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<FlushRowsResponse> flushResponses = new LinkedBlockingQueue();
    private final AtomicInteger nextMessageId = new AtomicInteger(1);
    private boolean autoPublishResponse;
    private ScheduledExecutorService executor = null;
    private Duration responseDelay = Duration.ZERO;
    private Duration responseSleep = Duration.ZERO;
    private Semaphore responseSemaphore = new Semaphore(0, true);

    FakeBigQueryWriteImpl() {
    }

    public void getWriteStream(GetWriteStreamRequest request, StreamObserver<WriteStream> responseObserver) {
        Object response = this.writeResponses.remove();
        if (response instanceof WriteStream) {
            this.writeRequests.add(request);
            responseObserver.onNext((Object)((WriteStream)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException("Unrecognized response type"));
        }
    }

    public void flushRows(FlushRowsRequest request, StreamObserver<FlushRowsResponse> responseObserver) {
        Object response = this.writeResponses.remove();
        if (response instanceof FlushRowsResponse) {
            this.flushRequests.add(request);
            responseObserver.onNext((Object)((FlushRowsResponse)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException("Unrecognized response type"));
        }
    }

    public void waitForResponseScheduled() throws InterruptedException {
        this.responseSemaphore.acquire();
    }

    public StreamObserver<AppendRowsRequest> appendRows(final StreamObserver<AppendRowsResponse> responseObserver) {
        StreamObserver<AppendRowsRequest> requestObserver = new StreamObserver<AppendRowsRequest>(){

            public void onNext(AppendRowsRequest value) {
                LOG.fine("Get request:" + value.toString());
                Response response = (Response)FakeBigQueryWriteImpl.this.responses.remove();
                FakeBigQueryWriteImpl.this.requests.add(value);
                if (FakeBigQueryWriteImpl.this.responseSleep.compareTo(Duration.ZERO) > 0) {
                    LOG.info("Sleeping before response for " + FakeBigQueryWriteImpl.this.responseSleep.toString());
                    Uninterruptibles.sleepUninterruptibly((long)FakeBigQueryWriteImpl.this.responseSleep.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                if (FakeBigQueryWriteImpl.this.responseDelay == Duration.ZERO) {
                    FakeBigQueryWriteImpl.this.sendResponse(response, (StreamObserver<AppendRowsResponse>)responseObserver);
                } else {
                    final Response responseToSend = response;
                    LOG.fine("Schedule a response to be sent at delay");
                    FakeBigQueryWriteImpl.this.executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            FakeBigQueryWriteImpl.this.sendResponse(responseToSend, (StreamObserver<AppendRowsResponse>)responseObserver);
                        }
                    }, FakeBigQueryWriteImpl.this.responseDelay.toMillis(), TimeUnit.MILLISECONDS);
                }
                FakeBigQueryWriteImpl.this.responseSemaphore.release();
            }

            public void onError(Throwable t) {
                responseObserver.onError(t);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
        return requestObserver;
    }

    private void sendResponse(Response response, StreamObserver<AppendRowsResponse> responseObserver) {
        LOG.fine("Sending response: " + response.toString());
        if (response.isError()) {
            responseObserver.onError(response.getError());
        } else {
            responseObserver.onNext((Object)response.getResponse());
        }
    }

    public FakeBigQueryWriteImpl setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public FakeBigQueryWriteImpl setResponseDelay(Duration responseDelay) {
        this.responseDelay = responseDelay;
        return this;
    }

    public FakeBigQueryWriteImpl setResponseSleep(Duration responseSleep) {
        this.responseSleep = responseSleep;
        return this;
    }

    public FakeBigQueryWriteImpl addResponse(AppendRowsResponse appendRowsResponse) {
        this.responses.add(new Response(appendRowsResponse));
        return this;
    }

    public FakeBigQueryWriteImpl addResponse(AppendRowsResponse.Builder appendResponseBuilder) {
        return this.addResponse(appendResponseBuilder.build());
    }

    public FakeBigQueryWriteImpl addWriteStreamResponse(WriteStream response) {
        this.writeResponses.add(response);
        return this;
    }

    public FakeBigQueryWriteImpl addFlushRowsResponse(FlushRowsResponse response) {
        this.flushResponses.add(response);
        return this;
    }

    public FakeBigQueryWriteImpl addConnectionError(Throwable error) {
        this.responses.add(new Response(error));
        return this;
    }

    public List<AppendRowsRequest> getCapturedRequests() {
        return new ArrayList<AppendRowsRequest>(this.requests);
    }

    public List<GetWriteStreamRequest> getCapturedWriteRequests() {
        return new ArrayList<GetWriteStreamRequest>(this.writeRequests);
    }

    public void reset() {
        this.requests.clear();
        this.responses.clear();
    }

    private static class Response {
        Optional<AppendRowsResponse> appendResponse;
        Optional<Throwable> error;

        public Response(AppendRowsResponse appendResponse) {
            this.appendResponse = Optional.of((Object)appendResponse);
            this.error = Optional.absent();
        }

        public Response(Throwable exception) {
            this.appendResponse = Optional.absent();
            this.error = Optional.of((Object)exception);
        }

        public AppendRowsResponse getResponse() {
            return (AppendRowsResponse)this.appendResponse.get();
        }

        public Throwable getError() {
            return (Throwable)this.error.get();
        }

        boolean isError() {
            return this.error.isPresent();
        }

        public String toString() {
            if (this.isError()) {
                return ((Throwable)this.error.get()).toString();
            }
            return ((AppendRowsResponse)this.appendResponse.get()).toString();
        }
    }
}

