/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.cloud.bigquery.storage.test.JsonTest;
import com.google.cloud.bigquery.storage.test.SchemaTest;
import com.google.cloud.bigquery.storage.v1.JsonToProtoMessage;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1beta2.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1beta2.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.LocalTime;

@RunWith(value=JUnit4.class)
public class JsonToProtoMessageTest {
    private static final Logger LOG = Logger.getLogger(JsonToProtoMessageTest.class.getName());
    private static ImmutableMap<Descriptors.Descriptor, String> AllTypesToDebugMessageTest = new ImmutableMap.Builder().put((Object)SchemaTest.BoolType.getDescriptor(), (Object)"boolean").put((Object)SchemaTest.BytesType.getDescriptor(), (Object)"bytes").put((Object)SchemaTest.Int64Type.getDescriptor(), (Object)"int64").put((Object)SchemaTest.Int32Type.getDescriptor(), (Object)"int32").put((Object)SchemaTest.DoubleType.getDescriptor(), (Object)"double").put((Object)SchemaTest.StringType.getDescriptor(), (Object)"string").put((Object)JsonTest.RepeatedType.getDescriptor(), (Object)"array").put((Object)JsonTest.ObjectType.getDescriptor(), (Object)"object").build();
    private static ImmutableMap<Descriptors.Descriptor, Message[]> AllTypesToCorrectProto = new ImmutableMap.Builder().put((Object)SchemaTest.BoolType.getDescriptor(), (Object)new Message[]{SchemaTest.BoolType.newBuilder().setTestFieldType(true).build()}).put((Object)SchemaTest.BytesType.getDescriptor(), (Object)new Message[]{SchemaTest.BytesType.newBuilder().setTestFieldType(ByteString.copyFromUtf8((String)"test")).build(), SchemaTest.BytesType.newBuilder().setTestFieldType(ByteString.copyFrom((byte[])new byte[]{1, 2, 3})).build()}).put((Object)SchemaTest.Int64Type.getDescriptor(), (Object)new Message[]{SchemaTest.Int64Type.newBuilder().setTestFieldType(Long.MAX_VALUE).build(), SchemaTest.Int64Type.newBuilder().setTestFieldType(new Long(Integer.MAX_VALUE)).build()}).put((Object)SchemaTest.Int32Type.getDescriptor(), (Object)new Message[]{SchemaTest.Int32Type.newBuilder().setTestFieldType(Integer.MAX_VALUE).build()}).put((Object)SchemaTest.DoubleType.getDescriptor(), (Object)new Message[]{SchemaTest.DoubleType.newBuilder().setTestFieldType(1.23).build()}).put((Object)SchemaTest.StringType.getDescriptor(), (Object)new Message[]{SchemaTest.StringType.newBuilder().setTestFieldType("test").build()}).put((Object)JsonTest.RepeatedType.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedType.newBuilder().addAllTestFieldType((Iterable<? extends Long>)new ArrayList<Long>(){
        {
            this.add(1L);
            this.add(2L);
            this.add(3L);
        }
    }).build()}).put((Object)JsonTest.ObjectType.getDescriptor(), (Object)new Message[]{JsonTest.ObjectType.newBuilder().setTestFieldType(JsonTest.ComplexLvl2.newBuilder().setTestInt(1L).build()).build()}).build();
    private static ImmutableMap<Descriptors.Descriptor, String> AllRepeatedTypesToDebugMessageTest = new ImmutableMap.Builder().put((Object)JsonTest.RepeatedBool.getDescriptor(), (Object)"boolean").put((Object)JsonTest.RepeatedBytes.getDescriptor(), (Object)"bytes").put((Object)JsonTest.RepeatedInt64.getDescriptor(), (Object)"int64").put((Object)JsonTest.RepeatedInt32.getDescriptor(), (Object)"int32").put((Object)JsonTest.RepeatedDouble.getDescriptor(), (Object)"double").put((Object)JsonTest.RepeatedString.getDescriptor(), (Object)"string").put((Object)JsonTest.RepeatedObject.getDescriptor(), (Object)"object").build();
    private static ImmutableMap<Descriptors.Descriptor, Message[]> AllRepeatedTypesToCorrectProto = new ImmutableMap.Builder().put((Object)JsonTest.RepeatedBool.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedBool.newBuilder().addTestRepeated(true).addTestRepeated(false).build()}).put((Object)JsonTest.RepeatedBytes.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedBytes.newBuilder().addTestRepeated(ByteString.copyFrom((byte[])new byte[]{0})).addTestRepeated(ByteString.copyFrom((byte[])new byte[]{0, -116, -122, 71})).build(), JsonTest.RepeatedBytes.newBuilder().addTestRepeated(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("0"))).addTestRepeated(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.2"))).build()}).put((Object)JsonTest.RepeatedString.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedString.newBuilder().addTestRepeated("hello").addTestRepeated("test").build()}).put((Object)JsonTest.RepeatedInt64.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedInt64.newBuilder().addTestRepeated(Long.MAX_VALUE).addTestRepeated(Long.MIN_VALUE).addTestRepeated(Integer.MAX_VALUE).addTestRepeated(Integer.MIN_VALUE).addTestRepeated(32767L).addTestRepeated(-32768L).addTestRepeated(127L).addTestRepeated(-128L).addTestRepeated(0L).build(), JsonTest.RepeatedInt64.newBuilder().addTestRepeated(Integer.MAX_VALUE).addTestRepeated(Integer.MIN_VALUE).addTestRepeated(32767L).addTestRepeated(-32768L).addTestRepeated(127L).addTestRepeated(-128L).addTestRepeated(0L).build()}).put((Object)JsonTest.RepeatedInt32.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedInt32.newBuilder().addTestRepeated(Integer.MAX_VALUE).addTestRepeated(Integer.MIN_VALUE).addTestRepeated(Short.MAX_VALUE).addTestRepeated(Short.MIN_VALUE).addTestRepeated(127).addTestRepeated(-128).addTestRepeated(0).build()}).put((Object)JsonTest.RepeatedDouble.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedDouble.newBuilder().addTestRepeated(Double.MAX_VALUE).addTestRepeated(Double.MIN_VALUE).addTestRepeated(3.4028234663852886E38).addTestRepeated(1.4E-45f).build(), JsonTest.RepeatedDouble.newBuilder().addTestRepeated(3.4028234663852886E38).addTestRepeated(1.4E-45f).build()}).put((Object)JsonTest.RepeatedObject.getDescriptor(), (Object)new Message[]{JsonTest.RepeatedObject.newBuilder().addTestRepeated(JsonTest.ComplexLvl2.newBuilder().setTestInt(1L).build()).addTestRepeated(JsonTest.ComplexLvl2.newBuilder().setTestInt(2L).build()).addTestRepeated(JsonTest.ComplexLvl2.newBuilder().setTestInt(3L).build()).build()}).build();
    private static JSONObject[] simpleJSONObjects = new JSONObject[]{new JSONObject().put("test_field_type", Long.MAX_VALUE), new JSONObject().put("test_field_type", Integer.MAX_VALUE), new JSONObject().put("test_field_type", 1.23), new JSONObject().put("test_field_type", true), new JSONObject().put("test_field_type", (Object)ByteString.copyFromUtf8((String)"test")), new JSONObject().put("test_field_type", (Object)new JSONArray("[1, 2, 3]")), new JSONObject().put("test_field_type", (Object)new JSONObject().put("test_int", 1)), new JSONObject().put("test_field_type", (Object)"test")};
    private static JSONObject[] simpleJSONArrays = new JSONObject[]{new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new Long[]{Long.MAX_VALUE, Long.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, 32767L, -32768L, 127L, -128L, 0L})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new Integer[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Short.MAX_VALUE, Short.MIN_VALUE, 127, -128, 0})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new Double[]{Double.MAX_VALUE, Double.MIN_VALUE, 3.4028234663852886E38, 1.4E-45f})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new Float[]{Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE)})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new Boolean[]{true, false})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new String[]{"hello", "test"})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("0")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.2")).toByteArray()})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new int[][]{{11111, 22222}})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new char[][]{{'a', 'b'}, {'c'}})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new String[][]{{"hello"}, {"test"}})), new JSONObject().put("test_repeated", (Object)new JSONArray((Object)new JSONObject[]{new JSONObject().put("test_int", 1), new JSONObject().put("test_int", 2), new JSONObject().put("test_int", 3)}))};
    private final TableFieldSchema TEST_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INT64).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_int").build();
    private final TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.REPEATED).setName("test_string").build();
    private final TableFieldSchema TEST_BYTES = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REQUIRED).setName("test_bytes").build();
    private final TableFieldSchema TEST_BOOL = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BOOL).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bool").build();
    private final TableFieldSchema TEST_DOUBLE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DOUBLE).setMode(TableFieldSchema.Mode.REPEATED).setName("test_double").build();
    private final TableFieldSchema TEST_DATE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATE).setMode(TableFieldSchema.Mode.REQUIRED).setName("test_date").build();
    private final TableFieldSchema TEST_DATETIME = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_datetime").build();
    private final TableFieldSchema TEST_DATETIME_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.REPEATED).setName("test_datetime_str").build();
    private final TableFieldSchema COMPLEXLVL2 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.REQUIRED).addFields(0, this.TEST_INT).setName("complex_lvl2").build();
    private final TableFieldSchema COMPLEXLVL1 = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRUCT).setMode(TableFieldSchema.Mode.REQUIRED).addFields(0, this.TEST_INT).addFields(1, this.COMPLEXLVL2).setName("complex_lvl1").build();
    private final TableFieldSchema TEST_NUMERIC = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric").build();
    private final TableFieldSchema TEST_NUMERIC_REPEATED = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_numeric_repeated").build();
    private final TableFieldSchema TEST_GEO = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.GEOGRAPHY).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_geo").build();
    private final TableFieldSchema TEST_TIMESTAMP = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIMESTAMP).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_timestamp").build();
    private final TableFieldSchema TEST_TIME = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_time").build();
    private final TableFieldSchema TEST_TIME_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_time_str").build();
    private final TableFieldSchema TEST_NUMERIC_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_str").build();
    private final TableFieldSchema TEST_NUMERIC_SHORT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_short").build();
    private final TableFieldSchema TEST_NUMERIC_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_int").build();
    private final TableFieldSchema TEST_NUMERIC_LONG = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_long").build();
    private final TableFieldSchema TEST_NUMERIC_FLOAT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_float").build();
    private final TableFieldSchema TEST_NUMERIC_DOUBLE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_double").build();
    private final TableFieldSchema TEST_BIGNUMERIC = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric").build();
    private final TableFieldSchema TEST_BIGNUMERIC_STR = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_bignumeric_str").build();
    private final TableFieldSchema TEST_BIGNUMERIC_SHORT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_short").build();
    private final TableFieldSchema TEST_BIGNUMERIC_INT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_int").build();
    private final TableFieldSchema TEST_BIGNUMERIC_LONG = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_long").build();
    private final TableFieldSchema TEST_BIGNUMERIC_FLOAT = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_float").build();
    private final TableFieldSchema TEST_BIGNUMERIC_DOUBLE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_bignumeric_double").build();
    private final TableFieldSchema TEST_INTERVAL = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.INTERVAL).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_interval").build();
    private final TableFieldSchema TEST_JSON = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.JSON).setMode(TableFieldSchema.Mode.REPEATED).setName("test_json").build();
    private final TableSchema COMPLEX_TABLE_SCHEMA = TableSchema.newBuilder().addFields(0, this.TEST_INT).addFields(1, this.TEST_STRING).addFields(2, this.TEST_BYTES).addFields(3, this.TEST_BOOL).addFields(4, this.TEST_DOUBLE).addFields(5, this.TEST_DATE).addFields(6, this.TEST_DATETIME).addFields(7, this.TEST_DATETIME_STR).addFields(8, this.COMPLEXLVL1).addFields(9, this.COMPLEXLVL2).addFields(10, this.TEST_NUMERIC).addFields(11, this.TEST_GEO).addFields(12, this.TEST_TIMESTAMP).addFields(13, this.TEST_TIME).addFields(14, this.TEST_TIME_STR).addFields(15, this.TEST_NUMERIC_REPEATED).addFields(16, this.TEST_NUMERIC_STR).addFields(17, this.TEST_NUMERIC_SHORT).addFields(18, this.TEST_NUMERIC_INT).addFields(19, this.TEST_NUMERIC_LONG).addFields(20, this.TEST_NUMERIC_FLOAT).addFields(21, this.TEST_NUMERIC_DOUBLE).addFields(22, this.TEST_BIGNUMERIC).addFields(23, this.TEST_BIGNUMERIC_STR).addFields(24, this.TEST_BIGNUMERIC_SHORT).addFields(25, this.TEST_BIGNUMERIC_INT).addFields(26, this.TEST_BIGNUMERIC_LONG).addFields(27, this.TEST_BIGNUMERIC_FLOAT).addFields(28, this.TEST_BIGNUMERIC_DOUBLE).addFields(29, this.TEST_INTERVAL).addFields(30, this.TEST_JSON).build();

    @Test
    public void testDifferentNameCasing() throws Exception {
        JsonTest.TestInt64 expectedProto = JsonTest.TestInt64.newBuilder().setByte(1L).setShort(1L).setInt(1L).setLong(1L).build();
        JSONObject json = new JSONObject();
        json.put("bYtE", 1);
        json.put("SHORT", 1);
        json.put("inT", 1);
        json.put("lONg", 1L);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestInt64.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testInt64() throws Exception {
        JsonTest.TestInt64 expectedProto = JsonTest.TestInt64.newBuilder().setByte(1L).setShort(1L).setInt(1L).setLong(1L).build();
        JSONObject json = new JSONObject();
        json.put("byte", 1);
        json.put("short", 1);
        json.put("int", 1);
        json.put("long", 1L);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestInt64.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testInt32() throws Exception {
        JsonTest.TestInt32 expectedProto = JsonTest.TestInt32.newBuilder().setByte(1).setShort(1).setInt(1).build();
        JSONObject json = new JSONObject();
        json.put("byte", 1);
        json.put("short", 1);
        json.put("int", 1);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestInt32.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testInt32NotMatchInt64() throws Exception {
        JSONObject json = new JSONObject();
        json.put("byte", 1);
        json.put("short", 1);
        json.put("int", 1L);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestInt32.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a int32 field at root.int.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDateTimeMismatch() throws Exception {
        TableFieldSchema field = TableFieldSchema.newBuilder().setName("datetime").setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.REPEATED).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(field).build();
        JSONObject json = new JSONObject();
        json.put("datetime", 1.0);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestDatetime.getDescriptor(), (TableSchema)tableSchema, (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a int64 field at root.datetime.", (Object)e.getMessage());
        }
    }

    @Test
    public void testTimeMismatch() throws Exception {
        TableFieldSchema field = TableFieldSchema.newBuilder().setName("time").setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.REPEATED).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(field).build();
        JSONObject json = new JSONObject();
        json.put("time", (Object)new JSONArray((Object)new Double[]{1.0}));
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestTime.getDescriptor(), (TableSchema)tableSchema, (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a int64 field at root.time[0].", (Object)e.getMessage());
        }
    }

    @Test
    public void testMixedCasedFieldNames() throws Exception {
        com.google.cloud.bigquery.storage.v1.TableFieldSchema field = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder().setName("fooBar").setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).build();
        com.google.cloud.bigquery.storage.v1.TableSchema tableSchema = com.google.cloud.bigquery.storage.v1.TableSchema.newBuilder().addFields(field).build();
        JSONObject json = new JSONObject();
        json.put("fooBar", (Object)"hello");
        DynamicMessage protoMsg = JsonToProtoMessage.INSTANCE.convertToProtoMessage(JsonTest.TestMixedCaseFieldNames.getDescriptor(), tableSchema, json);
    }

    @Test
    public void testDouble() throws Exception {
        JsonTest.TestDouble expectedProto = JsonTest.TestDouble.newBuilder().setDouble(1.2).setFloat(3.4f).build();
        JSONObject json = new JSONObject();
        json.put("double", 1.2);
        json.put("float", 3.4f);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestDouble.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testAllTypes() throws Exception {
        for (Map.Entry entry : AllTypesToDebugMessageTest.entrySet()) {
            int success = 0;
            for (JSONObject json : simpleJSONObjects) {
                try {
                    LOG.info("Testing " + json + " over " + ((Descriptors.Descriptor)entry.getKey()).getFullName());
                    DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)((Descriptors.Descriptor)entry.getKey()), (JSONObject)json);
                    LOG.info("Convert Success!");
                    Assert.assertEquals((Object)protoMsg, (Object)((Message[])AllTypesToCorrectProto.get(entry.getKey()))[success]);
                    ++success;
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((Object)("JSONObject does not have a " + (String)entry.getValue() + " field at root.test_field_type."), (Object)e.getMessage());
                }
            }
            if (entry.getKey() == SchemaTest.Int64Type.getDescriptor() || entry.getKey() == SchemaTest.BytesType.getDescriptor()) {
                Assert.assertEquals((String)((Descriptors.Descriptor)entry.getKey()).getFullName(), (long)2L, (long)success);
                continue;
            }
            Assert.assertEquals((String)((Descriptors.Descriptor)entry.getKey()).getFullName(), (long)1L, (long)success);
        }
    }

    @Test
    public void testAllRepeatedTypesWithLimits() throws Exception {
        for (Map.Entry entry : AllRepeatedTypesToDebugMessageTest.entrySet()) {
            int success = 0;
            for (JSONObject json : simpleJSONArrays) {
                try {
                    LOG.info("Testing " + json + " over " + ((Descriptors.Descriptor)entry.getKey()).getFullName());
                    DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)((Descriptors.Descriptor)entry.getKey()), (JSONObject)json);
                    LOG.info("Convert Success!");
                    Assert.assertEquals((String)protoMsg.toString(), (Object)protoMsg, (Object)((Message[])AllRepeatedTypesToCorrectProto.get(entry.getKey()))[success]);
                    ++success;
                }
                catch (IllegalArgumentException e) {
                    LOG.info(e.getMessage());
                    Assert.assertTrue((e.getMessage().equals("JSONObject does not have a " + (String)entry.getValue() + " field at root.test_repeated[0].") || e.getMessage().equals("Error: root.test_repeated[0] could not be converted to byte[].") ? 1 : 0) != 0);
                }
            }
            if (entry.getKey() == JsonTest.RepeatedInt64.getDescriptor() || entry.getKey() == JsonTest.RepeatedDouble.getDescriptor()) {
                Assert.assertEquals((String)((Descriptors.Descriptor)entry.getKey()).getFullName(), (long)2L, (long)success);
                continue;
            }
            Assert.assertEquals((String)((Descriptors.Descriptor)entry.getKey()).getFullName(), (long)1L, (long)success);
        }
    }

    @Test
    public void testOptional() throws Exception {
        JsonTest.TestInt64 expectedProto = JsonTest.TestInt64.newBuilder().setByte(1L).build();
        JSONObject json = new JSONObject();
        json.put("byte", 1);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestInt64.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testRepeatedIsOptional() throws Exception {
        JsonTest.TestRepeatedIsOptional expectedProto = JsonTest.TestRepeatedIsOptional.newBuilder().setRequiredDouble(1.1).build();
        JSONObject json = new JSONObject();
        json.put("required_double", 1.1);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestRepeatedIsOptional.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testRequired() throws Exception {
        JSONObject json = new JSONObject();
        json.put("optional_double", 1.1);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestRequired.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have the required field root.required_double.", (Object)e.getMessage());
        }
    }

    @Test
    public void testStructSimple() throws Exception {
        SchemaTest.MessageType expectedProto = SchemaTest.MessageType.newBuilder().setTestFieldType(SchemaTest.StringType.newBuilder().setTestFieldType("test").build()).build();
        JSONObject stringType = new JSONObject();
        stringType.put("test_field_type", (Object)"test");
        JSONObject json = new JSONObject();
        json.put("test_field_type", (Object)stringType);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)SchemaTest.MessageType.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testStructSimpleFail() throws Exception {
        JSONObject stringType = new JSONObject();
        stringType.put("test_field_type", 1);
        JSONObject json = new JSONObject();
        json.put("test_field_type", (Object)stringType);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)SchemaTest.MessageType.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a string field at root.test_field_type.test_field_type.", (Object)e.getMessage());
        }
    }

    @Test
    public void testStructComplex() throws Exception {
        JsonTest.ComplexRoot expectedProto = JsonTest.ComplexRoot.newBuilder().setTestInt(1L).addTestString("a").addTestString("b").addTestString("c").setTestBytes(ByteString.copyFrom((byte[])"hello".getBytes())).setTestBool(true).addTestDouble(1.1).addTestDouble(2.2).addTestDouble(3.3).addTestDouble(4.4).setTestDate(1).setTestDatetime(1L).addTestDatetimeStr(142258614586538368L).addTestDatetimeStr(142258525253402624L).setComplexLvl1(JsonTest.ComplexLvl1.newBuilder().setTestInt(2L).setComplexLvl2(JsonTest.ComplexLvl2.newBuilder().setTestInt(3L).build()).build()).setComplexLvl2(JsonTest.ComplexLvl2.newBuilder().setTestInt(3L).build()).setTestNumeric(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.23456"))).setTestGeo("POINT(1,1)").setTestTimestamp(12345678L).setTestTime(CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)1, (int)0, (int)1))).setTestTimeStr(89332507144L).addTestNumericRepeated(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("0"))).addTestNumericRepeated(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("99999999999999999999999999999.999999999"))).addTestNumericRepeated(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-99999999999999999999999999999.999999999"))).setTestNumericStr(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("12.4"))).setTestNumericShort(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(1))).setTestNumericInt(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(2))).setTestNumericLong(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(3L))).setTestNumericFloat(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(4.0))).setTestNumericDouble(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(5.0))).setTestBignumeric(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("2.3"))).addTestBignumericStr(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.23"))).setTestBignumericShort(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(1))).setTestBignumericInt(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(2))).setTestBignumericLong(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(3L))).setTestBignumericFloat(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(4.0))).setTestBignumericDouble(BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal(5.0))).setTestInterval("0-0 0 0:0:0.000005").addTestJson("{'a':'b'}").build();
        JSONObject complex_lvl2 = new JSONObject();
        complex_lvl2.put("test_int", 3);
        JSONObject complex_lvl1 = new JSONObject();
        complex_lvl1.put("test_int", 2);
        complex_lvl1.put("complex_lvl2", (Object)complex_lvl2);
        JSONObject json = new JSONObject();
        json.put("test_int", 1);
        json.put("test_string", (Object)new JSONArray((Object)new String[]{"a", "b", "c"}));
        json.put("test_bytes", (Object)ByteString.copyFromUtf8((String)"hello"));
        json.put("test_bool", true);
        json.put("test_DOUBLe", (Object)new JSONArray((Object)new Double[]{1.1, 2.2, 3.3, 4.4}));
        json.put("test_date", 1);
        json.put("test_datetime", 1);
        json.put("test_datetime_str", (Object)new JSONArray((Object)new String[]{"2021-09-27T20:51:10.752", "2021-09-27T00:00:00"}));
        json.put("complex_lvl1", (Object)complex_lvl1);
        json.put("complex_lvl2", (Object)complex_lvl2);
        json.put("test_numeric", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.23456")));
        json.put("test_numeric_repeated", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("0")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("99999999999999999999999999999.999999999")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-99999999999999999999999999999.999999999")).toByteArray()}));
        json.put("test_geo", (Object)"POINT(1,1)");
        json.put("test_timestamp", 12345678);
        json.put("test_time", CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)1, (int)0, (int)1)));
        json.put("test_time_str", (Object)"20:51:10.1234");
        json.put("test_numeric_str", (Object)"12.4");
        json.put("test_numeric_short", 1);
        json.put("test_numeric_int", 2);
        json.put("test_numeric_long", 3L);
        json.put("test_numeric_float", 4.0f);
        json.put("test_numeric_double", 5.0);
        json.put("test_bignumeric", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)BigDecimal.valueOf(2.3)));
        json.put("test_bignumeric_str", (Object)new JSONArray((Object)new String[]{"1.23"}));
        json.put("test_bignumeric_short", 1);
        json.put("test_bignumeric_int", 2);
        json.put("test_bignumeric_long", 3L);
        json.put("test_bignumeric_float", 4.0f);
        json.put("test_bignumeric_double", 5.0);
        json.put("test_interval", (Object)"0-0 0 0:0:0.000005");
        json.put("test_json", (Object)new JSONArray((Object)new String[]{"{'a':'b'}"}));
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.ComplexRoot.getDescriptor(), (TableSchema)this.COMPLEX_TABLE_SCHEMA, (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testStructComplexFail() throws Exception {
        JSONObject complex_lvl2 = new JSONObject();
        complex_lvl2.put("test_int", 3);
        JSONObject complex_lvl1 = new JSONObject();
        complex_lvl1.put("test_int", (Object)"not_int");
        complex_lvl1.put("complex_lvl2", (Object)complex_lvl2);
        JSONObject json = new JSONObject();
        json.put("test_int", 1);
        json.put("test_string", (Object)new JSONArray((Object)new String[]{"a", "b", "c"}));
        json.put("test_bytes", (Object)ByteString.copyFromUtf8((String)"hello"));
        json.put("test_bool", true);
        json.put("test_double", (Object)new JSONArray((Object)new Double[]{1.1, 2.2, 3.3, 4.4}));
        json.put("test_date", 1);
        json.put("complex_lvl1", (Object)complex_lvl1);
        json.put("complex_lvl2", (Object)complex_lvl2);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.ComplexRoot.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a int64 field at root.complex_lvl1.test_int.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRepeatedWithMixedTypes() throws Exception {
        JSONObject json = new JSONObject();
        json.put("test_repeated", (Object)new JSONArray("[1.1, 2.2, true]"));
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.RepeatedDouble.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a double field at root.test_repeated[0].", (Object)e.getMessage());
        }
    }

    @Test
    public void testNestedRepeatedComplex() throws Exception {
        JsonTest.NestedRepeated expectedProto = JsonTest.NestedRepeated.newBuilder().addDouble(1.1).addDouble(2.2).addDouble(3.3).addDouble(4.4).addDouble(5.5).addInt(1L).addInt(2L).addInt(3L).addInt(4L).addInt(5L).setRepeatedString(JsonTest.RepeatedString.newBuilder().addTestRepeated("hello").addTestRepeated("this").addTestRepeated("is").addTestRepeated("a").addTestRepeated("test").build()).build();
        double[] doubleArr = new double[]{1.1, 2.2, 3.3, 4.4, 5.5};
        String[] stringArr = new String[]{"hello", "this", "is", "a", "test"};
        int[] intArr = new int[]{1, 2, 3, 4, 5};
        JSONObject json = new JSONObject();
        json.put("double", (Object)new JSONArray((Object)doubleArr));
        json.put("int", (Object)new JSONArray((Object)intArr));
        JSONObject jsonRepeatedString = new JSONObject();
        jsonRepeatedString.put("test_repeated", (Object)new JSONArray((Object)stringArr));
        json.put("repeated_string", (Object)jsonRepeatedString);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.NestedRepeated.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)protoMsg, (Object)expectedProto);
    }

    @Test
    public void testNestedRepeatedComplexFail() throws Exception {
        double[] doubleArr = new double[]{1.1, 2.2, 3.3, 4.4, 5.5};
        Boolean[] fakeStringArr = new Boolean[]{true, false};
        int[] intArr = new int[]{1, 2, 3, 4, 5};
        JSONObject json = new JSONObject();
        json.put("double", (Object)new JSONArray((Object)doubleArr));
        json.put("int", (Object)new JSONArray((Object)intArr));
        JSONObject jsonRepeatedString = new JSONObject();
        jsonRepeatedString.put("test_repeated", (Object)new JSONArray((Object)fakeStringArr));
        json.put("repeated_string", (Object)jsonRepeatedString);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.NestedRepeated.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject does not have a string field at root.repeated_string.test_repeated[0].", (Object)e.getMessage());
        }
    }

    @Test
    public void testEmptySecondLevelObject() throws Exception {
        JsonTest.ComplexLvl1 expectedProto = JsonTest.ComplexLvl1.newBuilder().setTestInt(1L).setComplexLvl2(JsonTest.ComplexLvl2.newBuilder().build()).build();
        JSONObject complexLvl2 = new JSONObject();
        JSONObject json = new JSONObject();
        json.put("test_int", 1);
        json.put("complex_lvl2", (Object)complexLvl2);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.ComplexLvl1.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testAllowUnknownFieldsError() throws Exception {
        JSONObject json = new JSONObject();
        json.put("test_repeated", (Object)new JSONArray((Object)new int[]{1, 2, 3, 4, 5}));
        json.put("string", (Object)"hello");
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.RepeatedInt64.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject has fields unknown to BigQuery: root.string.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEmptyProtoMessage() throws Exception {
        JSONObject json = new JSONObject();
        json.put("test_repeated", (Object)new JSONArray((Object)new int[0]));
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.RepeatedInt64.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The created protobuf message is empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testEmptyJSONObject() throws Exception {
        JSONObject json = new JSONObject();
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)SchemaTest.Int64Type.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"JSONObject is empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullJson() throws Exception {
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)SchemaTest.Int64Type.getDescriptor(), null);
            Assert.fail((String)"Should fail");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"JSONObject is null.", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullDescriptor() throws Exception {
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage(null, (JSONObject)new JSONObject());
            Assert.fail((String)"Should fail");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"Protobuf descriptor is null.", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllowUnknownFieldsSecondLevel() throws Exception {
        JSONObject complex_lvl2 = new JSONObject();
        complex_lvl2.put("no_match", 1);
        JSONObject json = new JSONObject();
        json.put("test_int", 1);
        json.put("complex_lvl2", (Object)complex_lvl2);
        try {
            DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.ComplexLvl1.getDescriptor(), (JSONObject)json);
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"JSONObject has fields unknown to BigQuery: root.complex_lvl2.no_match.", (Object)e.getMessage());
        }
    }

    @Test
    public void testTopLevelMatchSecondLevelMismatch() throws Exception {
        JsonTest.ComplexLvl1 expectedProto = JsonTest.ComplexLvl1.newBuilder().setTestInt(1L).setComplexLvl2(JsonTest.ComplexLvl2.newBuilder().build()).build();
        JSONObject complex_lvl2 = new JSONObject();
        JSONObject json = new JSONObject();
        json.put("test_int", 1);
        json.put("complex_lvl2", (Object)complex_lvl2);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.ComplexLvl1.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }

    @Test
    public void testJsonNullValue() throws Exception {
        JsonTest.TestInt64 expectedProto = JsonTest.TestInt64.newBuilder().setInt(1L).build();
        JSONObject json = new JSONObject();
        json.put("long", JSONObject.NULL);
        json.put("int", 1);
        DynamicMessage protoMsg = com.google.cloud.bigquery.storage.v1beta2.JsonToProtoMessage.convertJsonToProtoMessage((Descriptors.Descriptor)JsonTest.TestInt64.getDescriptor(), (JSONObject)json);
        Assert.assertEquals((Object)expectedProto, (Object)protoMsg);
    }
}

