/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1beta2.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1beta2.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1beta2.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.TableName;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;

public class ITBigQueryTimeEncoderTest {
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "testtable";
    private static final String DESCRIPTION = "BigQuery Write Java manual client test dataset";
    private static BigQueryWriteClient client;
    private static TableInfo tableInfo;
    private static BigQuery bigquery;

    @BeforeClass
    public static void beforeClass() throws IOException {
        client = BigQueryWriteClient.create();
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_time_micros", (StandardSQLTypeName)StandardSQLTypeName.TIME, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_datetime_micros", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
        }
    }

    @Test
    public void TestTimeEncoding() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)TABLE);
        TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_str").build();
        TableFieldSchema TEST_TIME = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.TIME).setMode(TableFieldSchema.Mode.REPEATED).setName("test_time_micros").build();
        TableFieldSchema TEST_DATETIME = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.REPEATED).setName("test_datetime_micros").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, TEST_STRING).addFields(1, TEST_TIME).addFields(2, TEST_DATETIME).build();
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (TableSchema)tableSchema).build();){
            JSONObject row = new JSONObject();
            row.put("test_str", (Object)"Start of the day");
            row.put("test_time_micros", (Object)new JSONArray((Object)new long[]{CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)13, (int)14, (int)15, (int)16000000)), CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)23, (int)59, (int)59, (int)999999000)), CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)0, (int)0, (int)0, (int)0)), CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)1, (int)2, (int)3, (int)4000)), CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)LocalTime.of((int)5, (int)6, (int)7, (int)8000))}));
            row.put("test_datetime_micros", (Object)new JSONArray((Object)new long[]{CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)1, (int)1, (int)1, (int)12, (int)0, (int)0, (int)0)), CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)1995, (int)5, (int)19, (int)10, (int)30, (int)45, (int)0)), CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2000, (int)1, (int)1, (int)0, (int)0, (int)0, (int)0)), CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2026, (int)3, (int)11, (int)5, (int)45, (int)12, (int)9000000)), CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2050, (int)1, (int)2, (int)3, (int)4, (int)5, (int)6000))}));
            JSONArray jsonArr = new JSONArray((Object)new JSONObject[]{row});
            ApiFuture response = jsonStreamWriter.append(jsonArr, -1L);
            Assert.assertFalse((boolean)((AppendRowsResponse)response.get()).getAppendResult().hasOffset());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"Start of the day", (Object)currentRow.get(0).getValue());
            Assert.assertEquals((Object)"13:14:15.016000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(0)).getStringValue());
            Assert.assertEquals((Object)"23:59:59.999999", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"00:00:00", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(2)).getStringValue());
            Assert.assertEquals((Object)"01:02:03.000004", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(3)).getStringValue());
            Assert.assertEquals((Object)"05:06:07.000008", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(4)).getStringValue());
            Assert.assertEquals((Object)"0001-01-01T12:00:00", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(0)).getStringValue());
            Assert.assertEquals((Object)"1995-05-19T10:30:45", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2000-01-01T00:00:00", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(2)).getStringValue());
            Assert.assertEquals((Object)"2026-03-11T05:45:12.009000", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(3)).getStringValue());
            Assert.assertEquals((Object)"2050-01-02T03:04:05.000006", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(4)).getStringValue());
        }
    }
}

