/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.cloud.bigquery.storage.v1beta2.stub.EnhancedBigQueryReadStubSettings;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class EnhancedBigQueryReadStubSettingsTest {
    @Test
    public void testSettingsArePreserved() {
        String endpoint = "some.other.host:123";
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        Duration watchdogInterval = Duration.ofSeconds((long)12L);
        WatchdogProvider watchdogProvider = (WatchdogProvider)Mockito.mock(WatchdogProvider.class);
        EnhancedBigQueryReadStubSettings.Builder builder = (EnhancedBigQueryReadStubSettings.Builder)((EnhancedBigQueryReadStubSettings.Builder)((EnhancedBigQueryReadStubSettings.Builder)((EnhancedBigQueryReadStubSettings.Builder)EnhancedBigQueryReadStubSettings.newBuilder().setEndpoint(endpoint)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogCheckInterval(watchdogInterval)).setStreamWatchdogProvider(watchdogProvider);
        this.verifyBuilder(builder, endpoint, credentialsProvider, watchdogInterval, watchdogProvider);
        this.verifySettings(builder.build(), endpoint, credentialsProvider, watchdogInterval, watchdogProvider);
        this.verifyBuilder(builder.build().toBuilder(), endpoint, credentialsProvider, watchdogInterval, watchdogProvider);
    }

    private void verifyBuilder(EnhancedBigQueryReadStubSettings.Builder builder, String endpoint, CredentialsProvider credentialsProvider, Duration watchdogInterval, WatchdogProvider watchdogProvider) {
        Truth.assertThat((String)builder.getEndpoint()).isEqualTo((Object)endpoint);
        Truth.assertThat((Object)builder.getCredentialsProvider()).isEqualTo((Object)credentialsProvider);
        Truth.assertThat((Comparable)builder.getStreamWatchdogCheckInterval()).isEqualTo((Object)watchdogInterval);
        Truth.assertThat((Object)builder.getStreamWatchdogProvider()).isEqualTo((Object)watchdogProvider);
        InstantiatingGrpcChannelProvider channelProvider = (InstantiatingGrpcChannelProvider)builder.getTransportChannelProvider();
        Truth.assertThat((Integer)channelProvider.toBuilder().getMaxInboundMessageSize()).isEqualTo((Object)Integer.MAX_VALUE);
    }

    private void verifySettings(EnhancedBigQueryReadStubSettings settings, String endpoint, CredentialsProvider credentialsProvider, Duration watchdogInterval, WatchdogProvider watchdogProvider) {
        Truth.assertThat((String)settings.getEndpoint()).isEqualTo((Object)endpoint);
        Truth.assertThat((Object)settings.getCredentialsProvider()).isEqualTo((Object)credentialsProvider);
        Truth.assertThat((Comparable)settings.getStreamWatchdogCheckInterval()).isEqualTo((Object)watchdogInterval);
        Truth.assertThat((Object)settings.getStreamWatchdogProvider()).isEqualTo((Object)watchdogProvider);
        InstantiatingGrpcChannelProvider channelProvider = (InstantiatingGrpcChannelProvider)settings.getTransportChannelProvider();
        Truth.assertThat((Integer)channelProvider.toBuilder().getMaxInboundMessageSize()).isEqualTo((Object)Integer.MAX_VALUE);
    }

    @Test
    public void testCreateReadSessionSettings() {
        UnaryCallSettings.Builder builder = EnhancedBigQueryReadStubSettings.newBuilder().createReadSessionSettings();
        this.verifyRetrySettings(builder.getRetryableCodes(), builder.getRetrySettings());
    }

    @Test
    public void testReadRowsSettings() {
        ServerStreamingCallSettings.Builder builder = EnhancedBigQueryReadStubSettings.newBuilder().readRowsSettings();
        Truth.assertThat((Iterable)builder.getRetryableCodes()).contains((Object)StatusCode.Code.UNAVAILABLE);
        RetrySettings retrySettings = builder.getRetrySettings();
        Truth.assertThat((Comparable)retrySettings.getInitialRetryDelay()).isEqualTo((Object)Duration.ofMillis((long)100L));
        Truth.assertThat((Double)retrySettings.getRetryDelayMultiplier()).isWithin(1.0E-6).of(1.3);
        Truth.assertThat((Comparable)retrySettings.getMaxRetryDelay()).isEqualTo((Object)Duration.ofMinutes((long)1L));
        Truth.assertThat((Comparable)retrySettings.getInitialRpcTimeout()).isEqualTo((Object)Duration.ofDays((long)1L));
        Truth.assertThat((Double)retrySettings.getRpcTimeoutMultiplier()).isWithin(1.0E-6).of(1.0);
        Truth.assertThat((Comparable)retrySettings.getMaxRpcTimeout()).isEqualTo((Object)Duration.ofDays((long)1L));
        Truth.assertThat((Comparable)retrySettings.getTotalTimeout()).isEqualTo((Object)Duration.ofDays((long)1L));
        Truth.assertThat((Comparable)builder.getIdleTimeout()).isEqualTo((Object)Duration.ZERO);
    }

    @Test
    public void testSplitReadStreamSettings() {
        UnaryCallSettings.Builder builder = EnhancedBigQueryReadStubSettings.newBuilder().splitReadStreamSettings();
        this.verifyRetrySettings(builder.getRetryableCodes(), builder.getRetrySettings());
    }

    private void verifyRetrySettings(Set<StatusCode.Code> retryCodes, RetrySettings retrySettings) {
        Truth.assertThat(retryCodes).contains((Object)StatusCode.Code.UNAVAILABLE);
        Truth.assertThat((Comparable)retrySettings.getTotalTimeout()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Comparable)retrySettings.getInitialRetryDelay()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Double)retrySettings.getRetryDelayMultiplier()).isAtLeast((Comparable)Double.valueOf(1.0));
        Truth.assertThat((Comparable)retrySettings.getMaxRetryDelay()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Comparable)retrySettings.getInitialRpcTimeout()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Double)retrySettings.getRpcTimeoutMultiplier()).isAtLeast((Comparable)Double.valueOf(1.0));
        Truth.assertThat((Comparable)retrySettings.getMaxRpcTimeout()).isGreaterThan((Comparable)Duration.ZERO);
    }
}

