/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITBigQueryBigDecimalByteStringEncoderTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryBigDecimalByteStringEncoderTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "testtable";
    private static final String DESCRIPTION = "BigQuery Write Java manual client test dataset";
    private static BigQueryWriteClient client;
    private static TableInfo tableInfo;
    private static BigQuery bigquery;

    @BeforeClass
    public static void beforeClass() throws IOException {
        client = BigQueryWriteClient.create();
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_numeric_zero", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numeric_one", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numeric_repeated", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
        }
    }

    @Test
    public void TestBigDecimalEncoding() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)TABLE);
        TableFieldSchema TEST_NUMERIC_ZERO = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_zero").build();
        TableFieldSchema TEST_NUMERIC_ONE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_numeric_one").build();
        TableFieldSchema TEST_NUMERIC_REPEATED = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_numeric_repeated").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, TEST_NUMERIC_ZERO).addFields(1, TEST_NUMERIC_ONE).addFields(2, TEST_NUMERIC_REPEATED).build();
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (TableSchema)tableSchema).build();){
            JSONObject row = new JSONObject();
            row.put("test_numeric_zero", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("0")));
            row.put("test_numeric_one", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.2")));
            row.put("test_numeric_repeated", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("0")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("1.2")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-1.2")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("99999999999999999999999999999.999999999")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-99999999999999999999999999999.999999999")).toByteArray()}));
            JSONArray jsonArr = new JSONArray((Object)new JSONObject[]{row});
            ApiFuture response = jsonStreamWriter.append(jsonArr, -1L);
            AppendRowsResponse arr = (AppendRowsResponse)response.get();
            AppendRowsResponse.AppendResult ar = arr.getAppendResult();
            boolean ho = ar.hasOffset();
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"0", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"1.2", (Object)currentRow.get(1).getStringValue());
            Assert.assertEquals((Object)"0", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(0)).getStringValue());
            Assert.assertEquals((Object)"1.2", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"-1.2", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(2)).getStringValue());
            Assert.assertEquals((Object)"99999999999999999999999999999.999999999", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(3)).getStringValue());
            Assert.assertEquals((Object)"-99999999999999999999999999999.999999999", (Object)((FieldValue)currentRow.get(2).getRepeatedValue().get(4)).getStringValue());
        }
    }
}

