/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.it;

import com.google.api.client.util.Sleeper;
import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.ServiceOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.test.Test;
import com.google.cloud.bigquery.storage.test.TestOptional;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteSettings;
import com.google.cloud.bigquery.storage.v1.CivilTimeEncoder;
import com.google.cloud.bigquery.storage.v1.ConnectionWorkerPool;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.RequestProfiler;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.threeten.bp.LocalDateTime;

public class ITBigQueryWriteManualClientTest {
    private static final Logger LOG = Logger.getLogger(ITBigQueryWriteManualClientTest.class.getName());
    private static final String DATASET = RemoteBigQueryHelper.generateDatasetName();
    private static final String DATASET_EU = RemoteBigQueryHelper.generateDatasetName();
    private static final String TABLE = "testtable";
    private static final String TABLE2 = "complicatedtable";
    private static final String TEST_TRACE_ID = "DATAFLOW:job_id";
    private static final String DESCRIPTION = "BigQuery Write Java manual client test dataset";
    private static BigQueryWriteClient client;
    private static TableInfo tableInfo;
    private static TableInfo tableInfo2;
    private static TableInfo tableInfoEU;
    private static TableDefinition defaultValueTableDefinition;
    private static String tableId;
    private static String tableId2;
    private static String tableIdEU;
    private static BigQuery bigquery;
    private static final HeaderProvider USER_AGENT_HEADER_PROVIDER;

    @BeforeClass
    public static void beforeClass() throws IOException {
        BigQueryWriteSettings settings = ((BigQueryWriteSettings.Builder)BigQueryWriteSettings.newBuilder().setHeaderProvider(USER_AGENT_HEADER_PROVIDER)).build();
        client = BigQueryWriteClient.create((BigQueryWriteSettings)settings);
        RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
        bigquery = (BigQuery)bigqueryHelper.getOptions().getService();
        DatasetInfo datasetInfo = DatasetInfo.newBuilder((String)DATASET).setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfo, new BigQuery.DatasetOption[0]);
        LOG.info("Created test dataset: " + DATASET);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build()}))).build();
        Field.Builder innerTypeFieldBuilder = Field.newBuilder((String)"inner_type", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{Field.newBuilder((String)"value", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build()});
        tableInfo2 = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)TABLE2), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"nested_repeated_type", (LegacySQLTypeName)LegacySQLTypeName.RECORD, (Field[])new Field[]{innerTypeFieldBuilder.setMode(Field.Mode.REPEATED).build()}).setMode(Field.Mode.REPEATED).build(), innerTypeFieldBuilder.setMode(Field.Mode.NULLABLE).build()}))).build();
        defaultValueTableDefinition = StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo_with_default", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setDefaultValueExpression("'default_value_for_test'").setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"bar_without_default", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).setMode(Field.Mode.NULLABLE).build(), Field.newBuilder((String)"date_with_default_to_current", (LegacySQLTypeName)LegacySQLTypeName.TIMESTAMP, (Field[])new Field[0]).setDefaultValueExpression("CURRENT_TIMESTAMP()").setMode(Field.Mode.NULLABLE).build()}));
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        bigquery.create(tableInfo2, new BigQuery.TableOption[0]);
        tableId = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, TABLE);
        tableId2 = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, TABLE2);
        DatasetInfo datasetInfoEU = DatasetInfo.newBuilder((String)DATASET_EU).setLocation("EU").setDescription(DESCRIPTION).build();
        bigquery.create(datasetInfoEU, new BigQuery.DatasetOption[0]);
        tableInfoEU = TableInfo.newBuilder((TableId)TableId.of((String)DATASET_EU, (String)TABLE), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (LegacySQLTypeName)LegacySQLTypeName.STRING, (Field[])new Field[0]).build()}))).build();
        tableIdEU = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET_EU, TABLE);
        bigquery.create(tableInfoEU, new BigQuery.TableOption[0]);
    }

    @AfterClass
    public static void afterClass() {
        if (client != null) {
            client.close();
        }
        if (bigquery != null) {
            RemoteBigQueryHelper.forceDelete((BigQuery)bigquery, (String)DATASET);
            LOG.info("Deleted test dataset: " + DATASET);
        }
    }

    ProtoRows CreateProtoRows(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.FooType foo = Test.FooType.newBuilder().setFoo(message).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    ProtoSchema CreateProtoSchemaWithColField() {
        return ProtoSchema.newBuilder().setProtoDescriptor(DescriptorProtos.DescriptorProto.newBuilder().setName("testProto").addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("col1").setNumber(1).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build()).build()).build();
    }

    ProtoRows CreateProtoOptionalRows(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            TestOptional.FooOptionalType foo = TestOptional.FooOptionalType.newBuilder().setFoo(message).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    ProtoRows CreateProtoRowsMultipleColumns(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.UpdatedFooType foo = Test.UpdatedFooType.newBuilder().setFoo(message).setBar(message).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    ProtoRows CreateProtoRowsComplex(String[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (String message : messages) {
            Test.ComplicateType foo = Test.ComplicateType.newBuilder().setInnerType(Test.InnerType.newBuilder().addValue(message).addValue(message).build()).build();
            rows.addSerializedRows(foo.toByteString());
        }
        return rows.build();
    }

    ProtoRows CreateProtoRowsMixed(StringWithSecondsNanos[] messages) {
        ProtoRows.Builder rows = ProtoRows.newBuilder();
        for (StringWithSecondsNanos message : messages) {
            Test.FooTimestampType datum = Test.FooTimestampType.newBuilder().setFoo(message.foo).setBar(Timestamp.newBuilder().setSeconds(message.seconds).setNanos(message.nanos).build()).build();
            rows.addSerializedRows(datum.toByteString());
        }
        return rows.build();
    }

    @Test
    public void testBatchWriteWithCommittedStreamEU() throws IOException, InterruptedException, ExecutionException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableIdEU).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();
        LOG.info("Sending one message");
        ApiFuture response = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), 0L);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        LOG.info("Sending two more messages");
        ApiFuture response1 = streamWriter.append(this.CreateProtoRows(new String[]{"bbb", "ccc"}), 1L);
        ApiFuture response2 = streamWriter.append(this.CreateProtoRows(new String[]{"ddd"}), 3L);
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
    }

    @Test
    public void testProto3OptionalBatchWriteWithCommittedStream() throws IOException, InterruptedException, ExecutionException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)TestOptional.FooOptionalType.getDescriptor())).build();
        LOG.info("Sending one message");
        ApiFuture response = streamWriter.append(this.CreateProtoOptionalRows(new String[]{"aaa"}), 0L);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        LOG.info("Sending two more messages");
        ApiFuture response1 = streamWriter.append(this.CreateProtoOptionalRows(new String[]{"bbb", "ccc"}), 1L);
        ApiFuture response2 = streamWriter.append(this.CreateProtoOptionalRows(new String[]{""}), 3L);
        Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
    }

    @Test
    public void testJsonStreamWriterCommittedStream() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "JsonTable";
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numerics", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_datetime", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test_str", (Object)"aaa");
            row1.put("test_numerics", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("123.4")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-9000000")).toByteArray()}));
            row1.put("test_datetime", CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2020, (int)10, (int)1, (int)12, (int)0)));
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row1.put("test_str", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row2.put("test_str", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row1);
            jsonArr2.put((Object)row2);
            JSONObject row4 = new JSONObject();
            row4.put("test_str", (Object)"ddd");
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            LOG.info("Sending two more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending one more message");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"-9000000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2020-10-01T12:00:00", (Object)currentRow.get(2).getStringValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testRowErrors() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "TestBadRowsTable";
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"foo", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).setMaxLength(Long.valueOf(10L)).build(), Field.newBuilder((String)"bar", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        StreamWriter streamWriter = StreamWriter.newBuilder((String)(parent.toString() + "/_default")).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooTimestampType.getDescriptor())).build();
        LOG.info("Sending three messages");
        StringWithSecondsNanos[] myBadList = new StringWithSecondsNanos[]{new StringWithSecondsNanos("aaabbbcccddd", 1663821424L, 0), new StringWithSecondsNanos("bbb", Long.MIN_VALUE, 0), new StringWithSecondsNanos("cccdddeeefffggg", 1663621424L, 0)};
        ApiFuture futureResponse = streamWriter.append(this.CreateProtoRowsMixed(myBadList), -1L);
        AppendRowsResponse actualResponse = null;
        try {
            actualResponse = (AppendRowsResponse)futureResponse.get();
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)(t instanceof ExecutionException));
            t = t.getCause();
            Assert.assertTrue((boolean)(t instanceof Exceptions.AppendSerializationError));
            Exceptions.AppendSerializationError e = (Exceptions.AppendSerializationError)t;
            LOG.info("Found row errors on stream: " + e.getStreamName());
            Assert.assertEquals((Object)"Field foo: STRING(10) has maximum length 10 but got a value with length 12 on field foo.", e.getRowIndexToErrorMessage().get(0));
            Assert.assertEquals((Object)"Timestamp field value is out of range: -9223372036854775808 on field bar.", e.getRowIndexToErrorMessage().get(1));
            Assert.assertEquals((Object)"Field foo: STRING(10) has maximum length 10 but got a value with length 15 on field foo.", e.getRowIndexToErrorMessage().get(2));
            for (Map.Entry entry : e.getRowIndexToErrorMessage().entrySet()) {
                LOG.info("Bad row index: " + entry.getKey() + ", has problem: " + (String)entry.getValue());
            }
        }
        Assert.assertEquals(null, (Object)actualResponse);
        LOG.info("Resending with three good messages");
        StringWithSecondsNanos[] myGoodList = new StringWithSecondsNanos[]{new StringWithSecondsNanos("aaa", 1664821424L, 0), new StringWithSecondsNanos("bbb", 1663821424L, 0), new StringWithSecondsNanos("ccc", 1664801424L, 0)};
        ApiFuture futureResponse1 = streamWriter.append(this.CreateProtoRowsMixed(myGoodList), -1L);
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)futureResponse1.get()).getAppendResult().getOffset().getValue());
        TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
        for (FieldValueList currentRow : result.getValues()) {
            LOG.info("Table row contains " + currentRow.size() + " field values.");
            LOG.info("Table column has foo: " + currentRow.get(0).getStringValue());
            LOG.info("Table column has bar: " + currentRow.get(1).getTimestampValue());
        }
        Iterator iter = result.getValues().iterator();
        FieldValueList currentRow = (FieldValueList)iter.next();
        Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
        Assert.assertEquals((long)1664821424000000L, (long)currentRow.get(1).getTimestampValue());
        currentRow = (FieldValueList)iter.next();
        Assert.assertEquals((Object)"bbb", (Object)currentRow.get(0).getStringValue());
        Assert.assertEquals((long)1663821424000000L, (long)currentRow.get(1).getTimestampValue());
        currentRow = (FieldValueList)iter.next();
        Assert.assertEquals((Object)"ccc", (Object)currentRow.get(0).getStringValue());
        Assert.assertEquals((long)1664801424000000L, (long)currentRow.get(1).getTimestampValue());
        Assert.assertEquals((Object)false, (Object)iter.hasNext());
    }

    @Test
    public void testRequestProfilerWithCommittedStream() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        String tableName = "TestProfiler";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema schema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        int totalRequest = 50;
        int rowBatch = 1200;
        ArrayList<ApiFuture> allResponses = new ArrayList<ApiFuture>(totalRequest);
        RequestProfiler.setReportPeriod((Duration)Duration.ofMillis(300L));
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).setEnableLatencyProfiler(true).build();){
            for (int k = 0; k < totalRequest; ++k) {
                JSONObject row = new JSONObject();
                row.put("col1", (Object)"aaaaa");
                JSONArray jsonArr = new JSONArray();
                for (int j = 0; j < rowBatch; ++j) {
                    jsonArr.put((Object)row);
                }
                LOG.info("Appending: " + k + "/" + totalRequest);
                Sleeper.DEFAULT.sleep(50L);
                allResponses.add(jsonStreamWriter.append(jsonArr, (long)(k * rowBatch)));
            }
        }
        LOG.info("Waiting for all responses to come back");
        for (int i = 0; i < totalRequest; ++i) {
            try {
                Assert.assertEquals((long)((AppendRowsResponse)((ApiFuture)allResponses.get(i)).get()).getAppendResult().getOffset().getValue(), (long)(i * rowBatch));
                continue;
            }
            catch (ExecutionException ex) {
                Assert.fail((String)("Unexpected error " + ex));
            }
        }
        RequestProfiler.disableAndResetProfiler();
    }

    @Test
    public void testJsonStreamWriterWithDefaultSchema() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "JsonTableDefaultSchema";
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numerics", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_datetime", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_bytestring_repeated", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_timestamp", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_json", (StandardSQLTypeName)StandardSQLTypeName.JSON, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (BigQueryWriteClient)client).setIgnoreUnknownFields(true).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test_str", (Object)"aaa");
            row1.put("test_numerics", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("123.4")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-9000000")).toByteArray()}));
            row1.put("unknown_field", (Object)"a");
            row1.put("test_datetime", CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2020, (int)10, (int)1, (int)12, (int)0)));
            row1.put("test_bytestring_repeated", (Object)new JSONArray((Object)new byte[][]{ByteString.copyFromUtf8((String)"a").toByteArray(), ByteString.copyFromUtf8((String)"b").toByteArray()}));
            row1.put("test_timestamp", (Object)"2022-02-06 07:24:47.84");
            row1.put("test_json", (Object)"{}");
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row1.put("test_str", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row2.put("test_str", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row1);
            jsonArr2.put((Object)row2);
            JSONObject row4 = new JSONObject();
            row4.put("test_str", (Object)"ddd");
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            JSONObject row5 = new JSONObject();
            JSONArray testArr = new JSONArray();
            testArr.put(0, (Object)ByteString.copyFromUtf8((String)"a").toByteArray());
            testArr.put(1, (Object)ByteString.copyFromUtf8((String)"b").toByteArray());
            row5.put("test_bytestring_repeated", (Object)testArr);
            JSONArray jsonArr4 = new JSONArray();
            jsonArr4.put((Object)row5);
            LOG.info("Sending three more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending two more messages");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            LOG.info("Sending one more message");
            ApiFuture response4 = jsonStreamWriter.append(jsonArr4, -1L);
            Assert.assertFalse((boolean)((AppendRowsResponse)response2.get()).getAppendResult().hasOffset());
            Assert.assertFalse((boolean)((AppendRowsResponse)response3.get()).getAppendResult().hasOffset());
            Assert.assertFalse((boolean)((AppendRowsResponse)response4.get()).getAppendResult().hasOffset());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"-9000000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2020-10-01T12:00:00", (Object)currentRow.get(2).getStringValue());
            Assert.assertEquals((long)2L, (long)currentRow.get(3).getRepeatedValue().size());
            Assert.assertEquals((Object)"Yg==", (Object)((FieldValue)currentRow.get(3).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            FieldValueList currentRow2 = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"YQ==", (Object)((FieldValue)currentRow2.get(3).getRepeatedValue().get(0)).getStringValue());
            Assert.assertEquals((Object)"Yg==", (Object)((FieldValue)currentRow2.get(3).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testJsonStreamWriterWithDefaultSchemaNoTable() {
        String tableName = "JsonStreamWriterWithDefaultSchemaNoTable";
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        try {
            JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (BigQueryWriteClient)client).setIgnoreUnknownFields(true).build();
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)exception.getMessage().contains("it may not exist"));
        }
    }

    @Test
    public void testJsonStreamWriterWithDefaultStream() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "JsonTableDefaultStream";
        TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_str").build();
        TableFieldSchema TEST_NUMERIC = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.NUMERIC).setMode(TableFieldSchema.Mode.REPEATED).setName("test_numerics").build();
        TableFieldSchema TEST_DATE = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.DATETIME).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_datetime").build();
        TableFieldSchema TEST_REPEATED_BYTESTRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.BYTES).setMode(TableFieldSchema.Mode.REPEATED).setName("test_bytestring_repeated").build();
        TableFieldSchema TEST_TIMESTAMP = TableFieldSchema.newBuilder().setName("test_timeStamp").setType(TableFieldSchema.Type.TIMESTAMP).setMode(TableFieldSchema.Mode.NULLABLE).build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, TEST_STRING).addFields(1, TEST_DATE).addFields(2, TEST_NUMERIC).addFields(3, TEST_REPEATED_BYTESTRING).addFields(4, TEST_TIMESTAMP).build();
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_numerics", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_datetime", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).build(), Field.newBuilder((String)"test_bytestring_repeated", (StandardSQLTypeName)StandardSQLTypeName.BYTES, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test_timestamp", (StandardSQLTypeName)StandardSQLTypeName.TIMESTAMP, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (TableSchema)tableSchema).setIgnoreUnknownFields(true).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test_str", (Object)"aaa");
            row1.put("test_numerics", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("123.4")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-9000000")).toByteArray()}));
            row1.put("unknown_field", (Object)"a");
            row1.put("test_datetime", CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2020, (int)10, (int)1, (int)12, (int)0)));
            row1.put("test_bytestring_repeated", (Object)new JSONArray((Object)new byte[][]{ByteString.copyFromUtf8((String)"a").toByteArray(), ByteString.copyFromUtf8((String)"b").toByteArray()}));
            row1.put("test_timestamp", (Object)"2022-02-06 07:24:47.84");
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row1.put("test_str", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row2.put("test_str", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row1);
            jsonArr2.put((Object)row2);
            JSONObject row4 = new JSONObject();
            row4.put("test_str", (Object)"ddd");
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            JSONObject row5 = new JSONObject();
            JSONArray testArr = new JSONArray();
            testArr.put(0, (Object)ByteString.copyFromUtf8((String)"a").toByteArray());
            testArr.put(1, (Object)ByteString.copyFromUtf8((String)"b").toByteArray());
            row5.put("test_bytestring_repeated", (Object)testArr);
            JSONArray jsonArr4 = new JSONArray();
            jsonArr4.put((Object)row5);
            LOG.info("Sending three more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending two more messages");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            LOG.info("Sending one more message");
            ApiFuture response4 = jsonStreamWriter.append(jsonArr4, -1L);
            Assert.assertFalse((boolean)((AppendRowsResponse)response2.get()).getAppendResult().hasOffset());
            Assert.assertFalse((boolean)((AppendRowsResponse)response3.get()).getAppendResult().hasOffset());
            Assert.assertFalse((boolean)((AppendRowsResponse)response4.get()).getAppendResult().hasOffset());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"-9000000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2020-10-01T12:00:00", (Object)currentRow.get(2).getStringValue());
            Assert.assertEquals((long)2L, (long)currentRow.get(3).getRepeatedValue().size());
            Assert.assertEquals((Object)"Yg==", (Object)((FieldValue)currentRow.get(3).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((long)(java.sql.Timestamp.valueOf("2022-02-06 07:24:47.84").toLocalDateTime().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() * 1000L), (long)currentRow.get(4).getTimestampValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            FieldValueList currentRow2 = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"YQ==", (Object)((FieldValue)currentRow2.get(3).getRepeatedValue().get(0)).getStringValue());
            Assert.assertEquals((Object)"Yg==", (Object)((FieldValue)currentRow2.get(3).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testJsonDefaultStreamOnTableWithDefaultValue_SchemaNotGiven() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException, ParseException {
        String tableName = "defaultStreamDefaultValue";
        String defaultTableId = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, tableName);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)defaultValueTableDefinition).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)defaultTableId, (BigQueryWriteClient)client).setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE).build();){
            this.testJsonStreamWriterForDefaultValue(jsonStreamWriter);
        }
    }

    @Test
    public void testJsonExclusiveStreamOnTableWithDefaultValue_GiveTableSchema() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException, ParseException {
        String tableName = "exclusiveStreamDefaultValue";
        String exclusiveTableId = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, tableName);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)defaultValueTableDefinition).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(exclusiveTableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)exclusiveTableId, (TableSchema)writeStream.getTableSchema()).setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE).build();){
            this.testJsonStreamWriterForDefaultValue(jsonStreamWriter);
        }
    }

    private void testJsonStreamWriterForDefaultValue(JsonStreamWriter jsonStreamWriter) throws Descriptors.DescriptorValidationException, IOException, ExecutionException, InterruptedException, ParseException {
        JSONArray jsonArr1 = new JSONArray();
        JSONObject row1 = new JSONObject();
        row1.put("foo_with_default", (Object)"aaa");
        row1.put("bar_without_default", (Object)"a");
        row1.put("date_with_default_to_current", (Object)"2022-02-02 01:02:03");
        jsonArr1.put((Object)row1);
        JSONObject row2 = new JSONObject();
        row2.put("bar_without_default", (Object)"a");
        jsonArr1.put((Object)row2);
        JSONObject row3 = new JSONObject();
        jsonArr1.put((Object)row3);
        ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
        response1.get();
        TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
        Iterator iter = result.getValues().iterator();
        FieldValueList currentRow = (FieldValueList)iter.next();
        Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
        Assert.assertEquals((Object)"a", (Object)currentRow.get(1).getStringValue());
        Assert.assertEquals((long)java.sql.Timestamp.valueOf("2022-02-02 01:02:03").toLocalDateTime().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli(), (long)(Double.valueOf(currentRow.get(2).getStringValue()).longValue() * 1000L));
        currentRow = (FieldValueList)iter.next();
        Assert.assertEquals((Object)"default_value_for_test", (Object)currentRow.get(0).getStringValue());
        Assert.assertFalse((boolean)currentRow.get(2).getStringValue().isEmpty());
        Assert.assertEquals((Object)"a", (Object)currentRow.get(1).getStringValue());
        Instant parsedInstant = Instant.ofEpochSecond(Double.valueOf(currentRow.get(2).getStringValue()).longValue());
        Assert.assertTrue((boolean)parsedInstant.isAfter(Instant.now().minus(1L, ChronoUnit.HOURS)));
        currentRow = (FieldValueList)iter.next();
        Assert.assertEquals((Object)"default_value_for_test", (Object)currentRow.get(0).getStringValue());
        Assert.assertEquals(null, (Object)currentRow.get(1).getValue());
        Assert.assertFalse((boolean)currentRow.get(2).getStringValue().isEmpty());
        parsedInstant = Instant.ofEpochSecond(Double.valueOf(currentRow.get(2).getStringValue()).longValue());
        Assert.assertTrue((boolean)parsedInstant.isAfter(Instant.now().minus(1L, ChronoUnit.HOURS)));
        Assert.assertEquals((Object)false, (Object)iter.hasNext());
    }

    @Test
    public void testStreamWriterWithDefaultValue() throws ExecutionException, InterruptedException {
        String tableName = "streamWriterWithDefaultValue";
        String exclusiveTableId = String.format("projects/%s/datasets/%s/tables/%s", ServiceOptions.getDefaultProjectId(), DATASET, tableName);
        tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)defaultValueTableDefinition).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)(exclusiveTableId + "/_default")).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.SimpleTypeForDefaultValue.getDescriptor())).setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE).setEnableConnectionPool(true).setTraceId(TEST_TRACE_ID).build();){
            Test.SimpleTypeForDefaultValue simpleTypeForDefaultValue1 = Test.SimpleTypeForDefaultValue.newBuilder().setFooWithDefault("foo_value").setBarWithoutDefault("bar_value").setDateWithDefaultToCurrent("2022-02-02 01:02:03").build();
            Test.SimpleTypeForDefaultValue simpleTypeForDefaultValue2 = Test.SimpleTypeForDefaultValue.newBuilder().build();
            ProtoRows rows = ProtoRows.newBuilder().addSerializedRows(simpleTypeForDefaultValue1.toByteString()).addSerializedRows(simpleTypeForDefaultValue2.toByteString()).build();
            ApiFuture response1 = streamWriter.append(rows);
            response1.get();
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"foo_value", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"bar_value", (Object)currentRow.get(1).getStringValue());
            Assert.assertEquals((long)java.sql.Timestamp.valueOf("2022-02-02 01:02:03").toLocalDateTime().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli(), (long)(Double.valueOf(currentRow.get(2).getStringValue()).longValue() * 1000L));
            currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"default_value_for_test", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals(null, (Object)currentRow.get(1).getValue());
            Assert.assertFalse((boolean)currentRow.get(2).getStringValue().isEmpty());
            Instant parsedInstant = Instant.ofEpochSecond(Double.valueOf(currentRow.get(2).getStringValue()).longValue());
            Assert.assertTrue((boolean)parsedInstant.isAfter(Instant.now().minus(1L, ChronoUnit.HOURS)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testJsonStreamWriterWithMessagesOver10M() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "TableLarge";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema schema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        int totalRequest = 10;
        int rowBatch = 40000;
        ArrayList<ApiFuture> allResponses = new ArrayList<ApiFuture>(totalRequest);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).build();){
            for (int k = 0; k < totalRequest; ++k) {
                JSONObject row = new JSONObject();
                row.put("col1", (Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
                JSONArray jsonArr = new JSONArray();
                for (int j = 0; j < rowBatch; ++j) {
                    jsonArr.put((Object)row);
                }
                LOG.info("Appending: " + k + "/" + totalRequest);
                allResponses.add(jsonStreamWriter.append(jsonArr, (long)(k * rowBatch)));
            }
        }
        LOG.info("Waiting for all responses to come back");
        for (int i = 0; i < totalRequest; ++i) {
            try {
                Assert.assertEquals((long)((AppendRowsResponse)((ApiFuture)allResponses.get(i)).get()).getAppendResult().getOffset().getValue(), (long)(i * rowBatch));
                continue;
            }
            catch (ExecutionException ex) {
                Assert.fail((String)("Unexpected error " + ex));
            }
        }
    }

    @Test
    public void testJsonStreamWriterSchemaUpdate() throws Descriptors.DescriptorValidationException, IOException, InterruptedException, ExecutionException {
        String tableName = "SchemaUpdateTestTable";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema originalSchema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)originalSchema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (BigQueryWriteClient)client).build();){
            int j;
            JSONObject foo = new JSONObject();
            foo.put("col1", (Object)"aaa");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            ApiFuture response = jsonStreamWriter.append(jsonArr, 0L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
            Field col2 = Field.newBuilder((String)"col2", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
            Schema updatedSchema = Schema.of((Iterable)ImmutableList.of((Object)col1, (Object)col2));
            TableInfo updatedTableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)updatedSchema)).build();
            Table updatedTable = bigquery.update(updatedTableInfo, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)updatedSchema, (Object)updatedTable.getDefinition().getSchema());
            JSONObject foo2 = new JSONObject();
            foo2.put("col1", (Object)"bbb");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)foo2);
            int next = 0;
            for (int i = 1; i < 100; ++i) {
                ApiFuture response2 = jsonStreamWriter.append(jsonArr2, (long)i);
                Assert.assertEquals((long)i, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
                if (((AppendRowsResponse)response2.get()).hasUpdatedSchema()) {
                    next = i;
                    break;
                }
                Thread.sleep(1000L);
            }
            JSONObject updatedFoo = new JSONObject();
            updatedFoo.put("col1", (Object)"ccc");
            updatedFoo.put("col2", (Object)"ddd");
            JSONArray updatedJsonArr = new JSONArray();
            updatedJsonArr.put((Object)updatedFoo);
            for (int i = 0; i < 10; ++i) {
                ApiFuture response3 = jsonStreamWriter.append(updatedJsonArr, (long)(next + 1 + i));
                Assert.assertEquals((long)(next + 1 + i), (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
            }
            Iterator rowsIter = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]).getValues().iterator();
            Assert.assertEquals((Object)"aaa", (Object)((FieldValueList)rowsIter.next()).get(0).getStringValue());
            for (j = 1; j <= next; ++j) {
                Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)rowsIter.next()).get(0).getStringValue());
            }
            for (j = next + 1; j < next + 1 + 10; ++j) {
                FieldValueList temp = (FieldValueList)rowsIter.next();
                Assert.assertEquals((Object)"ccc", (Object)temp.get(0).getStringValue());
                Assert.assertEquals((Object)"ddd", (Object)temp.get(1).getStringValue());
            }
            Assert.assertFalse((boolean)rowsIter.hasNext());
        }
    }

    @Test
    public void testJsonStreamWriterSchemaUpdateConcurrent() throws Descriptors.DescriptorValidationException, IOException, InterruptedException {
        String tableName = "ConcurrentSchemaUpdateTestTable";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema originalSchema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)originalSchema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        JSONObject foo = new JSONObject();
        foo.put("col1", (Object)"aaa");
        JSONArray jsonArr = new JSONArray();
        jsonArr.put((Object)foo);
        JSONObject foo2 = new JSONObject();
        foo2.put("col1", (Object)"bbb");
        JSONArray jsonArr2 = new JSONArray();
        jsonArr2.put((Object)foo2);
        JSONObject updatedFoo = new JSONObject();
        updatedFoo.put("col1", (Object)"ccc");
        updatedFoo.put("col2", (Object)"ddd");
        JSONArray updatedJsonArr = new JSONArray();
        updatedJsonArr.put((Object)updatedFoo);
        Field col2 = Field.newBuilder((String)"col2", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema updatedSchema = Schema.of((Iterable)ImmutableList.of((Object)col1, (Object)col2));
        TableInfo updatedTableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)updatedSchema)).build();
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (BigQueryWriteClient)client).build();){
            int numberOfThreads = 5;
            ExecutorService streamTaskExecutor = Executors.newFixedThreadPool(5);
            CountDownLatch latch = new CountDownLatch(numberOfThreads);
            AtomicInteger next = new AtomicInteger();
            Runnable updateTableSchemaTask = () -> {
                Table updatedTable = bigquery.update(updatedTableInfo, new BigQuery.TableOption[0]);
                Assert.assertEquals((Object)updatedSchema, (Object)updatedTable.getDefinition().getSchema());
            };
            streamTaskExecutor.execute(updateTableSchemaTask);
            for (int i = 0; i < numberOfThreads; ++i) {
                streamTaskExecutor.submit(() -> {
                    for (int j = 0; j < 2; ++j) {
                        try {
                            jsonStreamWriter.append(jsonArr);
                            next.getAndIncrement();
                            continue;
                        }
                        catch (Descriptors.DescriptorValidationException | IOException e) {
                            e.printStackTrace();
                        }
                    }
                    for (int w = 0; w < 15; ++w) {
                        ApiFuture response2 = null;
                        try {
                            response2 = jsonStreamWriter.append(jsonArr2);
                            next.getAndIncrement();
                        }
                        catch (Descriptors.DescriptorValidationException | IOException e) {
                            LOG.severe("Issue with append " + e.getMessage());
                        }
                        try {
                            assert (response2 != null);
                            if (((AppendRowsResponse)response2.get()).hasUpdatedSchema()) break;
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LOG.severe("Issue with append " + e.getMessage());
                        }
                    }
                    for (int m = 0; m < 5; ++m) {
                        try {
                            jsonStreamWriter.append(updatedJsonArr);
                            next.getAndIncrement();
                            continue;
                        }
                        catch (Descriptors.DescriptorValidationException | IOException e) {
                            LOG.severe("Issue with append " + e.getMessage());
                        }
                    }
                    latch.countDown();
                });
            }
            latch.await();
            Iterator rowsIter = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]).getValues().iterator();
            int position = 0;
            while (rowsIter.hasNext()) {
                FieldValueList row = (FieldValueList)rowsIter.next();
                if (++position <= next.get() - 5) continue;
                Assert.assertEquals((Object)"ccc", (Object)row.get(0).getStringValue());
                Assert.assertEquals((Object)"ddd", (Object)row.get(1).getStringValue());
            }
        }
    }

    @Test
    public void testJsonStreamWriterWithFlexibleColumnName() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "FlexibleColumnTable";
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test-str\u5217", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test-numerics\u5217", (StandardSQLTypeName)StandardSQLTypeName.NUMERIC, (Field[])new Field[0]).setMode(Field.Mode.REPEATED).build(), Field.newBuilder((String)"test-datetime\u5217", (StandardSQLTypeName)StandardSQLTypeName.DATETIME, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test-str\u5217", (Object)"aaa");
            row1.put("test-numerics\u5217", (Object)new JSONArray((Object)new byte[][]{BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("123.4")).toByteArray(), BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("-9000000")).toByteArray()}));
            row1.put("test-datetime\u5217", CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)LocalDateTime.of((int)2020, (int)10, (int)1, (int)12, (int)0)));
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row2.put("test-str\u5217", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row3.put("test-str\u5217", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row2);
            jsonArr2.put((Object)row3);
            JSONObject row4 = new JSONObject();
            row4.put("test-str\u5217", (Object)"ddd");
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            LOG.info("Sending two more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending one more message");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            Assert.assertEquals((Object)"-9000000", (Object)((FieldValue)currentRow.get(1).getRepeatedValue().get(1)).getStringValue());
            Assert.assertEquals((Object)"2020-10-01T12:00:00", (Object)currentRow.get(2).getStringValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ddd", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testJsonStreamWriterWithNestedFlexibleColumnName() throws IOException, InterruptedException, ExecutionException, Descriptors.DescriptorValidationException {
        String tableName = "NestedFlexibleColumnTable";
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)DATASET, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test-str\u5217", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build(), Field.newBuilder((String)"test-record\u5217", (StandardSQLTypeName)StandardSQLTypeName.STRUCT, (Field[])new Field[]{Field.of((String)"nested-str\u5217", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]), Field.of((String)"nested-int\u5217", (StandardSQLTypeName)StandardSQLTypeName.INT64, (Field[])new Field[0])}).setMode(Field.Mode.REPEATED).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).build();){
            LOG.info("Sending one message");
            JSONObject row1 = new JSONObject();
            row1.put("test-str\u5217", (Object)"aaa");
            JSONObject record1 = new JSONObject();
            record1.put("nested-str\u5217", (Object)"nested-str1");
            record1.put("nested-int\u5217", 10);
            row1.put("test-record\u5217", (Object)new JSONArray((Object)new JSONObject[]{record1}));
            JSONArray jsonArr1 = new JSONArray((Object)new JSONObject[]{row1});
            ApiFuture response1 = jsonStreamWriter.append(jsonArr1, -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
            JSONObject row2 = new JSONObject();
            row2.put("test-str\u5217", (Object)"bbb");
            JSONObject row3 = new JSONObject();
            row3.put("test-str\u5217", (Object)"ccc");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)row2);
            jsonArr2.put((Object)row3);
            JSONObject row4 = new JSONObject();
            row4.put("test-str\u5217", (Object)"ddd");
            JSONObject record2 = new JSONObject();
            record2.put("nested-str\u5217", (Object)"nested-str2");
            record2.put("nested-int\u5217", 20);
            row4.put("test-record\u5217", (Object)new JSONArray((Object)new JSONObject[]{record2}));
            JSONArray jsonArr3 = new JSONArray();
            jsonArr3.put((Object)row4);
            LOG.info("Sending two more messages");
            ApiFuture response2 = jsonStreamWriter.append(jsonArr2, -1L);
            LOG.info("Sending one more message");
            ApiFuture response3 = jsonStreamWriter.append(jsonArr3, -1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
            Assert.assertEquals((long)3L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
            TableResult result = bigquery.listTableData(tableInfo.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            FieldValueList currentRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"aaa", (Object)currentRow.get(0).getStringValue());
            FieldValueList currentRecord = ((FieldValue)currentRow.get(1).getRepeatedValue().get(0)).getRecordValue();
            Assert.assertEquals((Object)"nested-str1", (Object)currentRecord.get(0).getStringValue());
            Assert.assertEquals((Object)"10", (Object)currentRecord.get(1).getStringValue());
            Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            Assert.assertEquals((Object)"ccc", (Object)((FieldValueList)iter.next()).get(0).getStringValue());
            FieldValueList lastRow = (FieldValueList)iter.next();
            Assert.assertEquals((Object)"ddd", (Object)lastRow.get(0).getStringValue());
            FieldValueList lastRecord = ((FieldValue)lastRow.get(1).getRepeatedValue().get(0)).getRecordValue();
            Assert.assertEquals((Object)"nested-str2", (Object)lastRecord.get(0).getStringValue());
            Assert.assertEquals((Object)"20", (Object)lastRecord.get(1).getStringValue());
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
        }
    }

    @Test
    public void testJsonStreamWriterSchemaUpdateWithFlexibleColumnName() throws Descriptors.DescriptorValidationException, IOException, InterruptedException, ExecutionException {
        String tableName = "SchemaUpdateFlexColumnTestTable";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1-\u5217", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema originalSchema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)originalSchema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (BigQueryWriteClient)client).build();){
            int j;
            JSONObject foo = new JSONObject();
            foo.put("col1-\u5217", (Object)"aaa");
            JSONArray jsonArr = new JSONArray();
            jsonArr.put((Object)foo);
            ApiFuture response = jsonStreamWriter.append(jsonArr, 0L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
            Field col2 = Field.newBuilder((String)"col2-\u5217", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
            Schema updatedSchema = Schema.of((Iterable)ImmutableList.of((Object)col1, (Object)col2));
            TableInfo updatedTableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)updatedSchema)).build();
            Table updatedTable = bigquery.update(updatedTableInfo, new BigQuery.TableOption[0]);
            Assert.assertEquals((Object)updatedSchema, (Object)updatedTable.getDefinition().getSchema());
            JSONObject foo2 = new JSONObject();
            foo2.put("col1-\u5217", (Object)"bbb");
            JSONArray jsonArr2 = new JSONArray();
            jsonArr2.put((Object)foo2);
            int next = 0;
            for (int i = 1; i < 100; ++i) {
                ApiFuture response2 = jsonStreamWriter.append(jsonArr2, (long)i);
                Assert.assertEquals((long)i, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
                if (((AppendRowsResponse)response2.get()).hasUpdatedSchema()) {
                    next = i;
                    break;
                }
                Thread.sleep(1000L);
            }
            JSONObject updatedFoo = new JSONObject();
            updatedFoo.put("col1-\u5217", (Object)"ccc");
            updatedFoo.put("col2-\u5217", (Object)"ddd");
            JSONArray updatedJsonArr = new JSONArray();
            updatedJsonArr.put((Object)updatedFoo);
            for (int i = 0; i < 10; ++i) {
                ApiFuture response3 = jsonStreamWriter.append(updatedJsonArr, (long)(next + 1 + i));
                Assert.assertEquals((long)(next + 1 + i), (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
            }
            Iterator rowsIter = bigquery.listTableData(tableId, new BigQuery.TableDataListOption[0]).getValues().iterator();
            Assert.assertEquals((Object)"aaa", (Object)((FieldValueList)rowsIter.next()).get(0).getStringValue());
            for (j = 1; j <= next; ++j) {
                Assert.assertEquals((Object)"bbb", (Object)((FieldValueList)rowsIter.next()).get(0).getStringValue());
            }
            for (j = next + 1; j < next + 1 + 10; ++j) {
                FieldValueList temp = (FieldValueList)rowsIter.next();
                Assert.assertEquals((Object)"ccc", (Object)temp.get(0).getStringValue());
                Assert.assertEquals((Object)"ddd", (Object)temp.get(1).getStringValue());
            }
            Assert.assertFalse((boolean)rowsIter.hasNext());
        }
    }

    @Test
    public void testComplicateSchemaWithPendingStream() throws IOException, InterruptedException, ExecutionException {
        LOG.info("Create a write stream");
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId2).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.PENDING).build()).build());
        FinalizeWriteStreamResponse finalizeResponse = FinalizeWriteStreamResponse.getDefaultInstance();
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.ComplicateType.getDescriptor())).build();){
            LOG.info("Sending two messages");
            ApiFuture response = streamWriter.append(this.CreateProtoRowsComplex(new String[]{"aaa"}), 0L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
            ApiFuture response2 = streamWriter.append(this.CreateProtoRowsComplex(new String[]{"bbb"}), 1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
            TableResult result = bigquery.listTableData(tableInfo2.getTableId(), new BigQuery.TableDataListOption[]{BigQuery.TableDataListOption.startIndex((long)0L)});
            Iterator iter = result.getValues().iterator();
            Assert.assertEquals((Object)false, (Object)iter.hasNext());
            LOG.info("Finalize a write stream");
            finalizeResponse = client.finalizeWriteStream(FinalizeWriteStreamRequest.newBuilder().setName(writeStream.getName()).build());
            ApiFuture response3 = streamWriter.append(this.CreateProtoRows(new String[]{"ccc"}), 2L);
            try {
                response3.get();
                Assert.fail((String)"Append to finalized stream should fail.");
            }
            catch (Exception expected) {
                LOG.info("Got exception: " + expected.toString());
            }
        }
        Assert.assertEquals((long)2L, (long)finalizeResponse.getRowCount());
        LOG.info("Commit a write stream");
        BatchCommitWriteStreamsResponse batchCommitWriteStreamsResponse = client.batchCommitWriteStreams(BatchCommitWriteStreamsRequest.newBuilder().setParent(tableId2).addWriteStreams(writeStream.getName()).build());
        Assert.assertEquals((Object)true, (Object)batchCommitWriteStreamsResponse.hasCommitTime());
        TableResult queryResult = bigquery.query(QueryJobConfiguration.newBuilder((String)("SELECT * from " + DATASET + '.' + TABLE2)).build(), new BigQuery.JobOption[0]);
        Iterator queryIter = queryResult.getValues().iterator();
        Assert.assertTrue((boolean)queryIter.hasNext());
        Assert.assertEquals((Object)"[FieldValue{attribute=REPEATED, value=[FieldValue{attribute=PRIMITIVE, value=aaa}, FieldValue{attribute=PRIMITIVE, value=aaa}]}]", (Object)((FieldValueList)queryIter.next()).get(1).getRepeatedValue().toString());
        Assert.assertEquals((Object)"[FieldValue{attribute=REPEATED, value=[FieldValue{attribute=PRIMITIVE, value=bbb}, FieldValue{attribute=PRIMITIVE, value=bbb}]}]", (Object)((FieldValueList)queryIter.next()).get(1).getRepeatedValue().toString());
        Assert.assertFalse((boolean)queryIter.hasNext());
    }

    @Test
    public void testStreamError() throws IOException, InterruptedException, ExecutionException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            ApiFuture response = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), -1L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
            ApiFuture response2 = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), 100L);
            try {
                response2.get();
                Assert.fail((String)"Should fail");
            }
            catch (ExecutionException e) {
                Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"OUT_OF_RANGE: The offset is beyond stream, expected offset 1, received 100");
            }
            ApiFuture response3 = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), -1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
        }
    }

    @Test
    public void testStreamSchemaMisMatchError() throws IOException, InterruptedException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.UpdatedFooType.getDescriptor())).build();){
            ApiFuture response = streamWriter.append(this.CreateProtoRowsMultipleColumns(new String[]{"a"}), 0L);
            try {
                response.get();
                Assert.fail((String)"Should fail");
            }
            catch (ExecutionException e) {
                Assert.assertEquals(Exceptions.SchemaMismatchedException.class, e.getCause().getClass());
                Exceptions.SchemaMismatchedException actualError = (Exceptions.SchemaMismatchedException)e.getCause();
                Assert.assertNotNull((Object)actualError.getStreamName());
                Assert.assertEquals((Object)Status.Code.INVALID_ARGUMENT, (Object)Status.fromThrowable((Throwable)e.getCause()).getCode());
            }
        }
    }

    @Test
    public void testStreamFinalizedError() throws IOException, InterruptedException, ExecutionException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            ApiFuture response = streamWriter.append(this.CreateProtoRowsMultipleColumns(new String[]{"a"}), 0L);
            response.get();
            client.finalizeWriteStream(FinalizeWriteStreamRequest.newBuilder().setName(writeStream.getName()).build());
            ApiFuture response2 = streamWriter.append(this.CreateProtoRowsMultipleColumns(new String[]{"a"}), 1L);
            try {
                response2.get();
                Assert.fail((String)"Should fail");
            }
            catch (ExecutionException e) {
                Assert.assertEquals(Exceptions.StreamFinalizedException.class, e.getCause().getClass());
                Exceptions.StreamFinalizedException actualError = (Exceptions.StreamFinalizedException)e.getCause();
                Assert.assertNotNull((Object)actualError.getStreamName());
                Assert.assertEquals((Object)Status.Code.INVALID_ARGUMENT, (Object)Status.fromThrowable((Throwable)e.getCause()).getCode());
                Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"Stream has been finalized");
            }
        }
    }

    @Test
    public void testOffsetAlreadyExistsError() throws IOException, ExecutionException, InterruptedException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            ApiFuture response = streamWriter.append(this.CreateProtoRowsMultipleColumns(new String[]{"a"}), 0L);
            response.get();
            ApiFuture response2 = streamWriter.append(this.CreateProtoRowsMultipleColumns(new String[]{"a"}), 0L);
            try {
                response2.get();
                Assert.fail((String)"Should fail");
            }
            catch (ExecutionException e) {
                Assert.assertEquals(Exceptions.OffsetAlreadyExists.class, e.getCause().getClass());
                Exceptions.OffsetAlreadyExists actualError = (Exceptions.OffsetAlreadyExists)e.getCause();
                Assert.assertNotNull((Object)actualError.getStreamName());
                Assert.assertEquals((long)1L, (long)actualError.getExpectedOffset());
                Assert.assertEquals((long)0L, (long)actualError.getActualOffset());
                Assert.assertEquals((Object)Status.Code.ALREADY_EXISTS, (Object)Status.fromThrowable((Throwable)e.getCause()).getCode());
                Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"The offset is within stream, expected offset 1, received 0");
            }
        }
    }

    @Test
    public void testOffsetOutOfRangeError() throws IOException, InterruptedException {
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            ApiFuture response = streamWriter.append(this.CreateProtoRowsMultipleColumns(new String[]{"a"}), 10L);
            try {
                response.get();
                Assert.fail((String)"Should fail");
            }
            catch (ExecutionException e) {
                Assert.assertEquals(Exceptions.OffsetOutOfRange.class, e.getCause().getClass());
                Exceptions.OffsetOutOfRange actualError = (Exceptions.OffsetOutOfRange)e.getCause();
                Assert.assertNotNull((Object)actualError.getStreamName());
                Assert.assertEquals((long)0L, (long)actualError.getExpectedOffset());
                Assert.assertEquals((long)10L, (long)actualError.getActualOffset());
                Assert.assertEquals((Object)Status.Code.OUT_OF_RANGE, (Object)Status.fromThrowable((Throwable)e.getCause()).getCode());
                Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"The offset is beyond stream, expected offset 0, received 10");
            }
        }
    }

    @Test
    public void testStreamReconnect() throws IOException, InterruptedException, ExecutionException {
        ApiFuture response;
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(tableId).setWriteStream(WriteStream.newBuilder().setType(WriteStream.Type.COMMITTED).build()).build());
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();){
            response = streamWriter.append(this.CreateProtoRows(new String[]{"aaa"}), 0L);
            Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        }
        streamWriter = StreamWriter.newBuilder((String)writeStream.getName()).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).build();
        try {
            Thread.sleep(5000L);
            response = streamWriter.append(this.CreateProtoRows(new String[]{"bbb"}), 1L);
            Assert.assertEquals((long)1L, (long)((AppendRowsResponse)response.get()).getAppendResult().getOffset().getValue());
        }
        finally {
            if (streamWriter != null) {
                streamWriter.close();
            }
        }
    }

    @Test
    public void testMultiplexingMixedLocation() throws IOException, InterruptedException, ExecutionException {
        ConnectionWorkerPool.setOptions((ConnectionWorkerPool.Settings)ConnectionWorkerPool.Settings.builder().setMinConnectionsPerRegion(1).setMaxConnectionsPerRegion(2).build());
        String defaultStream1 = String.format("projects/%s/datasets/%s/tables/%s/streams/_default", ServiceOptions.getDefaultProjectId(), DATASET, TABLE);
        String defaultStream2 = String.format("projects/%s/datasets/%s/tables/%s/streams/_default", ServiceOptions.getDefaultProjectId(), DATASET, TABLE2);
        String defaultStream3 = String.format("projects/%s/datasets/%s/tables/%s/streams/_default", ServiceOptions.getDefaultProjectId(), DATASET_EU, TABLE);
        StreamWriter streamWriter1 = StreamWriter.newBuilder((String)defaultStream1).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).setEnableConnectionPool(true).setTraceId(TEST_TRACE_ID).build();
        StreamWriter streamWriter2 = StreamWriter.newBuilder((String)defaultStream2).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.ComplicateType.getDescriptor())).setEnableConnectionPool(true).setTraceId(TEST_TRACE_ID).build();
        StreamWriter streamWriter3 = StreamWriter.newBuilder((String)defaultStream3).setWriterSchema(ProtoSchemaConverter.convert((Descriptors.Descriptor)Test.FooType.getDescriptor())).setEnableConnectionPool(true).setTraceId(TEST_TRACE_ID).build();
        ApiFuture response1 = streamWriter1.append(this.CreateProtoRows(new String[]{"aaa"}));
        ApiFuture response2 = streamWriter2.append(this.CreateProtoRowsComplex(new String[]{"aaa"}));
        ApiFuture response3 = streamWriter3.append(this.CreateProtoRows(new String[]{"bbb"}));
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response1.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response2.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((long)0L, (long)((AppendRowsResponse)response3.get()).getAppendResult().getOffset().getValue());
        Assert.assertEquals((Object)"us", (Object)streamWriter1.getLocation());
        Assert.assertEquals((Object)"us", (Object)streamWriter2.getLocation());
        Assert.assertEquals((Object)"eu", (Object)streamWriter3.getLocation());
        streamWriter1.close();
        streamWriter2.close();
        streamWriter3.close();
    }

    @Test
    public void testLargeRequest() throws IOException, InterruptedException, ExecutionException {
        String tableName = "largeRequestTable";
        TableId tableId = TableId.of((String)DATASET, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema originalSchema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)originalSchema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)ServiceOptions.getDefaultProjectId(), (String)DATASET, (String)tableName);
        try (StreamWriter streamWriter = StreamWriter.newBuilder((String)(parent.toString() + "/_default")).setWriterSchema(this.CreateProtoSchemaWithColField()).build();){
            int i;
            List<Integer> sizeSet = Arrays.asList(0xF00000, 1024);
            ArrayList<ApiFuture> responseList = new ArrayList<ApiFuture>();
            Random r = new Random();
            for (i = 0; i < 50; ++i) {
                int size = sizeSet.get(r.nextInt(2));
                LOG.info("Sending size: " + size);
                responseList.add(streamWriter.append(this.CreateProtoRows(new String[]{new String(new char[size]).replace('\u0000', (char)(r.nextInt(26) + 97))})));
            }
            for (i = 0; i < 50; ++i) {
                Assert.assertFalse((boolean)((AppendRowsResponse)((ApiFuture)responseList.get(i)).get()).hasError());
            }
            TableResult queryResult = bigquery.query(QueryJobConfiguration.newBuilder((String)("SELECT count(*) from " + DATASET + '.' + tableName)).build(), new BigQuery.JobOption[0]);
            Iterator queryIter = queryResult.getValues().iterator();
            Assert.assertTrue((boolean)queryIter.hasNext());
            Assert.assertEquals((Object)"50", (Object)((FieldValueList)queryIter.next()).get(0).getStringValue());
        }
    }

    static {
        USER_AGENT_HEADER_PROVIDER = FixedHeaderProvider.create((String[])new String[]{"User-Agent", "my_product_name/1.0 (GPN:Samples;test)"});
    }

    public class StringWithSecondsNanos {
        public String foo;
        public long seconds;
        public int nanos;

        public StringWithSecondsNanos(String fooParam, long secondsParam, int nanosParam) {
            this.foo = fooParam;
            this.seconds = secondsParam;
            this.nanos = nanosParam;
        }
    }
}

