/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.core.BetaApi;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageGrpc;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

@BetaApi
public class MockBigQueryStorageImpl
extends BigQueryStorageGrpc.BigQueryStorageImplBase {
    private List<AbstractMessage> requests = new ArrayList<AbstractMessage>();
    private Queue<Object> responses = new LinkedList<Object>();

    public List<AbstractMessage> getRequests() {
        return this.requests;
    }

    public void addResponse(AbstractMessage response) {
        this.responses.add(response);
    }

    public void setResponses(List<AbstractMessage> responses) {
        this.responses = new LinkedList<AbstractMessage>(responses);
    }

    public void addException(Exception exception) {
        this.responses.add(exception);
    }

    public void reset() {
        this.requests = new ArrayList<AbstractMessage>();
        this.responses = new LinkedList<Object>();
    }

    public void createReadSession(Storage.CreateReadSessionRequest request, StreamObserver<Storage.ReadSession> responseObserver) {
        Object response = this.responses.poll();
        if (response instanceof Storage.ReadSession) {
            this.requests.add((AbstractMessage)request);
            responseObserver.onNext((Object)((Storage.ReadSession)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException(String.format("Unrecognized response type %s for method CreateReadSession, expected %s or %s", response == null ? "null" : response.getClass().getName(), Storage.ReadSession.class.getName(), Exception.class.getName())));
        }
    }

    public void readRows(Storage.ReadRowsRequest request, StreamObserver<Storage.ReadRowsResponse> responseObserver) {
        Object response = this.responses.poll();
        if (response instanceof Storage.ReadRowsResponse) {
            this.requests.add((AbstractMessage)request);
            responseObserver.onNext((Object)((Storage.ReadRowsResponse)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException(String.format("Unrecognized response type %s for method ReadRows, expected %s or %s", response == null ? "null" : response.getClass().getName(), Storage.ReadRowsResponse.class.getName(), Exception.class.getName())));
        }
    }

    public void batchCreateReadSessionStreams(Storage.BatchCreateReadSessionStreamsRequest request, StreamObserver<Storage.BatchCreateReadSessionStreamsResponse> responseObserver) {
        Object response = this.responses.poll();
        if (response instanceof Storage.BatchCreateReadSessionStreamsResponse) {
            this.requests.add((AbstractMessage)request);
            responseObserver.onNext((Object)((Storage.BatchCreateReadSessionStreamsResponse)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException(String.format("Unrecognized response type %s for method BatchCreateReadSessionStreams, expected %s or %s", response == null ? "null" : response.getClass().getName(), Storage.BatchCreateReadSessionStreamsResponse.class.getName(), Exception.class.getName())));
        }
    }

    public void finalizeStream(Storage.FinalizeStreamRequest request, StreamObserver<Empty> responseObserver) {
        Object response = this.responses.poll();
        if (response instanceof Empty) {
            this.requests.add((AbstractMessage)request);
            responseObserver.onNext((Object)((Empty)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException(String.format("Unrecognized response type %s for method FinalizeStream, expected %s or %s", response == null ? "null" : response.getClass().getName(), Empty.class.getName(), Exception.class.getName())));
        }
    }

    public void splitReadStream(Storage.SplitReadStreamRequest request, StreamObserver<Storage.SplitReadStreamResponse> responseObserver) {
        Object response = this.responses.poll();
        if (response instanceof Storage.SplitReadStreamResponse) {
            this.requests.add((AbstractMessage)request);
            responseObserver.onNext((Object)((Storage.SplitReadStreamResponse)response));
            responseObserver.onCompleted();
        } else if (response instanceof Exception) {
            responseObserver.onError((Throwable)((Exception)response));
        } else {
            responseObserver.onError((Throwable)new IllegalArgumentException(String.format("Unrecognized response type %s for method SplitReadStream, expected %s or %s", response == null ? "null" : response.getClass().getName(), Storage.SplitReadStreamResponse.class.getName(), Exception.class.getName())));
        }
    }
}

