/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.it;

import com.google.api.core.ApiFuture;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.JsonStreamWriter;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.it.ITBigQueryWriteQuotaRetryTest;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.threeten.bp.Duration;

public class WriteRetryTestUtil {
    private static final Logger LOG = Logger.getLogger(ITBigQueryWriteQuotaRetryTest.class.getName());

    public static void runExclusiveRetryTest(BigQuery bigquery, BigQueryWriteClient client, String dataset, String projectId, WriteStream.Type streamType, int requestCount, int rowBatchSize) throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.1).setMaxAttempts(5).setMaxRetryDelay(Duration.ofMinutes((long)1L)).build();
        String tableName = "RetryTest";
        TableId tableId = TableId.of((String)dataset, (String)tableName);
        Field col1 = Field.newBuilder((String)"col1", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build();
        Schema schema = Schema.of((Field[])new Field[]{col1});
        TableInfo tableInfo = TableInfo.newBuilder((TableId)tableId, (TableDefinition)StandardTableDefinition.of((Schema)schema)).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)projectId, (String)dataset, (String)tableName);
        WriteStream writeStream = client.createWriteStream(CreateWriteStreamRequest.newBuilder().setParent(parent.toString()).setWriteStream(WriteStream.newBuilder().setType(streamType).build()).build());
        ArrayList<ApiFuture> allResponses = new ArrayList<ApiFuture>(requestCount);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)writeStream.getName(), (TableSchema)writeStream.getTableSchema()).setRetrySettings(retrySettings).build();){
            for (int k = 0; k < requestCount; ++k) {
                JSONObject row = new JSONObject();
                row.put("col1", (Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
                JSONArray jsonArr = new JSONArray();
                for (int j = 0; j < rowBatchSize; ++j) {
                    jsonArr.put((Object)row);
                }
                LOG.info("Appending: " + k + "/" + requestCount);
                allResponses.add(jsonStreamWriter.append(jsonArr, (long)(k * rowBatchSize)));
            }
            LOG.info("Waiting for all responses to come back");
            for (int i = 0; i < requestCount; ++i) {
                LOG.info("Waiting for request " + i);
                try {
                    Assert.assertEquals((long)((AppendRowsResponse)((ApiFuture)allResponses.get(i)).get()).getAppendResult().getOffset().getValue(), (long)(i * rowBatchSize));
                    continue;
                }
                catch (ExecutionException ex) {
                    Assert.fail((String)("Unexpected error " + ex));
                }
            }
        }
    }

    private static void runDefaultRetryTestInternal(BigQuery bigquery, BigQueryWriteClient client, String dataset, String projectId, int requestCount, int rowBatchSize, TableName parent, TableSchema tableSchema, boolean enableConnectionPool) throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.1).setMaxAttempts(5).setMaxRetryDelay(Duration.ofMinutes((long)1L)).build();
        ArrayList<ApiFuture> allResponses = new ArrayList<ApiFuture>(requestCount);
        try (JsonStreamWriter jsonStreamWriter = JsonStreamWriter.newBuilder((String)parent.toString(), (TableSchema)tableSchema).setIgnoreUnknownFields(true).setRetrySettings(retrySettings).setEnableConnectionPool(enableConnectionPool).build();){
            for (int k = 0; k < requestCount; ++k) {
                JSONObject row = new JSONObject();
                row.put("test_str", (Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
                JSONArray jsonArr = new JSONArray();
                for (int j = 0; j < rowBatchSize; ++j) {
                    jsonArr.put((Object)row);
                }
                LOG.info("Appending: " + k + "/" + requestCount);
                allResponses.add(jsonStreamWriter.append(jsonArr));
            }
            LOG.info("Waiting for all responses to come back");
            for (int i = 0; i < requestCount; ++i) {
                LOG.info("Waiting for request " + i);
                try {
                    Assert.assertFalse((boolean)((AppendRowsResponse)((ApiFuture)allResponses.get(i)).get()).hasError());
                    continue;
                }
                catch (Exception ex) {
                    Assert.fail((String)("Unexpected error " + ex));
                }
            }
        }
    }

    public static void runDefaultRetryTest(BigQuery bigquery, BigQueryWriteClient client, String dataset, String projectId, int requestCount, int rowBatchSize) throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        String tableName = "JsonTableDefaultStream";
        TableFieldSchema TEST_STRING = TableFieldSchema.newBuilder().setType(TableFieldSchema.Type.STRING).setMode(TableFieldSchema.Mode.NULLABLE).setName("test_str").build();
        TableSchema tableSchema = TableSchema.newBuilder().addFields(0, TEST_STRING).build();
        TableInfo tableInfo = TableInfo.newBuilder((TableId)TableId.of((String)dataset, (String)tableName), (TableDefinition)StandardTableDefinition.of((Schema)Schema.of((Field[])new Field[]{Field.newBuilder((String)"test_str", (StandardSQLTypeName)StandardSQLTypeName.STRING, (Field[])new Field[0]).build()}))).build();
        bigquery.create(tableInfo, new BigQuery.TableOption[0]);
        TableName parent = TableName.of((String)projectId, (String)dataset, (String)tableName);
        WriteRetryTestUtil.runDefaultRetryTestInternal(bigquery, client, dataset, projectId, requestCount, rowBatchSize, parent, tableSchema, false);
        WriteRetryTestUtil.runDefaultRetryTestInternal(bigquery, client, dataset, projectId, requestCount, rowBatchSize, parent, tableSchema, true);
    }
}

