/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnimplementedException;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageGrpc;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ResourceHeaderTest {
    private static final TableReferenceProto.TableReference TEST_TABLE_REFERENCE = TableReferenceProto.TableReference.newBuilder().setProjectId("project").setDatasetId("dataset").setTableId("table").build();
    private static final Storage.ReadSession TEST_SESSION = Storage.ReadSession.newBuilder().setName("sessionName").build();
    private static final Storage.Stream TEST_STREAM = Storage.Stream.newBuilder().setName("streamName").build();
    private static final String NAME = "resource-header-test:123";
    private static final String HEADER_NAME = "x-goog-request-params";
    private static final Pattern DATASET_PATTERN = Pattern.compile(".*table_reference\\.dataset_id=dataset.*");
    private static final Pattern ORIGINAL_STREAM_PATTERN = Pattern.compile(".*original_stream\\.name=streamName.*");
    private static final Pattern PROJECT_PATTERN = Pattern.compile(".*table_reference\\.project_id=project.*");
    private static final Pattern READ_POSITION_PATTERN = Pattern.compile(".*read_position\\.stream\\.name=streamName.*");
    private static final Pattern SESSION_PATTERN = Pattern.compile(".*session\\.name=sessionName.*");
    private static final Pattern STREAM_PATTERN = Pattern.compile(".*stream\\.name=streamName.*");
    private static final String TEST_HEADER_NAME = "simple-header-name";
    private static final String TEST_HEADER_VALUE = "simple-header-value";
    private static final Pattern TEST_PATTERN = Pattern.compile(".*simple-header-value.*");
    private static InProcessServer<?> server;
    private LocalChannelProvider channelProvider;
    private BigQueryStorageClient client;

    @BeforeClass
    public static void setUpClass() throws Exception {
        server = new InProcessServer((BindableService)new BigQueryStorageGrpc.BigQueryStorageImplBase(){}, NAME);
        server.start();
    }

    @Before
    public void setUp() throws Exception {
        this.channelProvider = LocalChannelProvider.create((String)NAME);
        BigQueryStorageSettings.Builder settingsBuilder = (BigQueryStorageSettings.Builder)((BigQueryStorageSettings.Builder)((BigQueryStorageSettings.Builder)BigQueryStorageSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((String[])new String[]{TEST_HEADER_NAME, TEST_HEADER_VALUE}))).setTransportChannelProvider((TransportChannelProvider)this.channelProvider);
        this.client = BigQueryStorageClient.create((BigQueryStorageSettings)settingsBuilder.build());
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        server.stop();
        server.blockUntilShutdown();
    }

    @Test
    public void createReadSessionTest() {
        try {
            this.client.createReadSession(TEST_TABLE_REFERENCE, "parents/project", 1);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(PROJECT_PATTERN, DATASET_PATTERN);
    }

    @Test
    public void readRowsTest() {
        try {
            Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(TEST_STREAM).setOffset(125L)).build();
            this.client.readRowsCallable().call((Object)request);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(READ_POSITION_PATTERN);
    }

    @Test
    public void batchCreateReadStreamsForSessionTest() {
        try {
            this.client.batchCreateReadSessionStreams(TEST_SESSION, 1);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(SESSION_PATTERN);
    }

    @Test
    public void finalizeStreamTest() {
        try {
            this.client.finalizeStream(TEST_STREAM);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(STREAM_PATTERN);
    }

    @Test
    public void splitReadStreamTest() {
        try {
            this.client.splitReadStream(TEST_STREAM);
        }
        catch (UnimplementedException unimplementedException) {
            // empty catch block
        }
        this.verifyHeaderSent(ORIGINAL_STREAM_PATTERN);
    }

    private void verifyHeaderSent(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            boolean headerSent = this.channelProvider.isHeaderSent(HEADER_NAME, pattern);
            Truth.assertWithMessage((String)"Generated header was sent").that(Boolean.valueOf(headerSent)).isTrue();
        }
        boolean testHeaderSent = this.channelProvider.isHeaderSent(TEST_HEADER_NAME, TEST_PATTERN);
        Truth.assertWithMessage((String)"Provided header was sent").that(Boolean.valueOf(testHeaderSent)).isTrue();
    }
}

