/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1beta1.BaseBigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.BaseBigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.MockBigQueryStorage;
import com.google.cloud.bigquery.storage.v1beta1.ProjectName;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseBigQueryStorageClientTest {
    private static MockBigQueryStorage mockBigQueryStorage;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private BaseBigQueryStorageClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockBigQueryStorage = new MockBigQueryStorage();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockBigQueryStorage));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        BaseBigQueryStorageSettings settings = ((BaseBigQueryStorageSettings.Builder)((BaseBigQueryStorageSettings.Builder)BaseBigQueryStorageSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = BaseBigQueryStorageClient.create((BaseBigQueryStorageSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createReadSessionTest() throws Exception {
        Storage.ReadSession expectedResponse = Storage.ReadSession.newBuilder().setName("name3373707").setExpireTime(Timestamp.newBuilder().build()).addAllStreams(new ArrayList()).setTableReference(TableReferenceProto.TableReference.newBuilder().build()).setTableModifiers(TableReferenceProto.TableModifiers.newBuilder().build()).setShardingStrategy(Storage.ShardingStrategy.forNumber((int)0)).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().build();
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        int requestedStreams = 1017221410;
        Storage.ReadSession actualResponse = this.client.createReadSession(tableReference, parent, requestedStreams);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.CreateReadSessionRequest actualRequest = (Storage.CreateReadSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)tableReference, (Object)actualRequest.getTableReference());
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((long)requestedStreams, (long)actualRequest.getRequestedStreams());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReadSessionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().build();
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            int requestedStreams = 1017221410;
            this.client.createReadSession(tableReference, parent, requestedStreams);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createReadSessionTest2() throws Exception {
        Storage.ReadSession expectedResponse = Storage.ReadSession.newBuilder().setName("name3373707").setExpireTime(Timestamp.newBuilder().build()).addAllStreams(new ArrayList()).setTableReference(TableReferenceProto.TableReference.newBuilder().build()).setTableModifiers(TableReferenceProto.TableModifiers.newBuilder().build()).setShardingStrategy(Storage.ShardingStrategy.forNumber((int)0)).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().build();
        String parent = "parent-995424086";
        int requestedStreams = 1017221410;
        Storage.ReadSession actualResponse = this.client.createReadSession(tableReference, parent, requestedStreams);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.CreateReadSessionRequest actualRequest = (Storage.CreateReadSessionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)tableReference, (Object)actualRequest.getTableReference());
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((long)requestedStreams, (long)actualRequest.getRequestedStreams());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createReadSessionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            TableReferenceProto.TableReference tableReference = TableReferenceProto.TableReference.newBuilder().build();
            String parent = "parent-995424086";
            int requestedStreams = 1017221410;
            this.client.createReadSession(tableReference, parent, requestedStreams);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readRowsTest() throws Exception {
        Storage.ReadRowsResponse expectedResponse = Storage.ReadRowsResponse.newBuilder().setRowCount(1340416618L).setStatus(Storage.StreamStatus.newBuilder().build()).setThrottleStatus(Storage.ThrottleStatus.newBuilder().build()).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void readRowsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.readRowsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void batchCreateReadSessionStreamsTest() throws Exception {
        Storage.BatchCreateReadSessionStreamsResponse expectedResponse = Storage.BatchCreateReadSessionStreamsResponse.newBuilder().addAllStreams(new ArrayList()).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.ReadSession session = Storage.ReadSession.newBuilder().build();
        int requestedStreams = 1017221410;
        Storage.BatchCreateReadSessionStreamsResponse actualResponse = this.client.batchCreateReadSessionStreams(session, requestedStreams);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.BatchCreateReadSessionStreamsRequest actualRequest = (Storage.BatchCreateReadSessionStreamsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)session, (Object)actualRequest.getSession());
        Assert.assertEquals((long)requestedStreams, (long)actualRequest.getRequestedStreams());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchCreateReadSessionStreamsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            Storage.ReadSession session = Storage.ReadSession.newBuilder().build();
            int requestedStreams = 1017221410;
            this.client.batchCreateReadSessionStreams(session, requestedStreams);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void finalizeStreamTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.Stream stream = Storage.Stream.newBuilder().build();
        this.client.finalizeStream(stream);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.FinalizeStreamRequest actualRequest = (Storage.FinalizeStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)stream, (Object)actualRequest.getStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void finalizeStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            Storage.Stream stream = Storage.Stream.newBuilder().build();
            this.client.finalizeStream(stream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void splitReadStreamTest() throws Exception {
        Storage.SplitReadStreamResponse expectedResponse = Storage.SplitReadStreamResponse.newBuilder().setPrimaryStream(Storage.Stream.newBuilder().build()).setRemainderStream(Storage.Stream.newBuilder().build()).build();
        mockBigQueryStorage.addResponse((AbstractMessage)expectedResponse);
        Storage.Stream originalStream = Storage.Stream.newBuilder().build();
        Storage.SplitReadStreamResponse actualResponse = this.client.splitReadStream(originalStream);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockBigQueryStorage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        Storage.SplitReadStreamRequest actualRequest = (Storage.SplitReadStreamRequest)actualRequests.get(0);
        Assert.assertEquals((Object)originalStream, (Object)actualRequest.getOriginalStream());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void splitReadStreamExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockBigQueryStorage.addException((Exception)exception);
        try {
            Storage.Stream originalStream = Storage.Stream.newBuilder().build();
            this.client.splitReadStream(originalStream);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

