/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.TableAdminRequests;
import com.google.cloud.bigtable.admin.v2.models.TableAdminResponses;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@BetaApi
public class TableAdminClient
implements AutoCloseable {
    private final BigtableTableAdminStub stub;
    private final InstanceName instanceName;

    public static TableAdminClient create(InstanceName instanceName) throws IOException {
        return new TableAdminClient(instanceName, BigtableTableAdminSettings.newBuilder().build());
    }

    public static TableAdminClient create(InstanceName instanceName, BigtableTableAdminSettings adminSettings) throws IOException {
        return new TableAdminClient(instanceName, adminSettings);
    }

    public static TableAdminClient create(InstanceName instanceName, BigtableTableAdminStub stub) throws IOException {
        return new TableAdminClient(instanceName, stub);
    }

    private TableAdminClient(InstanceName instanceName, BigtableTableAdminSettings adminSettings) throws IOException {
        this(instanceName, ((BigtableTableAdminStubSettings)adminSettings.getStubSettings()).createStub());
    }

    private TableAdminClient(InstanceName instanceName, BigtableTableAdminStub stub) throws IOException {
        Preconditions.checkNotNull((Object)instanceName);
        Preconditions.checkNotNull((Object)stub);
        this.instanceName = instanceName;
        this.stub = stub;
    }

    public InstanceName getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public TableAdminResponses.Table createTable(TableAdminRequests.CreateTable createTable) {
        Table table = (Table)this.stub.createTableCallable().call((Object)createTable.toProto(this.instanceName));
        return TableAdminResponses.convertTable(table);
    }

    public ApiFuture<TableAdminResponses.Table> createTableAsync(TableAdminRequests.CreateTable createTable) {
        return TableAdminClient.transformToTableResponse((ApiFuture<Table>)this.stub.createTableCallable().futureCall((Object)createTable.toProto(this.instanceName)));
    }

    public TableAdminResponses.Table modifyFamilies(TableAdminRequests.ModifyFamilies modifyFamily) {
        ModifyColumnFamiliesRequest modReq = modifyFamily.toProto(this.instanceName);
        Table table = (Table)this.stub.modifyColumnFamiliesCallable().call((Object)modReq);
        return TableAdminResponses.convertTable(table);
    }

    public ApiFuture<TableAdminResponses.Table> modifyFamiliesAsync(TableAdminRequests.ModifyFamilies modifyFamily) {
        ModifyColumnFamiliesRequest modReq = modifyFamily.toProto(this.instanceName);
        return TableAdminClient.transformToTableResponse((ApiFuture<Table>)this.stub.modifyColumnFamiliesCallable().futureCall((Object)modReq));
    }

    public void deleteTable(String tableId) {
        this.stub.deleteTableCallable().call((Object)this.composeDeleteTableRequest(tableId));
    }

    public ApiFuture<Void> deleteTableAsync(String tableId) {
        return TableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteTableCallable().futureCall((Object)this.composeDeleteTableRequest(tableId)));
    }

    public TableAdminResponses.Table getTable(String tableId) {
        Table table = (Table)this.stub.getTableCallable().call((Object)this.composeGetTableRequest(tableId));
        return TableAdminResponses.convertTable(table);
    }

    public ApiFuture<TableAdminResponses.Table> getTableAsync(String tableId) {
        return TableAdminClient.transformToTableResponse((ApiFuture<Table>)this.stub.getTableCallable().futureCall((Object)this.composeGetTableRequest(tableId)));
    }

    public List<TableName> listTables() {
        ListTablesResponse listResp = (ListTablesResponse)this.stub.listTablesCallable().call((Object)this.composeListTableRequest());
        return TableAdminClient.convertToTableNames(listResp);
    }

    public ApiFuture<List<TableName>> listTablesAsync() {
        ApiFuture listResp = this.stub.listTablesCallable().futureCall((Object)this.composeListTableRequest());
        return ApiFutures.transform((ApiFuture)listResp, (ApiFunction)new ApiFunction<ListTablesResponse, List<TableName>>(){

            public List<TableName> apply(ListTablesResponse input) {
                return TableAdminClient.convertToTableNames(input);
            }
        });
    }

    public void dropRowRange(String tableId, String rowKeyPrefix) {
        this.dropRowRange(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        this.stub.dropRowRangeCallable().call((Object)this.composeDropRowRangeRequest(tableId, rowKeyPrefix, false));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        return TableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)this.composeDropRowRangeRequest(tableId, rowKeyPrefix, false)));
    }

    public void dropAllRows(String tableId) {
        this.stub.dropRowRangeCallable().call((Object)this.composeDropRowRangeRequest(tableId, null, true));
    }

    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        return TableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)this.composeDropRowRangeRequest(tableId, null, true)));
    }

    public TableAdminResponses.ConsistencyToken generateConsistencyToken(String tableId) {
        return TableAdminResponses.convertTokenResponse((GenerateConsistencyTokenResponse)this.stub.generateConsistencyTokenCallable().call((Object)this.composeGenerateConsistencyTokenRequest(tableId)));
    }

    public ApiFuture<TableAdminResponses.ConsistencyToken> generateConsistencyTokenAsync(String tableId) {
        ApiFuture tokenResp = this.stub.generateConsistencyTokenCallable().futureCall((Object)this.composeGenerateConsistencyTokenRequest(tableId));
        return ApiFutures.transform((ApiFuture)tokenResp, (ApiFunction)new ApiFunction<GenerateConsistencyTokenResponse, TableAdminResponses.ConsistencyToken>(){

            public TableAdminResponses.ConsistencyToken apply(GenerateConsistencyTokenResponse input) {
                return TableAdminResponses.convertTokenResponse(input);
            }
        });
    }

    public boolean isConsistent(String tableId, TableAdminResponses.ConsistencyToken token) {
        return ((CheckConsistencyResponse)this.stub.checkConsistencyCallable().call((Object)token.toProto(this.getTableName(tableId)))).getConsistent();
    }

    public ApiFuture<Boolean> isConsistentAsync(String tableId, TableAdminResponses.ConsistencyToken token) {
        ApiFuture checkConsResp = this.stub.checkConsistencyCallable().futureCall((Object)token.toProto(this.getTableName(tableId)));
        return ApiFutures.transform((ApiFuture)checkConsResp, (ApiFunction)new ApiFunction<CheckConsistencyResponse, Boolean>(){

            public Boolean apply(CheckConsistencyResponse input) {
                return input.getConsistent();
            }
        });
    }

    @VisibleForTesting
    String getTableName(String tableId) {
        return TableName.of((String)this.instanceName.getProject(), (String)this.instanceName.getInstance(), (String)tableId).toString();
    }

    @VisibleForTesting
    ListTablesRequest composeListTableRequest() {
        return ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
    }

    @VisibleForTesting
    GetTableRequest composeGetTableRequest(String tableId) {
        return GetTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
    }

    @VisibleForTesting
    DeleteTableRequest composeDeleteTableRequest(String tableId) {
        return DeleteTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
    }

    @VisibleForTesting
    DropRowRangeRequest composeDropRowRangeRequest(String tableId, ByteString rowKeyPrefix, boolean dropAll) {
        DropRowRangeRequest.Builder dropRowReq = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId));
        if (dropAll) {
            dropRowReq.setDeleteAllDataFromTable(true);
        } else {
            dropRowReq.setRowKeyPrefix(rowKeyPrefix);
        }
        return dropRowReq.build();
    }

    @VisibleForTesting
    GenerateConsistencyTokenRequest composeGenerateConsistencyTokenRequest(String tableId) {
        return GenerateConsistencyTokenRequest.newBuilder().setName(this.getTableName(tableId)).build();
    }

    @VisibleForTesting
    static List<TableName> convertToTableNames(ListTablesResponse listTablesResponse) {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        for (Table table : listTablesResponse.getTablesList()) {
            tableNames.add(TableName.parse((String)table.getName()));
        }
        return tableNames;
    }

    @VisibleForTesting
    static ApiFuture<TableAdminResponses.Table> transformToTableResponse(ApiFuture<Table> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<Table, TableAdminResponses.Table>(){

            public TableAdminResponses.Table apply(Table table) {
                return TableAdminResponses.convertTable(table);
            }
        });
    }

    @VisibleForTesting
    static ApiFuture<Void> transformToVoid(ApiFuture<Empty> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        });
    }
}

