/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;

@BetaApi
public final class TableAdminRequests {
    private TableAdminRequests() {
    }

    public static CreateTable createTable(String tableId) {
        return new CreateTable(tableId);
    }

    public static ModifyFamilies modifyFamilies(String tableId) {
        return new ModifyFamilies(tableId);
    }

    public static final class ModifyFamilies {
        private final ModifyColumnFamiliesRequest.Builder modFamilyRequest = ModifyColumnFamiliesRequest.newBuilder();
        private final String tableId;

        private ModifyFamilies(String tableId) {
            Preconditions.checkNotNull((Object)tableId);
            this.tableId = tableId;
        }

        public ModifyFamilies addFamily(String familyId) {
            return this.addFamily(familyId, GCRules.GCRULES.defaultRule());
        }

        public ModifyFamilies addFamily(String familyId, GCRules.GCRule gcRule) {
            ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
            Preconditions.checkNotNull((Object)gcRule);
            modification.setCreate(ColumnFamily.newBuilder().setGcRule(gcRule.toProto()));
            this.modFamilyRequest.addModifications(modification.build());
            return this;
        }

        public ModifyFamilies updateFamily(String familyId, GCRules.GCRule gcRule) {
            ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
            Preconditions.checkNotNull((Object)gcRule);
            modification.setUpdate(ColumnFamily.newBuilder().setGcRule(gcRule.toProto()));
            this.modFamilyRequest.addModifications(modification.build());
            return this;
        }

        public ModifyFamilies dropFamily(String familyId) {
            ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
            modification.setId(familyId).setDrop(true);
            this.modFamilyRequest.addModifications(modification.build());
            return this;
        }

        @InternalApi
        public ModifyColumnFamiliesRequest toProto(InstanceName instanceName) {
            Preconditions.checkNotNull((Object)instanceName);
            String tableName = TableName.of((String)instanceName.getProject(), (String)instanceName.getInstance(), (String)this.tableId).toString();
            return this.modFamilyRequest.setName(tableName).build();
        }
    }

    public static final class CreateTable {
        private final CreateTableRequest.Builder createTableRequest = CreateTableRequest.newBuilder();
        private final Table.Builder tableRequest = Table.newBuilder();

        private CreateTable(String tableId) {
            this.createTableRequest.setTableId(tableId);
        }

        public CreateTable addFamily(String familyId) {
            Preconditions.checkNotNull((Object)familyId);
            this.tableRequest.putColumnFamilies(familyId, ColumnFamily.newBuilder().build());
            return this;
        }

        public CreateTable addFamily(String familyId, GCRules.GCRule gcRule) {
            Preconditions.checkNotNull((Object)familyId);
            this.tableRequest.putColumnFamilies(familyId, ColumnFamily.newBuilder().setGcRule(gcRule.toProto()).build());
            return this;
        }

        public CreateTable addSplit(ByteString key) {
            Preconditions.checkNotNull((Object)key);
            this.createTableRequest.addInitialSplits(CreateTableRequest.Split.newBuilder().setKey(key).build());
            return this;
        }

        @InternalApi
        public CreateTableRequest toProto(InstanceName instanceName) {
            Preconditions.checkNotNull((Object)instanceName);
            return this.createTableRequest.setParent(instanceName.toString()).setTable(this.tableRequest.build()).build();
        }
    }
}

