/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.threeten.bp.Duration;

@BetaApi
public class TableAdminResponses {
    private TableAdminResponses() {
    }

    @InternalApi
    public static Table convertTable(com.google.bigtable.admin.v2.Table table) {
        return new Table(table);
    }

    @InternalApi
    public static ConsistencyToken convertTokenResponse(GenerateConsistencyTokenResponse tokenResponse) {
        return new ConsistencyToken(tokenResponse);
    }

    @InternalApi
    public static Map<String, ClusterState> convertClusterStates(Map<String, Table.ClusterState> clusterStatesMap) {
        HashMap<String, ClusterState> clusterStates = new HashMap<String, ClusterState>();
        for (Map.Entry<String, Table.ClusterState> entry : clusterStatesMap.entrySet()) {
            clusterStates.put(entry.getKey(), new ClusterState(entry.getKey(), entry.getValue()));
        }
        return clusterStates;
    }

    @InternalApi
    public static Map<String, ColumnFamily> convertColumnFamilies(Map<String, com.google.bigtable.admin.v2.ColumnFamily> columnFamiliesMap) {
        HashMap<String, ColumnFamily> columnFamilies = new HashMap<String, ColumnFamily>();
        for (Map.Entry<String, com.google.bigtable.admin.v2.ColumnFamily> entry : columnFamiliesMap.entrySet()) {
            columnFamilies.put(entry.getKey(), new ColumnFamily(entry.getKey(), entry.getValue()));
        }
        return columnFamilies;
    }

    public static final class ConsistencyToken {
        private final String token;

        private ConsistencyToken(GenerateConsistencyTokenResponse resp) {
            this.token = resp.getConsistencyToken();
        }

        @InternalApi
        public CheckConsistencyRequest toProto(String tableName) {
            return CheckConsistencyRequest.newBuilder().setName(tableName).setConsistencyToken(this.token).build();
        }

        @VisibleForTesting
        String getToken() {
            return this.token;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).toString();
        }
    }

    public static final class ColumnFamily {
        private final String id;
        private GCRules.GCRule gCRule = GCRules.GCRULES.defaultRule();

        private ColumnFamily(String id, com.google.bigtable.admin.v2.ColumnFamily cf) {
            Preconditions.checkNotNull((Object)id);
            Preconditions.checkNotNull((Object)cf);
            this.id = id;
            if (cf.getGcRule() != null) {
                this.gCRule = this.convertGcRule(cf.getGcRule());
            }
        }

        public String getId() {
            return this.id;
        }

        public GCRules.GCRule getGCRule() {
            return this.gCRule;
        }

        public boolean hasGcRule() {
            return !GcRule.RuleCase.RULE_NOT_SET.equals((Object)this.gCRule.toProto().getRuleCase());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("gCRule", (Object)this.gCRule).toString();
        }

        private GCRules.GCRule convertGcRule(GcRule source) {
            switch (source.getRuleCase()) {
                case MAX_AGE: {
                    return GCRules.GCRULES.maxAge(Duration.ofSeconds((long)source.getMaxAge().getSeconds(), (long)source.getMaxAge().getNanos()));
                }
                case MAX_NUM_VERSIONS: {
                    return GCRules.GCRULES.maxVersions(source.getMaxNumVersions());
                }
                case INTERSECTION: {
                    GCRules.IntersectionRule intersection = GCRules.GCRULES.intersection();
                    for (GcRule rule : source.getIntersection().getRulesList()) {
                        intersection.rule(this.convertGcRule(rule));
                    }
                    return intersection;
                }
                case UNION: {
                    GCRules.UnionRule union = GCRules.GCRULES.union();
                    for (GcRule rule : source.getUnion().getRulesList()) {
                        union.rule(this.convertGcRule(rule));
                    }
                    return union;
                }
            }
            return GCRules.GCRULES.defaultRule();
        }
    }

    public static final class ClusterState {
        private final String id;
        private final Table.ClusterState.ReplicationState replicationState;

        private ClusterState(String id, Table.ClusterState clusterState) {
            this.id = id;
            this.replicationState = clusterState.getReplicationState();
        }

        public String getId() {
            return this.id;
        }

        public Table.ClusterState.ReplicationState getReplicationState() {
            return this.replicationState;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("is", (Object)this.id).add("replicationState", (Object)this.replicationState).toString();
        }
    }

    public static final class Table {
        private final TableName tableName;
        private final Map<String, ClusterState> clusterStates;
        private final Map<String, ColumnFamily> columnFamilies;

        private Table(com.google.bigtable.admin.v2.Table table) {
            Preconditions.checkNotNull((Object)table);
            this.tableName = TableName.parse((String)table.getName());
            this.clusterStates = TableAdminResponses.convertClusterStates(table.getClusterStatesMap());
            this.columnFamilies = TableAdminResponses.convertColumnFamilies(table.getColumnFamiliesMap());
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public Map<String, ClusterState> getClusterStatesMap() {
            return this.clusterStates;
        }

        public Map<String, ColumnFamily> getColumnFamiliesMap() {
            return this.columnFamilies;
        }

        public Collection<ClusterState> getClusterStates() {
            return this.clusterStates.values();
        }

        public Collection<ColumnFamily> getColumnFamiles() {
            return this.columnFamilies.values();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("clusterStates", this.getClusterStates()).add("columnFamiles", this.getColumnFamiles()).toString();
        }
    }
}

