/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public final class ConsistencyToken {
    private final String token;

    @InternalApi
    public static ConsistencyToken fromProto(GenerateConsistencyTokenResponse proto) {
        return new ConsistencyToken(proto.getConsistencyToken());
    }

    private ConsistencyToken(String token) {
        this.token = token;
    }

    @InternalApi
    public CheckConsistencyRequest toProto(String tableName) {
        return CheckConsistencyRequest.newBuilder().setName(tableName).setConsistencyToken(this.token).build();
    }

    @VisibleForTesting
    String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsistencyToken that = (ConsistencyToken)o;
        return Objects.equal((Object)this.token, (Object)that.token);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.token});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).toString();
    }
}

