/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.ClusterState;
import com.google.cloud.bigtable.admin.v2.models.ColumnFamily;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Table {
    private final TableName tableName;
    private final Map<String, ClusterState> clusterStates;
    private final Map<String, ColumnFamily> columnFamilies;

    @InternalApi
    public static Table fromProto(@Nonnull com.google.bigtable.admin.v2.Table proto) {
        ImmutableMap.Builder clusterStates = ImmutableMap.builder();
        for (Map.Entry entry : proto.getClusterStatesMap().entrySet()) {
            clusterStates.put(entry.getKey(), (Object)ClusterState.fromProto((String)entry.getKey(), (Table.ClusterState)entry.getValue()));
        }
        ImmutableMap.Builder columnFamilies = ImmutableMap.builder();
        for (Map.Entry entry : proto.getColumnFamiliesMap().entrySet()) {
            columnFamilies.put(entry.getKey(), (Object)ColumnFamily.fromProto((String)entry.getKey(), (com.google.bigtable.admin.v2.ColumnFamily)entry.getValue()));
        }
        return new Table(TableName.parse((String)proto.getName()), (Map<String, ClusterState>)clusterStates.build(), (Map<String, ColumnFamily>)columnFamilies.build());
    }

    private Table(TableName tableName, Map<String, ClusterState> clusterStates, Map<String, ColumnFamily> columnFamilies) {
        this.tableName = tableName;
        this.clusterStates = clusterStates;
        this.columnFamilies = columnFamilies;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public Map<String, ClusterState> getClusterStatesMap() {
        return this.clusterStates;
    }

    public Map<String, ColumnFamily> getColumnFamiliesMap() {
        return this.columnFamilies;
    }

    public Collection<ClusterState> getClusterStates() {
        return this.clusterStates.values();
    }

    public Collection<ColumnFamily> getColumnFamiles() {
        return this.columnFamilies.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equal((Object)this.tableName, (Object)table.tableName) && Objects.equal(this.clusterStates, table.clusterStates) && Objects.equal(this.columnFamilies, table.columnFamilies);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableName, this.clusterStates, this.columnFamilies});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("clusterStates", this.getClusterStates()).add("columnFamiles", this.getColumnFamiles()).toString();
    }
}

