/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.admin.v2.ProjectName;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class BigtableInstanceAdminClient
implements AutoCloseable {
    private final ProjectName projectName;
    private final BigtableInstanceAdminStub stub;

    public static BigtableInstanceAdminClient create(@Nonnull ProjectName projectName) throws IOException {
        return BigtableInstanceAdminClient.create(BigtableInstanceAdminSettings.newBuilder().setProjectName(projectName).build());
    }

    public static BigtableInstanceAdminClient create(@Nonnull BigtableInstanceAdminSettings settings) throws IOException {
        return BigtableInstanceAdminClient.create(settings.getProjectName(), settings.getStubSettings().createStub());
    }

    public static BigtableInstanceAdminClient create(@Nonnull ProjectName projectName, @Nonnull BigtableInstanceAdminStub stub) {
        return new BigtableInstanceAdminClient(projectName, stub);
    }

    private BigtableInstanceAdminClient(@Nonnull ProjectName projectName, @Nonnull BigtableInstanceAdminStub stub) {
        this.projectName = projectName;
        this.stub = stub;
    }

    public ProjectName getProjectName() {
        return this.projectName;
    }

    @Override
    public void close() {
        this.stub.close();
    }
}

