/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.ConsistencyToken;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class BigtableTableAdminClient
implements AutoCloseable {
    private final BigtableTableAdminStub stub;
    private final InstanceName instanceName;

    public static BigtableTableAdminClient create(@Nonnull InstanceName instanceName) throws IOException {
        return BigtableTableAdminClient.create(BigtableTableAdminSettings.newBuilder().setInstanceName(instanceName).build());
    }

    public static BigtableTableAdminClient create(@Nonnull BigtableTableAdminSettings settings) throws IOException {
        return BigtableTableAdminClient.create(settings.getInstanceName(), settings.getStubSettings().createStub());
    }

    public static BigtableTableAdminClient create(@Nonnull InstanceName instanceName, @Nonnull BigtableTableAdminStub stub) {
        return new BigtableTableAdminClient(instanceName, stub);
    }

    private BigtableTableAdminClient(@Nonnull InstanceName instanceName, @Nonnull BigtableTableAdminStub stub) {
        Preconditions.checkNotNull((Object)instanceName);
        Preconditions.checkNotNull((Object)stub);
        this.instanceName = instanceName;
        this.stub = stub;
    }

    public InstanceName getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public Table createTable(CreateTableRequest request) {
        return this.awaitFuture(this.createTableAsync(request));
    }

    public ApiFuture<Table> createTableAsync(CreateTableRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.createTableCallable().futureCall((Object)request.toProto(this.instanceName)));
    }

    public Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        return this.awaitFuture(this.modifyFamiliesAsync(request));
    }

    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.modifyColumnFamiliesCallable().futureCall((Object)request.toProto(this.instanceName)));
    }

    public void deleteTable(String tableId) {
        this.awaitFuture(this.deleteTableAsync(tableId));
    }

    public ApiFuture<Void> deleteTableAsync(String tableId) {
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteTableCallable().futureCall((Object)this.composeDeleteTableRequest(tableId)));
    }

    public Table getTable(String tableId) {
        return this.awaitFuture(this.getTableAsync(tableId));
    }

    public ApiFuture<Table> getTableAsync(String tableId) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.getTableCallable().futureCall((Object)this.composeGetTableRequest(tableId)));
    }

    public List<TableName> listTables() {
        return this.awaitFuture(this.listTablesAsync());
    }

    public ApiFuture<List<TableName>> listTablesAsync() {
        ApiFuture listResp = this.stub.listTablesPagedCallable().futureCall((Object)this.composeListTableRequest());
        return ApiFutures.transform((ApiFuture)listResp, (ApiFunction)new ApiFunction<BaseBigtableTableAdminClient.ListTablesPagedResponse, List<TableName>>(){

            public List<TableName> apply(BaseBigtableTableAdminClient.ListTablesPagedResponse input) {
                return BigtableTableAdminClient.convertToTableNames(input.iterateAll());
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void dropRowRange(String tableId, String rowKeyPrefix) {
        this.awaitFuture(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        this.awaitFuture(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)this.composeDropRowRangeRequest(tableId, rowKeyPrefix, false)));
    }

    public void dropAllRows(String tableId) {
        this.awaitFuture(this.dropAllRowsAsync(tableId));
    }

    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)this.composeDropRowRangeRequest(tableId, null, true)));
    }

    public ConsistencyToken generateConsistencyToken(String tableId) {
        return this.awaitFuture(this.generateConsistencyTokenAsync(tableId));
    }

    public ApiFuture<ConsistencyToken> generateConsistencyTokenAsync(String tableId) {
        ApiFuture tokenResp = this.stub.generateConsistencyTokenCallable().futureCall((Object)this.composeGenerateConsistencyTokenRequest(tableId));
        return ApiFutures.transform((ApiFuture)tokenResp, (ApiFunction)new ApiFunction<GenerateConsistencyTokenResponse, ConsistencyToken>(){

            public ConsistencyToken apply(GenerateConsistencyTokenResponse input) {
                return ConsistencyToken.fromProto(input);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public boolean isConsistent(String tableId, ConsistencyToken token) {
        return this.awaitFuture(this.isConsistentAsync(tableId, token));
    }

    public ApiFuture<Boolean> isConsistentAsync(String tableId, ConsistencyToken token) {
        ApiFuture checkConsResp = this.stub.checkConsistencyCallable().futureCall((Object)token.toProto(this.getTableName(tableId)));
        return ApiFutures.transform((ApiFuture)checkConsResp, (ApiFunction)new ApiFunction<CheckConsistencyResponse, Boolean>(){

            public Boolean apply(CheckConsistencyResponse input) {
                return input.getConsistent();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @VisibleForTesting
    String getTableName(String tableId) {
        return TableName.of((String)this.instanceName.getProject(), (String)this.instanceName.getInstance(), (String)tableId).toString();
    }

    @VisibleForTesting
    ListTablesRequest composeListTableRequest() {
        return ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
    }

    @VisibleForTesting
    GetTableRequest composeGetTableRequest(String tableId) {
        return GetTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
    }

    @VisibleForTesting
    DeleteTableRequest composeDeleteTableRequest(String tableId) {
        return DeleteTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
    }

    @VisibleForTesting
    DropRowRangeRequest composeDropRowRangeRequest(String tableId, ByteString rowKeyPrefix, boolean dropAll) {
        DropRowRangeRequest.Builder dropRowReq = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId));
        if (dropAll) {
            dropRowReq.setDeleteAllDataFromTable(true);
        } else {
            dropRowReq.setRowKeyPrefix(rowKeyPrefix);
        }
        return dropRowReq.build();
    }

    @VisibleForTesting
    GenerateConsistencyTokenRequest composeGenerateConsistencyTokenRequest(String tableId) {
        return GenerateConsistencyTokenRequest.newBuilder().setName(this.getTableName(tableId)).build();
    }

    @VisibleForTesting
    static List<TableName> convertToTableNames(Iterable<com.google.bigtable.admin.v2.Table> listTablesResponse) {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        for (com.google.bigtable.admin.v2.Table table : listTablesResponse) {
            tableNames.add(TableName.parse((String)table.getName()));
        }
        return tableNames;
    }

    private static ApiFuture<Table> transformToTableResponse(ApiFuture<com.google.bigtable.admin.v2.Table> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table table) {
                return Table.fromProto(table);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static ApiFuture<Void> transformToVoid(ApiFuture<Empty> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private <T> T awaitFuture(ApiFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

