/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.ConsistencyToken;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class BigtableTableAdminClient
implements AutoCloseable {
    private final BigtableTableAdminStub stub;
    private final InstanceName instanceName;

    public static BigtableTableAdminClient create(@Nonnull InstanceName instanceName) throws IOException {
        return BigtableTableAdminClient.create(BigtableTableAdminSettings.newBuilder().setInstanceName(instanceName).build());
    }

    public static BigtableTableAdminClient create(@Nonnull BigtableTableAdminSettings settings) throws IOException {
        return BigtableTableAdminClient.create(settings.getInstanceName(), settings.getStubSettings().createStub());
    }

    public static BigtableTableAdminClient create(@Nonnull InstanceName instanceName, @Nonnull BigtableTableAdminStub stub) {
        return new BigtableTableAdminClient(instanceName, stub);
    }

    private BigtableTableAdminClient(@Nonnull InstanceName instanceName, @Nonnull BigtableTableAdminStub stub) {
        Preconditions.checkNotNull((Object)instanceName);
        Preconditions.checkNotNull((Object)stub);
        this.instanceName = instanceName;
        this.stub = stub;
    }

    public InstanceName getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public Table createTable(CreateTableRequest request) {
        return this.awaitFuture(this.createTableAsync(request));
    }

    public ApiFuture<Table> createTableAsync(CreateTableRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.createTableCallable().futureCall((Object)request.toProto(this.instanceName)));
    }

    public Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        return this.awaitFuture(this.modifyFamiliesAsync(request));
    }

    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.modifyColumnFamiliesCallable().futureCall((Object)request.toProto(this.instanceName)));
    }

    public void deleteTable(String tableId) {
        this.awaitFuture(this.deleteTableAsync(tableId));
    }

    public ApiFuture<Void> deleteTableAsync(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteTableCallable().futureCall((Object)request));
    }

    public Table getTable(String tableId) {
        return this.awaitFuture(this.getTableAsync(tableId));
    }

    public ApiFuture<Table> getTableAsync(String tableId) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.getTableCallable().futureCall((Object)request));
    }

    public List<TableName> listTables() {
        return this.awaitFuture(this.listTablesAsync());
    }

    public ApiFuture<List<TableName>> listTablesAsync() {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
        ApiFuture firstPageFuture = ApiFutures.transform((ApiFuture)this.stub.listTablesPagedCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<BaseBigtableTableAdminClient.ListTablesPagedResponse, BaseBigtableTableAdminClient.ListTablesPage>(){

            public BaseBigtableTableAdminClient.ListTablesPage apply(BaseBigtableTableAdminClient.ListTablesPagedResponse response) {
                return (BaseBigtableTableAdminClient.ListTablesPage)response.getPage();
            }
        }, (Executor)MoreExecutors.directExecutor());
        ApiFuture allProtos = ApiFutures.transformAsync((ApiFuture)firstPageFuture, (ApiAsyncFunction)new ApiAsyncFunction<BaseBigtableTableAdminClient.ListTablesPage, List<com.google.bigtable.admin.v2.Table>>(){
            List<com.google.bigtable.admin.v2.Table> responseAccumulator = Lists.newArrayList();

            public ApiFuture<List<com.google.bigtable.admin.v2.Table>> apply(BaseBigtableTableAdminClient.ListTablesPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList((Iterable)page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync((ApiFuture)page.getNextPageAsync(), (ApiAsyncFunction)this, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform((ApiFuture)allProtos, (ApiFunction)new ApiFunction<List<com.google.bigtable.admin.v2.Table>, List<TableName>>(){

            public List<TableName> apply(List<com.google.bigtable.admin.v2.Table> protos) {
                ArrayList results = Lists.newArrayListWithCapacity((int)protos.size());
                for (com.google.bigtable.admin.v2.Table proto : protos) {
                    results.add(TableName.parse((String)proto.getName()));
                }
                return results;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void dropRowRange(String tableId, String rowKeyPrefix) {
        this.awaitFuture(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        this.awaitFuture(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId)).setRowKeyPrefix(rowKeyPrefix).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)request));
    }

    public void dropAllRows(String tableId) {
        this.awaitFuture(this.dropAllRowsAsync(tableId));
    }

    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId)).setDeleteAllDataFromTable(true).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)request));
    }

    public ConsistencyToken generateConsistencyToken(String tableId) {
        return this.awaitFuture(this.generateConsistencyTokenAsync(tableId));
    }

    public ApiFuture<ConsistencyToken> generateConsistencyTokenAsync(final String tableId) {
        GenerateConsistencyTokenRequest request = GenerateConsistencyTokenRequest.newBuilder().setName(this.getTableName(tableId)).build();
        return ApiFutures.transform((ApiFuture)this.stub.generateConsistencyTokenCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<GenerateConsistencyTokenResponse, ConsistencyToken>(){

            public ConsistencyToken apply(GenerateConsistencyTokenResponse proto) {
                TableName tableName = TableName.of((String)BigtableTableAdminClient.this.instanceName.getProject(), (String)BigtableTableAdminClient.this.instanceName.getInstance(), (String)tableId);
                return ConsistencyToken.of(tableName, proto.getConsistencyToken());
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public boolean isConsistent(ConsistencyToken token) {
        return this.awaitFuture(this.isConsistentAsync(token));
    }

    @VisibleForTesting
    ApiFuture<Boolean> isConsistentAsync(ConsistencyToken token) {
        ApiFuture checkConsResp = this.stub.checkConsistencyCallable().futureCall((Object)token.toProto(this.instanceName));
        return ApiFutures.transform((ApiFuture)checkConsResp, (ApiFunction)new ApiFunction<CheckConsistencyResponse, Boolean>(){

            public Boolean apply(CheckConsistencyResponse input) {
                return input.getConsistent();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private String getTableName(String tableId) {
        return TableName.of((String)this.instanceName.getProject(), (String)this.instanceName.getInstance(), (String)tableId).toString();
    }

    private static ApiFuture<Table> transformToTableResponse(ApiFuture<com.google.bigtable.admin.v2.Table> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table table) {
                return Table.fromProto(table);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static ApiFuture<Void> transformToVoid(ApiFuture<Empty> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private <T> T awaitFuture(ApiFuture<T> future) {
        Throwable error;
        try {
            return (T)Futures.getUnchecked(future);
        }
        catch (UncheckedExecutionException e) {
            error = e.getCause() instanceof RuntimeException ? (RuntimeException)e.getCause() : e;
        }
        catch (RuntimeException e) {
            error = e;
        }
        error.addSuppressed(new RuntimeException("Encountered error while awaiting future"));
        throw error;
    }
}

