/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.LocationName;
import com.google.bigtable.admin.v2.StorageType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public class Cluster {
    @Nonnull
    private final com.google.bigtable.admin.v2.Cluster proto;

    @InternalApi
    public static Cluster fromProto(com.google.bigtable.admin.v2.Cluster proto) {
        return new Cluster(proto);
    }

    private Cluster(@Nonnull com.google.bigtable.admin.v2.Cluster proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Name must be set");
        this.proto = proto;
    }

    public String getId() {
        ClusterName fullName = (ClusterName)Verify.verifyNotNull((Object)ClusterName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getCluster();
    }

    public String getInstanceId() {
        ClusterName fullName = (ClusterName)Verify.verifyNotNull((Object)ClusterName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getZone() {
        LocationName location = (LocationName)Verify.verifyNotNull((Object)LocationName.parse((String)this.proto.getLocation()));
        return location.getLocation();
    }

    public Cluster.State getState() {
        return this.proto.getState();
    }

    public int getServeNodes() {
        return this.proto.getServeNodes();
    }

    public StorageType getStorageType() {
        return this.proto.getDefaultStorageType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return Objects.equal((Object)this.proto, (Object)cluster.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }
}

