/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_ConsistencyToken;
import com.google.common.base.Preconditions;

@InternalExtensionOnly
public abstract class ConsistencyToken {
    public static ConsistencyToken of(TableName tableName, String token) {
        return new AutoValue_ConsistencyToken(tableName, token);
    }

    abstract TableName getTableName();

    abstract String getToken();

    @InternalApi
    public CheckConsistencyRequest toProto(InstanceName instanceName) {
        Preconditions.checkArgument((boolean)instanceName.equals((Object)InstanceName.of((String)this.getTableName().getProject(), (String)this.getTableName().getInstance())), (Object)"Consistency tokens are only valid within a single instance.");
        return CheckConsistencyRequest.newBuilder().setName(this.getTableName().toString()).setConsistencyToken(this.getToken()).build();
    }
}

