/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.LocationName;
import com.google.bigtable.admin.v2.ProjectName;
import com.google.bigtable.admin.v2.StorageType;

public final class CreateClusterRequest {
    private final CreateClusterRequest.Builder proto = com.google.bigtable.admin.v2.CreateClusterRequest.newBuilder();
    private final String instanceId;
    private String zone;

    public static CreateClusterRequest of(String instanceId, String clusterId) {
        return new CreateClusterRequest(instanceId, clusterId);
    }

    private CreateClusterRequest(String instanceId, String clusterId) {
        this.instanceId = instanceId;
        this.proto.setClusterId(clusterId);
        this.proto.getClusterBuilder().setDefaultStorageType(StorageType.SSD);
    }

    public CreateClusterRequest setZone(String zone) {
        this.zone = zone;
        return this;
    }

    public CreateClusterRequest setServeNodes(int numNodes) {
        this.proto.getClusterBuilder().setServeNodes(numNodes);
        return this;
    }

    public CreateClusterRequest setStorageType(StorageType storageType) {
        this.proto.getClusterBuilder().setDefaultStorageType(storageType);
        return this;
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateClusterRequest toProto(ProjectName projectName) {
        this.proto.setParent(InstanceName.of((String)projectName.getProject(), (String)this.instanceId).toString());
        this.proto.getClusterBuilder().setLocation(LocationName.of((String)projectName.getProject(), (String)this.zone).toString());
        return this.proto.build();
    }

    @InternalApi
    String getClusterId() {
        return this.proto.getClusterId();
    }

    @InternalApi
    Cluster toEmbeddedProto(ProjectName projectName) {
        this.proto.getClusterBuilder().setLocation(LocationName.of((String)projectName.getProject(), (String)this.zone).toString());
        return this.proto.getClusterBuilder().build();
    }
}

