/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Instance {
    @Nonnull
    private final com.google.bigtable.admin.v2.Instance proto;

    @InternalApi
    public static Instance fromProto(@Nonnull com.google.bigtable.admin.v2.Instance proto) {
        return new Instance(proto);
    }

    private Instance(@Nonnull com.google.bigtable.admin.v2.Instance proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Name must be set");
        this.proto = proto;
    }

    public String getId() {
        InstanceName fullName = (InstanceName)Verify.verifyNotNull((Object)InstanceName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getDisplayName() {
        return this.proto.getDisplayName();
    }

    public Instance.Type getType() {
        return this.proto.getType();
    }

    public Map<String, String> getLabels() {
        return this.proto.getLabelsMap();
    }

    public Instance.State getState() {
        return this.proto.getState();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Instance instance = (Instance)o;
        return Objects.equal((Object)this.proto, (Object)instance.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }
}

