/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.common.base.Preconditions;

public final class ModifyColumnFamiliesRequest {
    private final ModifyColumnFamiliesRequest.Builder modFamilyRequest = com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.newBuilder();
    private final String tableId;

    public static ModifyColumnFamiliesRequest of(String tableId) {
        return new ModifyColumnFamiliesRequest(tableId);
    }

    ModifyColumnFamiliesRequest(String tableId) {
        Preconditions.checkNotNull((Object)tableId);
        this.tableId = tableId;
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId) {
        return this.addFamily(familyId, GCRules.GCRULES.defaultRule());
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull((Object)gcRule);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
        modification.getCreateBuilder().setGcRule(gcRule.toProto());
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    public ModifyColumnFamiliesRequest updateFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull((Object)gcRule);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
        modification.getUpdateBuilder().setGcRule(gcRule.toProto());
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    public ModifyColumnFamiliesRequest dropFamily(String familyId) {
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId).setDrop(true);
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    @InternalApi
    public com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest toProto(InstanceName instanceName) {
        Preconditions.checkNotNull((Object)instanceName);
        String tableName = TableName.of((String)instanceName.getProject(), (String)instanceName.getInstance(), (String)this.tableId).toString();
        return this.modFamilyRequest.setName(tableName).build();
    }
}

