/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.resourcenames.ResourceName;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.LocationName;
import com.google.bigtable.admin.v2.ProjectName;
import com.google.cloud.Policy;
import com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.CreateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateClusterRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.admin.v2.models.PartialListClustersException;
import com.google.cloud.bigtable.admin.v2.models.PartialListInstancesException;
import com.google.cloud.bigtable.admin.v2.models.UpdateAppProfileRequest;
import com.google.cloud.bigtable.admin.v2.models.UpdateInstanceRequest;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class BigtableInstanceAdminClient
implements AutoCloseable {
    private final ProjectName projectName;
    private final BigtableInstanceAdminStub stub;

    public static BigtableInstanceAdminClient create(@Nonnull ProjectName projectName) throws IOException {
        return BigtableInstanceAdminClient.create(BigtableInstanceAdminSettings.newBuilder().setProjectName(projectName).build());
    }

    public static BigtableInstanceAdminClient create(@Nonnull BigtableInstanceAdminSettings settings) throws IOException {
        return BigtableInstanceAdminClient.create(settings.getProjectName(), settings.getStubSettings().createStub());
    }

    public static BigtableInstanceAdminClient create(@Nonnull ProjectName projectName, @Nonnull BigtableInstanceAdminStub stub) {
        return new BigtableInstanceAdminClient(projectName, stub);
    }

    private BigtableInstanceAdminClient(@Nonnull ProjectName projectName, @Nonnull BigtableInstanceAdminStub stub) {
        this.projectName = projectName;
        this.stub = stub;
    }

    public ProjectName getProjectName() {
        return this.projectName;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public Instance createInstance(CreateInstanceRequest request) {
        return (Instance)ApiExceptions.callAndTranslateApiException(this.createInstanceAsync(request));
    }

    public ApiFuture<Instance> createInstanceAsync(CreateInstanceRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.createInstanceOperationCallable().futureCall((Object)request.toProto(this.projectName)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Instance, Instance>(){

            public Instance apply(com.google.bigtable.admin.v2.Instance proto) {
                return Instance.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Instance updateInstance(UpdateInstanceRequest request) {
        return (Instance)ApiExceptions.callAndTranslateApiException(this.updateInstanceAsync(request));
    }

    public ApiFuture<Instance> updateInstanceAsync(UpdateInstanceRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.partialUpdateInstanceOperationCallable().futureCall((Object)request.toProto(this.projectName)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Instance, Instance>(){

            public Instance apply(com.google.bigtable.admin.v2.Instance proto) {
                return Instance.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Instance getInstance(String id) {
        return (Instance)ApiExceptions.callAndTranslateApiException(this.getInstanceAsync(id));
    }

    public ApiFuture<Instance> getInstanceAsync(String instanceId) {
        InstanceName name = InstanceName.of((String)this.projectName.getProject(), (String)instanceId);
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.getInstanceCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Instance, Instance>(){

            public Instance apply(com.google.bigtable.admin.v2.Instance proto) {
                return Instance.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<Instance> listInstances() {
        return (List)ApiExceptions.callAndTranslateApiException(this.listInstancesAsync());
    }

    public ApiFuture<List<Instance>> listInstancesAsync() {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(this.projectName.toString()).build();
        ApiFuture responseFuture = this.stub.listInstancesCallable().futureCall((Object)request);
        return ApiFutures.transform((ApiFuture)responseFuture, (ApiFunction)new ApiFunction<ListInstancesResponse, List<Instance>>(){

            public List<Instance> apply(ListInstancesResponse proto) {
                Verify.verify((boolean)proto.getNextPageToken().isEmpty(), (String)"Server returned an unexpected paginated response", (Object[])new Object[0]);
                ImmutableList.Builder instances = ImmutableList.builder();
                for (com.google.bigtable.admin.v2.Instance protoInstance : proto.getInstancesList()) {
                    instances.add((Object)Instance.fromProto(protoInstance));
                }
                ImmutableList.Builder failedZones = ImmutableList.builder();
                for (String locationStr : proto.getFailedLocationsList()) {
                    LocationName fullLocation = Objects.requireNonNull(LocationName.parse((String)locationStr));
                    failedZones.add((Object)fullLocation.getLocation());
                }
                if (!failedZones.build().isEmpty()) {
                    throw new PartialListInstancesException((List<String>)failedZones.build(), (List<Instance>)instances.build());
                }
                return instances.build();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void deleteInstance(String instanceId) {
        ApiExceptions.callAndTranslateApiException(this.deleteInstanceAsync(instanceId));
    }

    public ApiFuture<Void> deleteInstanceAsync(String instanceId) {
        InstanceName instanceName = InstanceName.of((String)this.projectName.getProject(), (String)instanceId);
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(instanceName.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.deleteInstanceCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty input) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Cluster createCluster(CreateClusterRequest request) {
        return (Cluster)ApiExceptions.callAndTranslateApiException(this.createClusterAsync(request));
    }

    public ApiFuture<Cluster> createClusterAsync(CreateClusterRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.createClusterOperationCallable().futureCall((Object)request.toProto(this.projectName)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Cluster, Cluster>(){

            public Cluster apply(com.google.bigtable.admin.v2.Cluster proto) {
                return Cluster.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Cluster getCluster(String instanceId, String clusterId) {
        return (Cluster)ApiExceptions.callAndTranslateApiException(this.getClusterAsync(instanceId, clusterId));
    }

    public ApiFuture<Cluster> getClusterAsync(String instanceId, String clusterId) {
        ClusterName name = ClusterName.of((String)this.projectName.getProject(), (String)instanceId, (String)clusterId);
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.getClusterCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Cluster, Cluster>(){

            public Cluster apply(com.google.bigtable.admin.v2.Cluster proto) {
                return Cluster.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<Cluster> listClusters(String instanceId) {
        return (List)ApiExceptions.callAndTranslateApiException(this.listClustersAsync(instanceId));
    }

    public ApiFuture<List<Cluster>> listClustersAsync(String instanceId) {
        InstanceName name = InstanceName.of((String)this.projectName.getProject(), (String)instanceId);
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(name.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.listClustersCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<ListClustersResponse, List<Cluster>>(){

            public List<Cluster> apply(ListClustersResponse proto) {
                Verify.verify((boolean)proto.getNextPageToken().isEmpty(), (String)"Server returned an unexpected paginated response", (Object[])new Object[0]);
                ImmutableList.Builder clusters = ImmutableList.builder();
                for (com.google.bigtable.admin.v2.Cluster cluster : proto.getClustersList()) {
                    clusters.add((Object)Cluster.fromProto(cluster));
                }
                ImmutableList.Builder failedZones = ImmutableList.builder();
                for (String locationStr : proto.getFailedLocationsList()) {
                    LocationName fullLocation = Objects.requireNonNull(LocationName.parse((String)locationStr));
                    failedZones.add((Object)fullLocation.getLocation());
                }
                if (!failedZones.build().isEmpty()) {
                    throw new PartialListClustersException((List<String>)failedZones.build(), (List<Cluster>)clusters.build());
                }
                return clusters.build();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Cluster resizeCluster(String instanceId, String clusterId, int numServeNodes) {
        return (Cluster)ApiExceptions.callAndTranslateApiException(this.resizeClusterAsync(instanceId, clusterId, numServeNodes));
    }

    public ApiFuture<Cluster> resizeClusterAsync(String instanceId, String clusterId, int numServeNodes) {
        ClusterName name = ClusterName.of((String)this.projectName.getProject(), (String)instanceId, (String)clusterId);
        com.google.bigtable.admin.v2.Cluster request = com.google.bigtable.admin.v2.Cluster.newBuilder().setName(name.toString()).setServeNodes(numServeNodes).build();
        return ApiFutures.transform((ApiFuture)this.stub.updateClusterOperationCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Cluster, Cluster>(){

            public Cluster apply(com.google.bigtable.admin.v2.Cluster proto) {
                return Cluster.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void deleteCluster(String instanceId, String clusterId) {
        ApiExceptions.callAndTranslateApiException(this.deleteClusterAsync(instanceId, clusterId));
    }

    public ApiFuture<Void> deleteClusterAsync(String instanceId, String clusterId) {
        ClusterName name = ClusterName.of((String)this.projectName.getProject(), (String)instanceId, (String)clusterId);
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.deleteClusterCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty input) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public AppProfile createAppProfile(CreateAppProfileRequest request) {
        return (AppProfile)ApiExceptions.callAndTranslateApiException(this.createAppProfileAsync(request));
    }

    public ApiFuture<AppProfile> createAppProfileAsync(CreateAppProfileRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.createAppProfileCallable().futureCall((Object)request.toProto(this.projectName)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.AppProfile, AppProfile>(){

            public AppProfile apply(com.google.bigtable.admin.v2.AppProfile proto) {
                return AppProfile.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public AppProfile getAppProfile(String instanceId, String appProfileId) {
        return (AppProfile)ApiExceptions.callAndTranslateApiException(this.getAppProfileAsync(instanceId, appProfileId));
    }

    public ApiFuture<AppProfile> getAppProfileAsync(String instanceId, String appProfileId) {
        AppProfileName name = AppProfileName.of((String)this.projectName.getProject(), (String)instanceId, (String)appProfileId);
        GetAppProfileRequest request = GetAppProfileRequest.newBuilder().setName(name.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.getAppProfileCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.AppProfile, AppProfile>(){

            public AppProfile apply(com.google.bigtable.admin.v2.AppProfile proto) {
                return AppProfile.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<AppProfile> listAppProfiles(String instanceId) {
        return (List)ApiExceptions.callAndTranslateApiException(this.listAppProfilesAsync(instanceId));
    }

    public ApiFuture<List<AppProfile>> listAppProfilesAsync(String instanceId) {
        InstanceName instanceName = InstanceName.of((String)this.projectName.getProject(), (String)instanceId);
        ListAppProfilesRequest request = ListAppProfilesRequest.newBuilder().setParent(instanceName.toString()).build();
        ApiFuture firstPageFuture = ApiFutures.transform((ApiFuture)this.stub.listAppProfilesPagedCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse, BaseBigtableInstanceAdminClient.ListAppProfilesPage>(){

            public BaseBigtableInstanceAdminClient.ListAppProfilesPage apply(BaseBigtableInstanceAdminClient.ListAppProfilesPagedResponse response) {
                return (BaseBigtableInstanceAdminClient.ListAppProfilesPage)response.getPage();
            }
        }, (Executor)MoreExecutors.directExecutor());
        ApiFuture allProtos = ApiFutures.transformAsync((ApiFuture)firstPageFuture, (ApiAsyncFunction)new ApiAsyncFunction<BaseBigtableInstanceAdminClient.ListAppProfilesPage, List<com.google.bigtable.admin.v2.AppProfile>>(){
            List<com.google.bigtable.admin.v2.AppProfile> responseAccumulator = Lists.newArrayList();

            public ApiFuture<List<com.google.bigtable.admin.v2.AppProfile>> apply(BaseBigtableInstanceAdminClient.ListAppProfilesPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList((Iterable)page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync((ApiFuture)page.getNextPageAsync(), (ApiAsyncFunction)this, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform((ApiFuture)allProtos, (ApiFunction)new ApiFunction<List<com.google.bigtable.admin.v2.AppProfile>, List<AppProfile>>(){

            public List<AppProfile> apply(List<com.google.bigtable.admin.v2.AppProfile> input) {
                ArrayList results = Lists.newArrayListWithCapacity((int)input.size());
                for (com.google.bigtable.admin.v2.AppProfile appProfile : input) {
                    results.add(AppProfile.fromProto(appProfile));
                }
                return results;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public AppProfile updateAppProfile(UpdateAppProfileRequest request) {
        return (AppProfile)ApiExceptions.callAndTranslateApiException(this.updateAppProfileAsync(request));
    }

    public ApiFuture<AppProfile> updateAppProfileAsync(UpdateAppProfileRequest request) {
        return ApiFutures.transform((ApiFuture)this.stub.updateAppProfileOperationCallable().futureCall((Object)request.toProto(this.projectName)), (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.AppProfile, AppProfile>(){

            public AppProfile apply(com.google.bigtable.admin.v2.AppProfile proto) {
                return AppProfile.fromProto(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void deleteAppProfile(String instanceId, String appProfileId) {
        ApiExceptions.callAndTranslateApiException(this.deleteAppProfileAsync(instanceId, appProfileId));
    }

    public ApiFuture<Void> deleteAppProfileAsync(String instanceId, String appProfileId) {
        AppProfileName name = AppProfileName.of((String)this.projectName.getProject(), (String)instanceId, (String)appProfileId);
        DeleteAppProfileRequest request = DeleteAppProfileRequest.newBuilder().setName(name.toString()).build();
        return ApiFutures.transform((ApiFuture)this.stub.deleteAppProfileCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty input) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Policy getIamPolicy(String instanceId) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.getIamPolicyAsync(instanceId));
    }

    public ApiFuture<Policy> getIamPolicyAsync(String instanceId) {
        InstanceName name = InstanceName.of((String)this.projectName.getProject(), (String)instanceId);
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(name.toString()).build();
        final IamPolicyMarshaller marshaller = new IamPolicyMarshaller();
        return ApiFutures.transform((ApiFuture)this.stub.getIamPolicyCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.iam.v1.Policy, Policy>(){

            public Policy apply(com.google.iam.v1.Policy proto) {
                return marshaller.fromPb(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Policy setIamPolicy(String instanceId, Policy policy) {
        return (Policy)ApiExceptions.callAndTranslateApiException(this.setIamPolicyAsync(instanceId, policy));
    }

    public ApiFuture<Policy> setIamPolicyAsync(String instanceId, Policy policy) {
        InstanceName name = InstanceName.of((String)this.projectName.getProject(), (String)instanceId);
        final IamPolicyMarshaller marshaller = new IamPolicyMarshaller();
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(name.toString()).setPolicy(marshaller.toPb(policy)).build();
        return ApiFutures.transform((ApiFuture)this.stub.setIamPolicyCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<com.google.iam.v1.Policy, Policy>(){

            public Policy apply(com.google.iam.v1.Policy proto) {
                return marshaller.fromPb(proto);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public List<String> testIamPermission(String instanceId, String ... permissions) {
        return this.testIamPermission((ResourceName)InstanceName.of((String)this.projectName.getProject(), (String)instanceId), permissions);
    }

    public ApiFuture<List<String>> testIamPermissionAsync(String instanceId, String ... permissions) {
        return this.testIamPermissionAsync((ResourceName)InstanceName.of((String)this.projectName.getProject(), (String)instanceId), permissions);
    }

    public List<String> testIamPermission(ResourceName resourceName, String ... permissions) {
        return (List)ApiExceptions.callAndTranslateApiException(this.testIamPermissionAsync(resourceName, permissions));
    }

    public ApiFuture<List<String>> testIamPermissionAsync(ResourceName resourceName, String ... permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resourceName.toString()).addAllPermissions(Arrays.asList(permissions)).build();
        return ApiFutures.transform((ApiFuture)this.stub.testIamPermissionsCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<TestIamPermissionsResponse, List<String>>(){

            public List<String> apply(TestIamPermissionsResponse input) {
                return input.getPermissionsList();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static class IamPolicyMarshaller
    extends Policy.DefaultMarshaller {
        private IamPolicyMarshaller() {
        }

        public Policy fromPb(com.google.iam.v1.Policy policyPb) {
            return super.fromPb(policyPb);
        }

        public com.google.iam.v1.Policy toPb(Policy policy) {
            return super.toPb(policy);
        }
    }
}

