/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.admin.v2.ProjectName;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BigtableInstanceAdminSettings {
    private final ProjectName projectName;
    private final BigtableInstanceAdminStubSettings stubSettings;

    private BigtableInstanceAdminSettings(Builder builder) throws IOException {
        Preconditions.checkNotNull((Object)builder.projectName, (Object)"ProjectName must be set");
        Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]);
        this.projectName = builder.projectName;
        this.stubSettings = builder.stubSettings.build();
    }

    @Nonnull
    public ProjectName getProjectName() {
        return this.projectName;
    }

    @Nonnull
    public BigtableInstanceAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ProjectName projectName;
        private final BigtableInstanceAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableInstanceAdminStubSettings.newBuilder();
        }

        private Builder(BigtableInstanceAdminSettings settings) {
            this.projectName = settings.projectName;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectName(@Nonnull ProjectName projectName) {
            Preconditions.checkNotNull((Object)projectName);
            this.projectName = projectName;
            return this;
        }

        @Nullable
        public ProjectName getProjectName() {
            return this.projectName;
        }

        public BigtableInstanceAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableInstanceAdminSettings build() throws IOException {
            return new BigtableInstanceAdminSettings(this);
        }
    }
}

