/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.admin.v2.InstanceName;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BigtableTableAdminSettings {
    private final InstanceName instanceName;
    private final BigtableTableAdminStubSettings stubSettings;

    private BigtableTableAdminSettings(Builder builder) throws IOException {
        this.instanceName = (InstanceName)Preconditions.checkNotNull((Object)builder.instanceName, (Object)"InstanceName must be set");
        this.stubSettings = ((BigtableTableAdminStubSettings.Builder)((Object)Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]))).build();
    }

    @Nonnull
    public InstanceName getInstanceName() {
        return this.instanceName;
    }

    public BigtableTableAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private InstanceName instanceName;
        private final BigtableTableAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableTableAdminStubSettings.newBuilder();
        }

        private Builder(BigtableTableAdminSettings settings) {
            this.instanceName = settings.instanceName;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setInstanceName(@Nonnull InstanceName instanceName) {
            Preconditions.checkNotNull((Object)instanceName);
            this.instanceName = instanceName;
            return this;
        }

        @Nullable
        public InstanceName getInstanceName() {
            return this.instanceName;
        }

        public BigtableTableAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableTableAdminSettings build() throws IOException {
            return new BigtableTableAdminSettings(this);
        }
    }
}

