/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiExceptions;
import com.google.api.gax.rpc.NotFoundException;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.stub.EnhancedBigtableTableAdminStub;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public final class BigtableTableAdminClient
implements AutoCloseable {
    private final EnhancedBigtableTableAdminStub stub;
    private final InstanceName instanceName;

    public static BigtableTableAdminClient create(@Nonnull InstanceName instanceName) throws IOException {
        return BigtableTableAdminClient.create(BigtableTableAdminSettings.newBuilder().setInstanceName(instanceName).build());
    }

    public static BigtableTableAdminClient create(@Nonnull BigtableTableAdminSettings settings) throws IOException {
        EnhancedBigtableTableAdminStub stub = EnhancedBigtableTableAdminStub.createEnhanced(settings.getStubSettings());
        return BigtableTableAdminClient.create(settings.getInstanceName(), stub);
    }

    public static BigtableTableAdminClient create(@Nonnull InstanceName instanceName, @Nonnull EnhancedBigtableTableAdminStub stub) {
        return new BigtableTableAdminClient(instanceName, stub);
    }

    private BigtableTableAdminClient(@Nonnull InstanceName instanceName, @Nonnull EnhancedBigtableTableAdminStub stub) {
        Preconditions.checkNotNull((Object)instanceName);
        Preconditions.checkNotNull((Object)stub);
        this.instanceName = instanceName;
        this.stub = stub;
    }

    public InstanceName getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void close() {
        this.stub.close();
    }

    public Table createTable(CreateTableRequest request) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.createTableAsync(request));
    }

    public ApiFuture<Table> createTableAsync(CreateTableRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.createTableCallable().futureCall((Object)request.toProto(this.instanceName)));
    }

    public Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.modifyFamiliesAsync(request));
    }

    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.modifyColumnFamiliesCallable().futureCall((Object)request.toProto(this.instanceName)));
    }

    public void deleteTable(String tableId) {
        ApiExceptions.callAndTranslateApiException(this.deleteTableAsync(tableId));
    }

    public ApiFuture<Void> deleteTableAsync(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.getTableName(tableId)).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.deleteTableCallable().futureCall((Object)request));
    }

    public boolean exists(String tableId) {
        return (Boolean)ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId));
    }

    public ApiFuture<Boolean> existsAsync(String tableId) {
        ApiFuture<Table> protoFuture = this.getTableAsync(tableId, Table.View.NAME_ONLY);
        ApiFuture existsFuture = ApiFutures.transform(protoFuture, (ApiFunction)new ApiFunction<Table, Boolean>(){

            public Boolean apply(Table ignored) {
                return true;
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.catching((ApiFuture)existsFuture, NotFoundException.class, (ApiFunction)new ApiFunction<NotFoundException, Boolean>(){

            public Boolean apply(NotFoundException ignored) {
                return false;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Table getTable(String tableId) {
        return (Table)ApiExceptions.callAndTranslateApiException(this.getTableAsync(tableId));
    }

    public ApiFuture<Table> getTableAsync(String tableId) {
        return this.getTableAsync(tableId, Table.View.SCHEMA_VIEW);
    }

    private ApiFuture<Table> getTableAsync(String tableId, Table.View view) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(this.getTableName(tableId)).setView(view).build();
        return BigtableTableAdminClient.transformToTableResponse((ApiFuture<com.google.bigtable.admin.v2.Table>)this.stub.getTableCallable().futureCall((Object)request));
    }

    public List<String> listTables() {
        return (List)ApiExceptions.callAndTranslateApiException(this.listTablesAsync());
    }

    public ApiFuture<List<String>> listTablesAsync() {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
        ApiFuture firstPageFuture = ApiFutures.transform((ApiFuture)this.stub.listTablesPagedCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<BaseBigtableTableAdminClient.ListTablesPagedResponse, BaseBigtableTableAdminClient.ListTablesPage>(){

            public BaseBigtableTableAdminClient.ListTablesPage apply(BaseBigtableTableAdminClient.ListTablesPagedResponse response) {
                return (BaseBigtableTableAdminClient.ListTablesPage)response.getPage();
            }
        }, (Executor)MoreExecutors.directExecutor());
        ApiFuture allProtos = ApiFutures.transformAsync((ApiFuture)firstPageFuture, (ApiAsyncFunction)new ApiAsyncFunction<BaseBigtableTableAdminClient.ListTablesPage, List<com.google.bigtable.admin.v2.Table>>(){
            List<com.google.bigtable.admin.v2.Table> responseAccumulator = Lists.newArrayList();

            public ApiFuture<List<com.google.bigtable.admin.v2.Table>> apply(BaseBigtableTableAdminClient.ListTablesPage page) {
                this.responseAccumulator.addAll(Lists.newArrayList((Iterable)page.getValues()));
                if (!page.hasNextPage()) {
                    return ApiFutures.immediateFuture(this.responseAccumulator);
                }
                return ApiFutures.transformAsync((ApiFuture)page.getNextPageAsync(), (ApiAsyncFunction)this, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return ApiFutures.transform((ApiFuture)allProtos, (ApiFunction)new ApiFunction<List<com.google.bigtable.admin.v2.Table>, List<String>>(){

            public List<String> apply(List<com.google.bigtable.admin.v2.Table> protos) {
                ArrayList results = Lists.newArrayListWithCapacity((int)protos.size());
                for (com.google.bigtable.admin.v2.Table proto : protos) {
                    results.add(TableName.parse((String)proto.getName()).getTable());
                }
                return results;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void dropRowRange(String tableId, String rowKeyPrefix) {
        ApiExceptions.callAndTranslateApiException(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8((String)rowKeyPrefix));
    }

    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        ApiExceptions.callAndTranslateApiException(this.dropRowRangeAsync(tableId, rowKeyPrefix));
    }

    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId)).setRowKeyPrefix(rowKeyPrefix).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)request));
    }

    public void dropAllRows(String tableId) {
        ApiExceptions.callAndTranslateApiException(this.dropAllRowsAsync(tableId));
    }

    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        DropRowRangeRequest request = DropRowRangeRequest.newBuilder().setName(this.getTableName(tableId)).setDeleteAllDataFromTable(true).build();
        return BigtableTableAdminClient.transformToVoid((ApiFuture<Empty>)this.stub.dropRowRangeCallable().futureCall((Object)request));
    }

    public void awaitReplication(String tableId) {
        TableName tableName = TableName.of((String)this.instanceName.getProject(), (String)this.instanceName.getInstance(), (String)tableId);
        ApiExceptions.callAndTranslateApiException((ApiFuture)this.stub.awaitReplicationCallable().futureCall((Object)tableName));
    }

    public ApiFuture<Void> awaitReplicationAsync(String tableId) {
        TableName tableName = TableName.of((String)this.instanceName.getProject(), (String)this.instanceName.getInstance(), (String)tableId);
        return this.stub.awaitReplicationCallable().futureCall((Object)tableName);
    }

    private String getTableName(String tableId) {
        return TableName.of((String)this.instanceName.getProject(), (String)this.instanceName.getInstance(), (String)tableId).toString();
    }

    private static ApiFuture<Table> transformToTableResponse(ApiFuture<com.google.bigtable.admin.v2.Table> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<com.google.bigtable.admin.v2.Table, Table>(){

            public Table apply(com.google.bigtable.admin.v2.Table table) {
                return Table.fromProto(table);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static ApiFuture<Void> transformToVoid(ApiFuture<Empty> future) {
        return ApiFutures.transform(future, (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }
}

