/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.emulator.v2;

import com.google.api.core.BetaApi;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@BetaApi(value="Surface for Bigtable emulator is not yet stable")
public class Emulator {
    private static final Logger LOGGER = Logger.getLogger(Emulator.class.getName());
    private final Path executable;
    private Process process;
    private boolean isStopped = true;
    private Thread shutdownHook;
    private int port;
    private ManagedChannel dataChannel;
    private ManagedChannel adminChannel;

    public static Emulator createFromPath(Path path) {
        return new Emulator(path);
    }

    public static Emulator createBundled() throws IOException {
        String resourcePath = Emulator.getBundledResourcePath();
        File tmpEmulator = File.createTempFile("cbtemulator", "");
        tmpEmulator.deleteOnExit();
        try (InputStream is = Emulator.class.getResourceAsStream(resourcePath);
             FileOutputStream os = new FileOutputStream(tmpEmulator);){
            int length;
            if (is == null) {
                throw new FileNotFoundException("Failed to find the bundled emulator binary: " + resourcePath);
            }
            byte[] buff = new byte[2048];
            while ((length = is.read(buff)) != -1) {
                os.write(buff, 0, length);
            }
        }
        tmpEmulator.setExecutable(true);
        return new Emulator(tmpEmulator.toPath());
    }

    private Emulator(Path executable) {
        this.executable = executable;
    }

    public synchronized void start() throws IOException, TimeoutException, InterruptedException {
        if (!this.isStopped) {
            throw new IllegalStateException("Emulator is already started");
        }
        this.port = Emulator.getAvailablePort();
        Optional<Object> localhostAddress = Optional.empty();
        try {
            localhostAddress = Optional.of(InetAddress.getByName(null).getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int attemptsLeft = 3;
        while (this.process == null) {
            try {
                String cmd = this.executable.toString();
                if (localhostAddress.isPresent()) {
                    cmd = cmd + String.format(" -host [%s]", localhostAddress.get());
                }
                cmd = cmd + String.format(" -port %d", this.port);
                this.process = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                if (attemptsLeft > 0) {
                    Thread.sleep(1000L);
                }
                throw e;
            }
            --attemptsLeft;
        }
        Emulator.pipeStreamToLog(this.process.getInputStream(), Level.INFO);
        Emulator.pipeStreamToLog(this.process.getErrorStream(), Level.WARNING);
        this.isStopped = false;
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                if (!Emulator.this.isStopped) {
                    Emulator.this.isStopped = true;
                    Emulator.this.process.destroy();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Emulator.waitForPort(this.port);
    }

    public synchronized void stop() {
        if (this.isStopped) {
            throw new IllegalStateException("Emulator already stopped");
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
            if (this.dataChannel != null) {
                this.dataChannel.shutdownNow();
            }
            if (this.adminChannel != null) {
                this.adminChannel.shutdownNow();
            }
            if (this.dataChannel != null) {
                this.dataChannel.awaitTermination(1L, TimeUnit.MINUTES);
                this.dataChannel = null;
            }
            if (this.adminChannel != null) {
                this.adminChannel.awaitTermination(1L, TimeUnit.MINUTES);
                this.adminChannel = null;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Interrupted while waiting for client channels to close");
            Thread.currentThread().interrupt();
        }
        finally {
            this.isStopped = true;
            this.process.destroy();
        }
    }

    public synchronized int getPort() {
        if (this.isStopped) {
            throw new IllegalStateException("Emulator is not running");
        }
        return this.port;
    }

    public synchronized ManagedChannel getDataChannel() {
        if (this.isStopped) {
            throw new IllegalStateException("Emulator is not running");
        }
        if (this.dataChannel == null) {
            this.dataChannel = Emulator.newChannelBuilder(this.port).maxInboundMessageSize(0x10000000).keepAliveTimeout(10L, TimeUnit.SECONDS).keepAliveTime(10L, TimeUnit.SECONDS).keepAliveWithoutCalls(true).build();
        }
        return this.dataChannel;
    }

    public synchronized ManagedChannel getAdminChannel() {
        if (this.isStopped) {
            throw new IllegalStateException("Emulator is not running");
        }
        if (this.adminChannel == null) {
            this.adminChannel = Emulator.newChannelBuilder(this.port).build();
        }
        return this.adminChannel;
    }

    private static String getBundledResourcePath() {
        String arch;
        String unformattedArch;
        String os;
        String unformattedOs = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        String suffix = "";
        if (unformattedOs.contains("mac") || unformattedOs.contains("darwin")) {
            os = "darwin";
        } else if (unformattedOs.contains("win")) {
            os = "windows";
            suffix = ".exe";
        } else if (unformattedOs.contains("linux")) {
            os = "linux";
        } else {
            throw new UnsupportedOperationException("Emulator is not supported on your platform: " + unformattedOs);
        }
        switch (unformattedArch = System.getProperty("os.arch")) {
            case "x86": {
                arch = "x86";
                break;
            }
            case "x86_64": 
            case "amd64": {
                arch = "x86_64";
                break;
            }
            case "aarch64": {
                arch = "arm";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported architecture: " + unformattedArch);
            }
        }
        return String.format("/gcloud/bigtable-%s-%s/platform/bigtable-emulator/cbtemulator%s", os, arch, suffix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getAvailablePort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find open port");
        }
    }

    private static void waitForPort(int port) throws InterruptedException, TimeoutException {
        for (int i = 0; i < 100; ++i) {
            try {
                Socket ignored = new Socket("localhost", port);
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignored.close();
                    }
                }
                return;
            }
            catch (IOException e) {
                Thread.sleep(200L);
                continue;
            }
        }
        throw new TimeoutException("Timed out waiting for server to start");
    }

    private static ManagedChannelBuilder<?> newChannelBuilder(int port) {
        return ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext();
    }

    private static void pipeStreamToLog(InputStream stream, final Level level) {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            LOGGER.log(level, line);
                        }
                    }
                    catch (IOException e) {
                        if ("Stream closed".equals(e.getMessage())) break block3;
                        LOGGER.log(Level.WARNING, "Failed to read process stream", e);
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }
}

