/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.MonitoredResource;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.IntervalMetricReader;
import com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricReader;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.Metrics;
import com.google.cloud.bigtable.stats.BigtableCreateTimeSeriesExporter;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;

@InternalApi
public class BigtableStackdriverStatsExporter {
    static final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private static BigtableStackdriverStatsExporter instance = null;
    private static final com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration EXPORT_INTERVAL = com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration.create(60L, 0);
    private static final String RESOURCE_TYPE = "bigtable_client_raw";
    private final IntervalMetricReader intervalMetricReader;

    private BigtableStackdriverStatsExporter(MetricServiceClient metricServiceClient, com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration exportInterval, MonitoredResource monitoredResource) {
        IntervalMetricReader.Options.Builder intervalMetricReaderOptionsBuilder = IntervalMetricReader.Options.builder();
        intervalMetricReaderOptionsBuilder.setExportInterval(exportInterval);
        this.intervalMetricReader = IntervalMetricReader.create(new BigtableCreateTimeSeriesExporter(metricServiceClient, monitoredResource), MetricReader.create(MetricReader.Options.builder().setMetricProducerManager(Metrics.getExportComponent().getMetricProducerManager()).build()), intervalMetricReaderOptionsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Credentials credentials) throws IOException {
        Object object = lock;
        synchronized (object) {
            Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Bigtable Stackdriver stats exporter is already created");
            MetricServiceClient client = BigtableStackdriverStatsExporter.createMetricServiceClient(credentials, com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration.create(60L, 0));
            MonitoredResource resourceType = MonitoredResource.newBuilder().setType(RESOURCE_TYPE).build();
            instance = new BigtableStackdriverStatsExporter(client, EXPORT_INTERVAL, resourceType);
        }
    }

    @GuardedBy(value="lock")
    @VisibleForTesting
    static MetricServiceClient createMetricServiceClient(Credentials credentials, com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration deadline) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().build());
        settingsBuilder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials));
        Duration stackdriverDuration = Duration.ofMillis((long)deadline.toMillis());
        settingsBuilder.createTimeSeriesSettings().setSimpleTimeoutNoRetries(stackdriverDuration);
        return MetricServiceClient.create((MetricServiceSettings)settingsBuilder.build());
    }
}

