/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.TableName;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class ConditionalRowMutation
implements Serializable {
    private static final long serialVersionUID = -3699904745621909502L;
    private final String tableId;
    private transient CheckAndMutateRowRequest.Builder builder = CheckAndMutateRowRequest.newBuilder();

    private ConditionalRowMutation(String tableId, ByteString rowKey) {
        this.tableId = tableId;
        this.builder.setRowKey(rowKey);
    }

    public static ConditionalRowMutation create(String tableId, String rowKey) {
        return ConditionalRowMutation.create(tableId, ByteString.copyFromUtf8((String)rowKey));
    }

    public static ConditionalRowMutation create(String tableId, ByteString rowKey) {
        Validations.validateTableId(tableId);
        return new ConditionalRowMutation(tableId, rowKey);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (CheckAndMutateRowRequest.Builder)CheckAndMutateRowRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public ConditionalRowMutation condition(@Nonnull Filters.Filter condition) {
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkState((!this.builder.hasPredicateFilter() ? 1 : 0) != 0, (Object)"Can only have a single condition, please use a Filters#chain or Filters#interleave filter instead");
        this.builder.setPredicateFilter(condition.toProto());
        return this;
    }

    public ConditionalRowMutation then(@Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)mutation);
        this.builder.addAllTrueMutations(mutation.getMutations());
        return this;
    }

    public ConditionalRowMutation otherwise(@Nonnull Mutation mutation) {
        Preconditions.checkNotNull((Object)mutation);
        this.builder.addAllFalseMutations(mutation.getMutations());
        return this;
    }

    @InternalApi
    public CheckAndMutateRowRequest toProto(RequestContext requestContext) {
        Preconditions.checkState((!this.builder.getTrueMutationsList().isEmpty() || !this.builder.getFalseMutationsList().isEmpty() ? 1 : 0) != 0, (Object)"ConditionalRowMutations must have `then` or `otherwise` mutations.");
        TableName tableName = TableName.of((String)requestContext.getInstanceName().getProject(), (String)requestContext.getInstanceName().getInstance(), (String)this.tableId);
        return this.builder.setTableName(tableName.toString()).setAppProfileId(requestContext.getAppProfileId()).build();
    }
}

