/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.v2.TableName;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;

class SampleRowKeysCallable
extends UnaryCallable<String, List<KeyOffset>> {
    private final RequestContext requestContext;
    private final UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> inner;

    SampleRowKeysCallable(UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> inner, RequestContext requestContext) {
        this.requestContext = requestContext;
        this.inner = inner;
    }

    public ApiFuture<List<KeyOffset>> futureCall(String tableId, ApiCallContext context) {
        TableName tableName = TableName.of((String)this.requestContext.getInstanceName().getProject(), (String)this.requestContext.getInstanceName().getInstance(), (String)tableId);
        SampleRowKeysRequest request = SampleRowKeysRequest.newBuilder().setTableName(tableName.toString()).setAppProfileId(this.requestContext.getAppProfileId()).build();
        ApiFuture rawResponse = this.inner.futureCall((Object)request, context);
        return ApiFutures.transform((ApiFuture)rawResponse, (ApiFunction)new ApiFunction<List<SampleRowKeysResponse>, List<KeyOffset>>(){

            public List<KeyOffset> apply(List<SampleRowKeysResponse> rawResponse) {
                return SampleRowKeysCallable.convert(rawResponse);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static List<KeyOffset> convert(List<SampleRowKeysResponse> rawResponse) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (SampleRowKeysResponse element : rawResponse) {
            results.add((Object)KeyOffset.create(element.getRowKey(), element.getOffsetBytes()));
        }
        return results.build();
    }
}

