/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BigtableInstanceAdminSettings {
    private final String projectId;
    private final BigtableInstanceAdminStubSettings stubSettings;

    private BigtableInstanceAdminSettings(Builder builder) throws IOException {
        Preconditions.checkNotNull((Object)builder.projectId, (Object)"Project ID must be set");
        Verify.verifyNotNull((Object)((Object)builder.stubSettings), (String)"stubSettings should never be null", (Object[])new Object[0]);
        this.projectId = builder.projectId;
        this.stubSettings = builder.stubSettings.build();
    }

    @Nonnull
    public String getProjectId() {
        return this.projectId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.stubSettings.getCredentialsProvider();
    }

    @Nonnull
    public BigtableInstanceAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        Preconditions.checkState((System.getenv("BIGTABLE_EMULATOR_HOST") == null ? 1 : 0) != 0, (Object)"BigtableInstanceAdminSettings doesn't supported on Emulator");
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        private final BigtableInstanceAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableInstanceAdminStubSettings.newBuilder();
        }

        private Builder(BigtableInstanceAdminSettings settings) {
            this.projectId = settings.projectId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        public BigtableInstanceAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableInstanceAdminSettings build() throws IOException {
            return new BigtableInstanceAdminSettings(this);
        }
    }
}

