/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.opencensus.tags.TagValue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

class Util {
    private static final TagValue OK_STATUS = TagValue.create((String)StatusCode.Code.OK.toString());

    Util() {
    }

    static TagValue extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return OK_STATUS;
        }
        String statusString = error instanceof CancellationException ? Status.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus().getCode().toString() : (error instanceof StatusException ? ((StatusException)error).getStatus().getCode().toString() : StatusCode.Code.UNKNOWN.toString())));
        return TagValue.create((String)statusString);
    }

    static TagValue extractStatus(Future<?> future) {
        Throwable error = null;
        try {
            future.get();
        }
        catch (InterruptedException e) {
            error = e;
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        catch (RuntimeException e) {
            error = e;
        }
        return Util.extractStatus(error);
    }
}

