/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class DynamicFlowControlStats {
    private static final double DEFAULT_DECAY_CONSTANT = 0.015;
    private AtomicLong lastAdjustedTimestampMs = new AtomicLong(0L);
    private DecayingAverage meanLatency;

    DynamicFlowControlStats() {
        this(0.015);
    }

    DynamicFlowControlStats(double decayConstant) {
        this.meanLatency = new DecayingAverage(decayConstant);
    }

    void updateLatency(long latency) {
        this.updateLatency(latency, System.currentTimeMillis());
    }

    @VisibleForTesting
    void updateLatency(long latency, long timestampMs) {
        this.meanLatency.update(latency, timestampMs);
    }

    double getMeanLatency() {
        return this.getMeanLatency(System.currentTimeMillis());
    }

    @VisibleForTesting
    double getMeanLatency(long timestampMs) {
        return this.meanLatency.getMean(timestampMs);
    }

    public long getLastAdjustedTimestampMs() {
        return this.lastAdjustedTimestampMs.get();
    }

    boolean setLastAdjustedTimestampMs(long last, long now) {
        return this.lastAdjustedTimestampMs.compareAndSet(last, now);
    }

    private class DecayingAverage {
        private double decayConstant;
        private double mean;
        private double weightedCount;
        private AtomicLong lastUpdateTimeInSecond;

        DecayingAverage(double decayConstant) {
            this.decayConstant = decayConstant;
            this.mean = 0.0;
            this.weightedCount = 0.0;
            this.lastUpdateTimeInSecond = new AtomicLong(0L);
        }

        synchronized void update(long value, long timestampMs) {
            long now = TimeUnit.MILLISECONDS.toSeconds(timestampMs);
            Preconditions.checkArgument((now >= this.lastUpdateTimeInSecond.get() ? 1 : 0) != 0, (Object)"can't update an event in the past");
            if (this.lastUpdateTimeInSecond.get() == 0L) {
                this.lastUpdateTimeInSecond.set(now);
                this.mean = value;
                this.weightedCount = 1.0;
            } else {
                long prev = this.lastUpdateTimeInSecond.getAndSet(now);
                long elapsed = now - prev;
                double alpha = this.getAlpha(elapsed);
                this.mean = this.mean * (this.weightedCount * alpha / (this.weightedCount * alpha + 1.0)) + (double)value / (this.weightedCount * alpha + 1.0);
                this.weightedCount = this.weightedCount * alpha + 1.0;
            }
        }

        double getMean(long timestampMs) {
            long timestampSecs = TimeUnit.MILLISECONDS.toSeconds(timestampMs);
            long elapsed = timestampSecs - this.lastUpdateTimeInSecond.get();
            return this.mean * this.getAlpha(Math.max(0L, elapsed));
        }

        private double getAlpha(long elapsedSecond) {
            return Math.exp(-this.decayConstant * (double)elapsedSecond);
        }
    }
}

