/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.BetaApi;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViewConstants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.opencensus.stats.Stats;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewManager;

@BetaApi
public class RpcViews {
    @VisibleForTesting
    private static final ImmutableSet<View> BIGTABLE_CLIENT_VIEWS_SET = ImmutableSet.of((Object)RpcViewConstants.BIGTABLE_OP_LATENCY_VIEW, (Object)RpcViewConstants.BIGTABLE_COMPLETED_OP_VIEW, (Object)RpcViewConstants.BIGTABLE_READ_ROWS_FIRST_ROW_LATENCY_VIEW, (Object)RpcViewConstants.BIGTABLE_ATTEMPT_LATENCY_VIEW, (Object)RpcViewConstants.BIGTABLE_ATTEMPTS_PER_OP_VIEW);
    private static final ImmutableSet<View> GFE_VIEW_SET = ImmutableSet.of((Object)RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (Object)RpcViewConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT_VIEW);
    private static boolean gfeMetricsRegistered = false;

    public static void registerBigtableClientViews() {
        RpcViews.registerBigtableClientViews(Stats.getViewManager());
    }

    public static void registerBigtableClientGfeViews() {
        RpcViews.registerBigtableClientGfeViews(Stats.getViewManager());
    }

    @VisibleForTesting
    static void registerBigtableClientViews(ViewManager viewManager) {
        for (View view : BIGTABLE_CLIENT_VIEWS_SET) {
            viewManager.registerView(view);
        }
    }

    @VisibleForTesting
    static void registerBigtableClientGfeViews(ViewManager viewManager) {
        for (View view : GFE_VIEW_SET) {
            viewManager.registerView(view);
        }
        gfeMetricsRegistered = true;
    }

    static boolean isGfeMetricsRegistered() {
        return gfeMetricsRegistered;
    }

    @VisibleForTesting
    static void setGfeMetricsRegistered(boolean gfeMetricsRegistered) {
        RpcViews.gfeMetricsRegistered = gfeMetricsRegistered;
    }
}

