/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@InternalApi
public class MeasuredUnaryCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> innerCallable;
    private final TagValue methodName;
    private final TagContext parentCtx;
    private final Tagger tagger;
    private final StatsRecorder stats;
    private final ApiClock clock;

    public MeasuredUnaryCallable(@Nonnull UnaryCallable<RequestT, ResponseT> innerCallable, @Nonnull String methodName, @Nonnull Tagger tagger, @Nonnull StatsRecorder stats, @Nonnull ApiClock clock) {
        this.innerCallable = (UnaryCallable)Preconditions.checkNotNull(innerCallable, (Object)"innerCallable");
        this.methodName = TagValue.create((String)((String)Preconditions.checkNotNull((Object)methodName, (Object)"methodName")));
        this.tagger = (Tagger)Preconditions.checkNotNull((Object)tagger, (Object)"tagger");
        this.parentCtx = tagger.getCurrentTagContext();
        this.stats = (StatsRecorder)Preconditions.checkNotNull((Object)stats, (Object)"stats");
        this.clock = (ApiClock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext context) {
        long startTime = this.clock.nanoTime();
        ApiFuture future = this.innerCallable.futureCall(request, context);
        future.addListener((Runnable)new StatsRecordingRunnable((Future)future, startTime), MoreExecutors.directExecutor());
        return future;
    }

    private class StatsRecordingRunnable
    implements Runnable {
        private final Future<?> operationFuture;
        private final long operationStart;

        private StatsRecordingRunnable(Future<?> operationFuture, long startTime) {
            this.operationFuture = (Future)Preconditions.checkNotNull(operationFuture, (Object)"operationFuture");
            this.operationStart = startTime;
        }

        @Override
        public void run() {
            long elapsed = TimeUnit.NANOSECONDS.toMillis(MeasuredUnaryCallable.this.clock.nanoTime() - this.operationStart);
            MeasuredUnaryCallable.this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_OP_LATENCY, (double)elapsed).record(MeasuredUnaryCallable.this.tagger.toBuilder(MeasuredUnaryCallable.this.parentCtx).putLocal(RpcMeasureConstants.BIGTABLE_OP, MeasuredUnaryCallable.this.methodName).putLocal(RpcMeasureConstants.BIGTABLE_STATUS, Util.extractStatus(this.operationFuture)).build());
        }
    }
}

