/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.BaseApiTracer;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Stopwatch;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

class MetricsTracer
extends BaseApiTracer {
    private final ApiTracerFactory.OperationType operationType;
    private final Tagger tagger;
    private final StatsRecorder stats;
    private final TagContext parentContext;
    private final SpanName spanName;
    private final Map<TagKey, TagValue> statsAttributes;
    private final AtomicBoolean opFinished = new AtomicBoolean();
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Stopwatch firstResponsePerOpTimer = Stopwatch.createStarted();
    private long operationResponseCount = 0L;
    private int attemptCount = 0;
    private Stopwatch attemptTimer;
    private long attemptResponseCount = 0L;

    MetricsTracer(ApiTracerFactory.OperationType operationType, Tagger tagger, StatsRecorder stats, SpanName spanName, Map<TagKey, TagValue> statsAttributes) {
        this.operationType = operationType;
        this.tagger = tagger;
        this.stats = stats;
        this.parentContext = tagger.getCurrentTagContext();
        this.spanName = spanName;
        this.statsAttributes = statsAttributes;
    }

    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            public void close() {
            }
        };
    }

    public void operationSucceeded() {
        this.recordOperationCompletion(null);
    }

    public void operationCancelled() {
        this.recordOperationCompletion(new CancellationException());
    }

    public void operationFailed(Throwable throwable) {
        this.recordOperationCompletion(throwable);
    }

    private void recordOperationCompletion(@Nullable Throwable throwable) {
        if (!this.opFinished.compareAndSet(false, true)) {
            return;
        }
        this.operationTimer.stop();
        long elapsed = this.operationTimer.elapsed(TimeUnit.MILLISECONDS);
        MeasureMap measures = this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_OP_LATENCY, elapsed).put(RpcMeasureConstants.BIGTABLE_OP_ATTEMPT_COUNT, (long)this.attemptCount);
        if (this.operationType == ApiTracerFactory.OperationType.ServerStreaming && this.spanName.getMethodName().equals("ReadRows")) {
            measures.put(RpcMeasureConstants.BIGTABLE_READ_ROWS_FIRST_ROW_LATENCY, this.firstResponsePerOpTimer.elapsed(TimeUnit.MILLISECONDS));
        }
        TagContextBuilder tagCtx = this.newTagCtxBuilder().putLocal(RpcMeasureConstants.BIGTABLE_STATUS, Util.extractStatus(throwable));
        measures.record(tagCtx.build());
    }

    public void connectionSelected(String s) {
    }

    public void attemptStarted(int i) {
        ++this.attemptCount;
        this.attemptTimer = Stopwatch.createStarted();
        this.attemptResponseCount = 0L;
    }

    public void attemptSucceeded() {
        this.recordAttemptCompletion(null);
    }

    public void attemptCancelled() {
        this.recordAttemptCompletion(new CancellationException());
    }

    public void attemptFailed(Throwable throwable, Duration duration) {
        this.recordAttemptCompletion(throwable);
    }

    public void attemptFailedRetriesExhausted(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    public void attemptPermanentFailure(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    private void recordAttemptCompletion(@Nullable Throwable throwable) {
        MeasureMap measures = this.stats.newMeasureMap().put(RpcMeasureConstants.BIGTABLE_ATTEMPT_LATENCY, this.attemptTimer.elapsed(TimeUnit.MILLISECONDS));
        TagContextBuilder tagCtx = this.newTagCtxBuilder().putLocal(RpcMeasureConstants.BIGTABLE_STATUS, Util.extractStatus(throwable));
        measures.record(tagCtx.build());
    }

    public void lroStartFailed(Throwable throwable) {
    }

    public void lroStartSucceeded() {
    }

    public void responseReceived() {
        if (this.firstResponsePerOpTimer.isRunning()) {
            this.firstResponsePerOpTimer.stop();
        }
        ++this.attemptResponseCount;
        ++this.operationResponseCount;
    }

    public void requestSent() {
    }

    public void batchRequestSent(long elementCount, long requestSize) {
    }

    private TagContextBuilder newTagCtxBuilder() {
        TagContextBuilder tagCtx = this.tagger.toBuilder(this.parentContext).putLocal(RpcMeasureConstants.BIGTABLE_OP, TagValue.create((String)this.spanName.toString()));
        for (Map.Entry<TagKey, TagValue> entry : this.statsAttributes.entrySet()) {
            tagCtx.putLocal(entry.getKey(), entry.getValue());
        }
        return tagCtx;
    }
}

