/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.cloud.bigtable.stats.StatsRecorderWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.math.IntMath;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

class BuiltinMetricsTracer
extends BigtableTracer {
    private final StatsRecorderWrapper recorder;
    private final ApiTracerFactory.OperationType operationType;
    private final SpanName spanName;
    private final AtomicBoolean opFinished = new AtomicBoolean();
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Stopwatch firstResponsePerOpTimer = Stopwatch.createStarted();
    private int attemptCount = 0;
    private Stopwatch attemptTimer;
    private volatile int attempt = 0;
    private final AtomicLong totalServerLatencyNano = new AtomicLong(0L);
    private final Stopwatch serverLatencyTimer = Stopwatch.createUnstarted();
    private boolean serverLatencyTimerIsRunning = false;
    private final Object timerLock = new Object();
    private boolean flowControlIsDisabled = false;
    private AtomicInteger requestLeft = new AtomicInteger(0);
    private String tableId = "unspecified";
    private String zone = "global";
    private String cluster = "unspecified";

    @VisibleForTesting
    BuiltinMetricsTracer(ApiTracerFactory.OperationType operationType, SpanName spanName, StatsRecorderWrapper recorder) {
        this.operationType = operationType;
        this.spanName = spanName;
        this.recorder = recorder;
    }

    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            public void close() {
            }
        };
    }

    public void operationSucceeded() {
        this.recordOperationCompletion(null);
    }

    public void operationCancelled() {
        this.recordOperationCompletion(new CancellationException());
    }

    public void operationFailed(Throwable error) {
        this.recordOperationCompletion(error);
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.attemptStarted(null, attemptNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptStarted(Object request, int attemptNumber) {
        this.attempt = attemptNumber;
        ++this.attemptCount;
        this.attemptTimer = Stopwatch.createStarted();
        if (request != null) {
            this.tableId = Util.extractTableId(request);
        }
        if (!this.flowControlIsDisabled) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimerIsRunning) {
                    this.serverLatencyTimer.start();
                    this.serverLatencyTimerIsRunning = true;
                }
            }
        }
    }

    public void attemptSucceeded() {
        this.recordAttemptCompletion(null);
    }

    public void attemptCancelled() {
        this.recordAttemptCompletion(new CancellationException());
    }

    public void attemptFailed(Throwable error, Duration delay) {
        this.recordAttemptCompletion(error);
    }

    public void attemptPermanentFailure(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(int requestCount) {
        this.requestLeft.accumulateAndGet(requestCount, IntMath::saturatedAdd);
        if (this.flowControlIsDisabled) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimerIsRunning) {
                    this.serverLatencyTimer.start();
                    this.serverLatencyTimerIsRunning = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.serverLatencyTimerIsRunning) {
                this.totalServerLatencyNano.addAndGet(this.serverLatencyTimer.elapsed(TimeUnit.NANOSECONDS));
                this.serverLatencyTimer.reset();
                this.serverLatencyTimerIsRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterResponse(long applicationLatency) {
        if (!this.flowControlIsDisabled || this.requestLeft.decrementAndGet() > 0) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimerIsRunning) {
                    this.serverLatencyTimer.start();
                    this.serverLatencyTimerIsRunning = true;
                }
            }
        }
    }

    @Override
    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public void recordGfeMetadata(@Nullable Long latency, @Nullable Throwable throwable) {
        if (latency != null) {
            this.recorder.putGfeLatencies(latency.longValue());
            this.recorder.putGfeMissingHeaders(0L);
        } else {
            this.recorder.putGfeMissingHeaders(1L);
        }
    }

    @Override
    public void setLocations(String zone, String cluster) {
        this.zone = zone;
        this.cluster = cluster;
    }

    @Override
    public void batchRequestThrottled(long throttledTimeMs) {
        this.recorder.putBatchRequestThrottled(throttledTimeMs);
    }

    @Override
    public void disableFlowControl() {
        this.flowControlIsDisabled = true;
    }

    private void recordOperationCompletion(@Nullable Throwable status) {
        if (!this.opFinished.compareAndSet(false, true)) {
            return;
        }
        this.operationTimer.stop();
        long operationLatency = this.operationTimer.elapsed(TimeUnit.MILLISECONDS);
        long operationLatencyNano = this.operationTimer.elapsed(TimeUnit.NANOSECONDS);
        if (this.attemptCount > 1) {
            this.recorder.putRetryCount(this.attemptCount - 1);
        }
        this.recorder.putOperationLatencies(operationLatency);
        this.recorder.putApplicationLatencies(Duration.ofNanos((long)(operationLatencyNano - this.totalServerLatencyNano.get())).toMillis());
        if (this.operationType == ApiTracerFactory.OperationType.ServerStreaming && this.spanName.getMethodName().equals("ReadRows")) {
            this.recorder.putFirstResponseLatencies(this.firstResponsePerOpTimer.elapsed(TimeUnit.MILLISECONDS));
        }
        this.recorder.recordOperation(Util.extractStatus(status), this.tableId, this.zone, this.cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAttemptCompletion(@Nullable Throwable status) {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.serverLatencyTimerIsRunning) {
                this.requestLeft.decrementAndGet();
                this.totalServerLatencyNano.addAndGet(this.serverLatencyTimer.elapsed(TimeUnit.NANOSECONDS));
                this.serverLatencyTimer.reset();
                this.serverLatencyTimerIsRunning = false;
            }
        }
        if (status instanceof ServerStreamingAttemptException) {
            status = status.getCause();
        }
        this.recorder.putAttemptLatencies(this.attemptTimer.elapsed(TimeUnit.MILLISECONDS));
        this.recorder.recordAttempt(Util.extractStatus(status), this.tableId, this.zone, this.cluster);
    }
}

