/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.ChangeStreamConfig;
import com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

public final class CreateTableRequest {
    private final CreateTableRequest.Builder requestBuilder = com.google.bigtable.admin.v2.CreateTableRequest.newBuilder();

    public static CreateTableRequest of(String tableId) {
        return new CreateTableRequest(tableId);
    }

    private CreateTableRequest(String tableId) {
        this.requestBuilder.setTableId(tableId);
    }

    public CreateTableRequest addFamily(String familyId) {
        Preconditions.checkNotNull((Object)familyId);
        this.requestBuilder.getTableBuilder().putColumnFamilies(familyId, ColumnFamily.getDefaultInstance());
        return this;
    }

    public CreateTableRequest addFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull((Object)familyId);
        this.requestBuilder.getTableBuilder().putColumnFamilies(familyId, ColumnFamily.newBuilder().setGcRule(gcRule.toProto()).build());
        return this;
    }

    public CreateTableRequest addSplit(ByteString key) {
        Preconditions.checkNotNull((Object)key);
        this.requestBuilder.addInitialSplitsBuilder().setKey(key);
        return this;
    }

    public CreateTableRequest addChangeStreamRetention(Duration retention) {
        Preconditions.checkNotNull((Object)retention);
        this.requestBuilder.getTableBuilder().setChangeStreamConfig(ChangeStreamConfig.newBuilder().setRetentionPeriod(com.google.protobuf.Duration.newBuilder().setSeconds(retention.getSeconds()).setNanos(retention.getNano()).build()).build());
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableRequest that = (CreateTableRequest)o;
        return Objects.equal((Object)this.requestBuilder.build(), (Object)that.requestBuilder.build());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.build()});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)instanceId);
        return this.requestBuilder.setParent(NameUtil.formatInstanceName(projectId, instanceId)).build();
    }
}

