package com.google.cloud.bigtable.data.v2.models;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ChangeStreamMutation extends ChangeStreamMutation {

  private final ByteString rowKey;

  private final ChangeStreamMutation.MutationType type;

  private final String sourceClusterId;

  private final Instant commitTimestamp;

  private final int tieBreaker;

  private final String token;

  private final Instant estimatedLowWatermark;

  private final ImmutableList<Entry> entries;

  private AutoValue_ChangeStreamMutation(
      ByteString rowKey,
      ChangeStreamMutation.MutationType type,
      String sourceClusterId,
      Instant commitTimestamp,
      int tieBreaker,
      String token,
      Instant estimatedLowWatermark,
      ImmutableList<Entry> entries) {
    this.rowKey = rowKey;
    this.type = type;
    this.sourceClusterId = sourceClusterId;
    this.commitTimestamp = commitTimestamp;
    this.tieBreaker = tieBreaker;
    this.token = token;
    this.estimatedLowWatermark = estimatedLowWatermark;
    this.entries = entries;
  }

  @Nonnull
  @Override
  public ByteString getRowKey() {
    return rowKey;
  }

  @Nonnull
  @Override
  public ChangeStreamMutation.MutationType getType() {
    return type;
  }

  @Nonnull
  @Override
  public String getSourceClusterId() {
    return sourceClusterId;
  }

  @Override
  public Instant getCommitTimestamp() {
    return commitTimestamp;
  }

  @Override
  public int getTieBreaker() {
    return tieBreaker;
  }

  @Nonnull
  @Override
  public String getToken() {
    return token;
  }

  @Override
  public Instant getEstimatedLowWatermark() {
    return estimatedLowWatermark;
  }

  @Nonnull
  @Override
  public ImmutableList<Entry> getEntries() {
    return entries;
  }

  @Override
  public String toString() {
    return "ChangeStreamMutation{"
        + "rowKey=" + rowKey + ", "
        + "type=" + type + ", "
        + "sourceClusterId=" + sourceClusterId + ", "
        + "commitTimestamp=" + commitTimestamp + ", "
        + "tieBreaker=" + tieBreaker + ", "
        + "token=" + token + ", "
        + "estimatedLowWatermark=" + estimatedLowWatermark + ", "
        + "entries=" + entries
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChangeStreamMutation) {
      ChangeStreamMutation that = (ChangeStreamMutation) o;
      return this.rowKey.equals(that.getRowKey())
          && this.type.equals(that.getType())
          && this.sourceClusterId.equals(that.getSourceClusterId())
          && this.commitTimestamp.equals(that.getCommitTimestamp())
          && this.tieBreaker == that.getTieBreaker()
          && this.token.equals(that.getToken())
          && this.estimatedLowWatermark.equals(that.getEstimatedLowWatermark())
          && this.entries.equals(that.getEntries());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= rowKey.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= sourceClusterId.hashCode();
    h$ *= 1000003;
    h$ ^= commitTimestamp.hashCode();
    h$ *= 1000003;
    h$ ^= tieBreaker;
    h$ *= 1000003;
    h$ ^= token.hashCode();
    h$ *= 1000003;
    h$ ^= estimatedLowWatermark.hashCode();
    h$ *= 1000003;
    h$ ^= entries.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 8419520253162024218L;

  static final class Builder extends ChangeStreamMutation.Builder {
    private ByteString rowKey;
    private ChangeStreamMutation.MutationType type;
    private String sourceClusterId;
    private Instant commitTimestamp;
    private int tieBreaker;
    private String token;
    private Instant estimatedLowWatermark;
    private ImmutableList.Builder<Entry> entriesBuilder$;
    private ImmutableList<Entry> entries;
    private byte set$0;
    Builder() {
    }
    @Override
    ChangeStreamMutation.Builder setRowKey(ByteString rowKey) {
      if (rowKey == null) {
        throw new NullPointerException("Null rowKey");
      }
      this.rowKey = rowKey;
      return this;
    }
    @Override
    ChangeStreamMutation.Builder setType(ChangeStreamMutation.MutationType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    ChangeStreamMutation.Builder setSourceClusterId(String sourceClusterId) {
      if (sourceClusterId == null) {
        throw new NullPointerException("Null sourceClusterId");
      }
      this.sourceClusterId = sourceClusterId;
      return this;
    }
    @Override
    ChangeStreamMutation.Builder setCommitTimestamp(Instant commitTimestamp) {
      if (commitTimestamp == null) {
        throw new NullPointerException("Null commitTimestamp");
      }
      this.commitTimestamp = commitTimestamp;
      return this;
    }
    @Override
    ChangeStreamMutation.Builder setTieBreaker(int tieBreaker) {
      this.tieBreaker = tieBreaker;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    ChangeStreamMutation.Builder setToken(String token) {
      if (token == null) {
        throw new NullPointerException("Null token");
      }
      this.token = token;
      return this;
    }
    @Override
    ChangeStreamMutation.Builder setEstimatedLowWatermark(Instant estimatedLowWatermark) {
      if (estimatedLowWatermark == null) {
        throw new NullPointerException("Null estimatedLowWatermark");
      }
      this.estimatedLowWatermark = estimatedLowWatermark;
      return this;
    }
    @Override
    ImmutableList.Builder<Entry> entriesBuilder() {
      if (entriesBuilder$ == null) {
        entriesBuilder$ = ImmutableList.builder();
      }
      return entriesBuilder$;
    }
    @Override
    ChangeStreamMutation build() {
      if (entriesBuilder$ != null) {
        this.entries = entriesBuilder$.build();
      } else if (this.entries == null) {
        this.entries = ImmutableList.of();
      }
      if (set$0 != 1
          || this.rowKey == null
          || this.type == null
          || this.sourceClusterId == null
          || this.commitTimestamp == null
          || this.token == null
          || this.estimatedLowWatermark == null) {
        StringBuilder missing = new StringBuilder();
        if (this.rowKey == null) {
          missing.append(" rowKey");
        }
        if (this.type == null) {
          missing.append(" type");
        }
        if (this.sourceClusterId == null) {
          missing.append(" sourceClusterId");
        }
        if (this.commitTimestamp == null) {
          missing.append(" commitTimestamp");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" tieBreaker");
        }
        if (this.token == null) {
          missing.append(" token");
        }
        if (this.estimatedLowWatermark == null) {
          missing.append(" estimatedLowWatermark");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ChangeStreamMutation(
          this.rowKey,
          this.type,
          this.sourceClusterId,
          this.commitTimestamp,
          this.tieBreaker,
          this.token,
          this.estimatedLowWatermark,
          this.entries);
    }
  }

}
