/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.admin.v2.CopyBackupMetadata;
import com.google.bigtable.admin.v2.CopyBackupRequest;
import com.google.bigtable.admin.v2.CreateBackupMetadata;
import com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotMetadata;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotTableMetadata;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.admin.v2.Table;
import com.google.bigtable.admin.v2.UndeleteTableMetadata;
import com.google.bigtable.admin.v2.UndeleteTableRequest;
import com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.admin.v2.UpdateTableMetadata;
import com.google.bigtable.admin.v2.UpdateTableRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableTableAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class BigtableTableAdminStubSettings
extends StubSettings<BigtableTableAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigtable.admin").add((Object)"https://www.googleapis.com/auth/bigtable.admin.table").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin.table").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateTableRequest, Table> createTableSettings;
    private final UnaryCallSettings<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings;
    private final OperationCallSettings<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings;
    private final PagedCallSettings<ListTablesRequest, ListTablesResponse, BaseBigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings;
    private final UnaryCallSettings<GetTableRequest, Table> getTableSettings;
    private final UnaryCallSettings<UpdateTableRequest, Operation> updateTableSettings;
    private final OperationCallSettings<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationSettings;
    private final UnaryCallSettings<DeleteTableRequest, Empty> deleteTableSettings;
    private final UnaryCallSettings<UndeleteTableRequest, Operation> undeleteTableSettings;
    private final OperationCallSettings<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationSettings;
    private final UnaryCallSettings<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings;
    private final UnaryCallSettings<DropRowRangeRequest, Empty> dropRowRangeSettings;
    private final UnaryCallSettings<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings;
    private final UnaryCallSettings<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings;
    private final UnaryCallSettings<SnapshotTableRequest, Operation> snapshotTableSettings;
    private final OperationCallSettings<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings;
    private final UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings;
    private final PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
    private final UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings;
    private final OperationCallSettings<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<UpdateBackupRequest, Backup> updateBackupSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Empty> deleteBackupSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, BaseBigtableTableAdminClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<RestoreTableRequest, Operation> restoreTableSettings;
    private final OperationCallSettings<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationSettings;
    private final UnaryCallSettings<CopyBackupRequest, Operation> copyBackupSettings;
    private final OperationCallSettings<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table> LIST_TABLES_PAGE_STR_DESC = new PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table>(){

        public String emptyToken() {
            return "";
        }

        public ListTablesRequest injectToken(ListTablesRequest payload, String token) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageToken(token).build();
        }

        public ListTablesRequest injectPageSize(ListTablesRequest payload, int pageSize) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTablesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTablesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Table> extractResources(ListTablesResponse payload) {
            return payload.getTablesList() == null ? ImmutableList.of() : payload.getTablesList();
        }
    };
    private static final PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>(){

        public String emptyToken() {
            return "";
        }

        public ListSnapshotsRequest injectToken(ListSnapshotsRequest payload, String token) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageToken(token).build();
        }

        public ListSnapshotsRequest injectPageSize(ListSnapshotsRequest payload, int pageSize) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Snapshot> extractResources(ListSnapshotsResponse payload) {
            return payload.getSnapshotsList() == null ? ImmutableList.of() : payload.getSnapshotsList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList() == null ? ImmutableList.of() : payload.getBackupsList();
        }
    };
    private static final PagedListResponseFactory<ListTablesRequest, ListTablesResponse, BaseBigtableTableAdminClient.ListTablesPagedResponse> LIST_TABLES_PAGE_STR_FACT = new PagedListResponseFactory<ListTablesRequest, ListTablesResponse, BaseBigtableTableAdminClient.ListTablesPagedResponse>(){

        public ApiFuture<BaseBigtableTableAdminClient.ListTablesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTablesRequest, ListTablesResponse> callable, ListTablesRequest request, ApiCallContext context, ApiFuture<ListTablesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TABLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableTableAdminClient.ListTablesPagedResponse.createAsync((PageContext<ListTablesRequest, ListTablesResponse, Table>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse>(){

        public ApiFuture<BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> callable, ListSnapshotsRequest request, ApiCallContext context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableTableAdminClient.ListSnapshotsPagedResponse.createAsync((PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, BaseBigtableTableAdminClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, BaseBigtableTableAdminClient.ListBackupsPagedResponse>(){

        public ApiFuture<BaseBigtableTableAdminClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BaseBigtableTableAdminClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTableRequest, Table> createTableSettings() {
        return this.createTableSettings;
    }

    public UnaryCallSettings<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings() {
        return this.createTableFromSnapshotSettings;
    }

    public OperationCallSettings<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings() {
        return this.createTableFromSnapshotOperationSettings;
    }

    public PagedCallSettings<ListTablesRequest, ListTablesResponse, BaseBigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings() {
        return this.listTablesSettings;
    }

    public UnaryCallSettings<GetTableRequest, Table> getTableSettings() {
        return this.getTableSettings;
    }

    public UnaryCallSettings<UpdateTableRequest, Operation> updateTableSettings() {
        return this.updateTableSettings;
    }

    public OperationCallSettings<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationSettings() {
        return this.updateTableOperationSettings;
    }

    public UnaryCallSettings<DeleteTableRequest, Empty> deleteTableSettings() {
        return this.deleteTableSettings;
    }

    public UnaryCallSettings<UndeleteTableRequest, Operation> undeleteTableSettings() {
        return this.undeleteTableSettings;
    }

    public OperationCallSettings<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationSettings() {
        return this.undeleteTableOperationSettings;
    }

    public UnaryCallSettings<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings() {
        return this.modifyColumnFamiliesSettings;
    }

    public UnaryCallSettings<DropRowRangeRequest, Empty> dropRowRangeSettings() {
        return this.dropRowRangeSettings;
    }

    public UnaryCallSettings<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings() {
        return this.generateConsistencyTokenSettings;
    }

    public UnaryCallSettings<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings() {
        return this.checkConsistencySettings;
    }

    public UnaryCallSettings<SnapshotTableRequest, Operation> snapshotTableSettings() {
        return this.snapshotTableSettings;
    }

    public OperationCallSettings<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings() {
        return this.snapshotTableOperationSettings;
    }

    public UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
        return this.getSnapshotSettings;
    }

    public PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings() {
        return this.createBackupSettings;
    }

    public OperationCallSettings<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings() {
        return this.createBackupOperationSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<UpdateBackupRequest, Backup> updateBackupSettings() {
        return this.updateBackupSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Empty> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, BaseBigtableTableAdminClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<RestoreTableRequest, Operation> restoreTableSettings() {
        return this.restoreTableSettings;
    }

    public OperationCallSettings<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationSettings() {
        return this.restoreTableOperationSettings;
    }

    public UnaryCallSettings<CopyBackupRequest, Operation> copyBackupSettings() {
        return this.copyBackupSettings;
    }

    public OperationCallSettings<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings() {
        return this.copyBackupOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public BigtableTableAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigtableTableAdminStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return BigtableTableAdminStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "bigtableadmin";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigtableadmin.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigtableadmin.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigtableTableAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigtableTableAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigtableTableAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTableSettings = settingsBuilder.createTableSettings().build();
        this.createTableFromSnapshotSettings = settingsBuilder.createTableFromSnapshotSettings().build();
        this.createTableFromSnapshotOperationSettings = settingsBuilder.createTableFromSnapshotOperationSettings().build();
        this.listTablesSettings = settingsBuilder.listTablesSettings().build();
        this.getTableSettings = settingsBuilder.getTableSettings().build();
        this.updateTableSettings = settingsBuilder.updateTableSettings().build();
        this.updateTableOperationSettings = settingsBuilder.updateTableOperationSettings().build();
        this.deleteTableSettings = settingsBuilder.deleteTableSettings().build();
        this.undeleteTableSettings = settingsBuilder.undeleteTableSettings().build();
        this.undeleteTableOperationSettings = settingsBuilder.undeleteTableOperationSettings().build();
        this.modifyColumnFamiliesSettings = settingsBuilder.modifyColumnFamiliesSettings().build();
        this.dropRowRangeSettings = settingsBuilder.dropRowRangeSettings().build();
        this.generateConsistencyTokenSettings = settingsBuilder.generateConsistencyTokenSettings().build();
        this.checkConsistencySettings = settingsBuilder.checkConsistencySettings().build();
        this.snapshotTableSettings = settingsBuilder.snapshotTableSettings().build();
        this.snapshotTableOperationSettings = settingsBuilder.snapshotTableOperationSettings().build();
        this.getSnapshotSettings = settingsBuilder.getSnapshotSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.createBackupSettings = settingsBuilder.createBackupSettings().build();
        this.createBackupOperationSettings = settingsBuilder.createBackupOperationSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.updateBackupSettings = settingsBuilder.updateBackupSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.restoreTableSettings = settingsBuilder.restoreTableSettings().build();
        this.restoreTableOperationSettings = settingsBuilder.restoreTableOperationSettings().build();
        this.copyBackupSettings = settingsBuilder.copyBackupSettings().build();
        this.copyBackupOperationSettings = settingsBuilder.copyBackupOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigtableTableAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTableRequest, Table> createTableSettings;
        private final UnaryCallSettings.Builder<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings;
        private final OperationCallSettings.Builder<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings;
        private final PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, BaseBigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings;
        private final UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings;
        private final UnaryCallSettings.Builder<UpdateTableRequest, Operation> updateTableSettings;
        private final OperationCallSettings.Builder<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTableRequest, Empty> deleteTableSettings;
        private final UnaryCallSettings.Builder<UndeleteTableRequest, Operation> undeleteTableSettings;
        private final OperationCallSettings.Builder<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationSettings;
        private final UnaryCallSettings.Builder<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings;
        private final UnaryCallSettings.Builder<DropRowRangeRequest, Empty> dropRowRangeSettings;
        private final UnaryCallSettings.Builder<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings;
        private final UnaryCallSettings.Builder<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings;
        private final UnaryCallSettings.Builder<SnapshotTableRequest, Operation> snapshotTableSettings;
        private final OperationCallSettings.Builder<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings;
        private final UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings;
        private final PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
        private final UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings;
        private final OperationCallSettings.Builder<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<UpdateBackupRequest, Backup> updateBackupSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Empty> deleteBackupSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, BaseBigtableTableAdminClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<RestoreTableRequest, Operation> restoreTableSettings;
        private final OperationCallSettings.Builder<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationSettings;
        private final UnaryCallSettings.Builder<CopyBackupRequest, Operation> copyBackupSettings;
        private final OperationCallSettings.Builder<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTableFromSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTableFromSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.listTablesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TABLES_PAGE_STR_FACT);
            this.getTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTableOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteTableOperationSettings = OperationCallSettings.newBuilder();
            this.modifyColumnFamiliesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.dropRowRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateConsistencyTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkConsistencySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.snapshotTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.snapshotTableOperationSettings = OperationCallSettings.newBuilder();
            this.getSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupOperationSettings = OperationCallSettings.newBuilder();
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.restoreTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreTableOperationSettings = OperationCallSettings.newBuilder();
            this.copyBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.copyBackupOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTableSettings, this.createTableFromSnapshotSettings, this.listTablesSettings, this.getTableSettings, this.updateTableSettings, this.deleteTableSettings, this.undeleteTableSettings, this.modifyColumnFamiliesSettings, this.dropRowRangeSettings, this.generateConsistencyTokenSettings, this.checkConsistencySettings, this.snapshotTableSettings, (Object[])new UnaryCallSettings.Builder[]{this.getSnapshotSettings, this.listSnapshotsSettings, this.deleteSnapshotSettings, this.createBackupSettings, this.getBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.listBackupsSettings, this.restoreTableSettings, this.copyBackupSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BigtableTableAdminStubSettings settings) {
            super((StubSettings)settings);
            this.createTableSettings = settings.createTableSettings.toBuilder();
            this.createTableFromSnapshotSettings = settings.createTableFromSnapshotSettings.toBuilder();
            this.createTableFromSnapshotOperationSettings = settings.createTableFromSnapshotOperationSettings.toBuilder();
            this.listTablesSettings = settings.listTablesSettings.toBuilder();
            this.getTableSettings = settings.getTableSettings.toBuilder();
            this.updateTableSettings = settings.updateTableSettings.toBuilder();
            this.updateTableOperationSettings = settings.updateTableOperationSettings.toBuilder();
            this.deleteTableSettings = settings.deleteTableSettings.toBuilder();
            this.undeleteTableSettings = settings.undeleteTableSettings.toBuilder();
            this.undeleteTableOperationSettings = settings.undeleteTableOperationSettings.toBuilder();
            this.modifyColumnFamiliesSettings = settings.modifyColumnFamiliesSettings.toBuilder();
            this.dropRowRangeSettings = settings.dropRowRangeSettings.toBuilder();
            this.generateConsistencyTokenSettings = settings.generateConsistencyTokenSettings.toBuilder();
            this.checkConsistencySettings = settings.checkConsistencySettings.toBuilder();
            this.snapshotTableSettings = settings.snapshotTableSettings.toBuilder();
            this.snapshotTableOperationSettings = settings.snapshotTableOperationSettings.toBuilder();
            this.getSnapshotSettings = settings.getSnapshotSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.createBackupSettings = settings.createBackupSettings.toBuilder();
            this.createBackupOperationSettings = settings.createBackupOperationSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.updateBackupSettings = settings.updateBackupSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.restoreTableSettings = settings.restoreTableSettings.toBuilder();
            this.restoreTableOperationSettings = settings.restoreTableOperationSettings.toBuilder();
            this.copyBackupSettings = settings.copyBackupSettings.toBuilder();
            this.copyBackupOperationSettings = settings.copyBackupOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTableSettings, this.createTableFromSnapshotSettings, this.listTablesSettings, this.getTableSettings, this.updateTableSettings, this.deleteTableSettings, this.undeleteTableSettings, this.modifyColumnFamiliesSettings, this.dropRowRangeSettings, this.generateConsistencyTokenSettings, this.checkConsistencySettings, this.snapshotTableSettings, (Object[])new UnaryCallSettings.Builder[]{this.getSnapshotSettings, this.listSnapshotsSettings, this.deleteSnapshotSettings, this.createBackupSettings, this.getBackupSettings, this.updateBackupSettings, this.deleteBackupSettings, this.listBackupsSettings, this.restoreTableSettings, this.copyBackupSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigtableTableAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigtableTableAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigtableTableAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BigtableTableAdminStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createTableFromSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTablesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.getTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.undeleteTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.modifyColumnFamiliesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.dropRowRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.generateConsistencyTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.checkConsistencySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.snapshotTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.restoreTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.copyBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.createTableFromSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Table.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTableFromSnapshotMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)3600000L)).build()));
            builder.updateTableOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Table.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateTableMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteTableOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Table.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeleteTableMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.snapshotTableOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Snapshot.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(SnapshotTableMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateBackupMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.restoreTableOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Table.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RestoreTableMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.copyBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CopyBackupMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTableRequest, Table> createTableSettings() {
            return this.createTableSettings;
        }

        public UnaryCallSettings.Builder<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotSettings() {
            return this.createTableFromSnapshotSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTableFromSnapshotRequest, Table, CreateTableFromSnapshotMetadata> createTableFromSnapshotOperationSettings() {
            return this.createTableFromSnapshotOperationSettings;
        }

        public PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, BaseBigtableTableAdminClient.ListTablesPagedResponse> listTablesSettings() {
            return this.listTablesSettings;
        }

        public UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings() {
            return this.getTableSettings;
        }

        public UnaryCallSettings.Builder<UpdateTableRequest, Operation> updateTableSettings() {
            return this.updateTableSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTableRequest, Table, UpdateTableMetadata> updateTableOperationSettings() {
            return this.updateTableOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTableRequest, Empty> deleteTableSettings() {
            return this.deleteTableSettings;
        }

        public UnaryCallSettings.Builder<UndeleteTableRequest, Operation> undeleteTableSettings() {
            return this.undeleteTableSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UndeleteTableRequest, Table, UndeleteTableMetadata> undeleteTableOperationSettings() {
            return this.undeleteTableOperationSettings;
        }

        public UnaryCallSettings.Builder<ModifyColumnFamiliesRequest, Table> modifyColumnFamiliesSettings() {
            return this.modifyColumnFamiliesSettings;
        }

        public UnaryCallSettings.Builder<DropRowRangeRequest, Empty> dropRowRangeSettings() {
            return this.dropRowRangeSettings;
        }

        public UnaryCallSettings.Builder<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenSettings() {
            return this.generateConsistencyTokenSettings;
        }

        public UnaryCallSettings.Builder<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencySettings() {
            return this.checkConsistencySettings;
        }

        public UnaryCallSettings.Builder<SnapshotTableRequest, Operation> snapshotTableSettings() {
            return this.snapshotTableSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SnapshotTableRequest, Snapshot, SnapshotTableMetadata> snapshotTableOperationSettings() {
            return this.snapshotTableOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
            return this.getSnapshotSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, BaseBigtableTableAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings() {
            return this.createBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateBackupRequest, Backup, CreateBackupMetadata> createBackupOperationSettings() {
            return this.createBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupRequest, Backup> updateBackupSettings() {
            return this.updateBackupSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Empty> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, BaseBigtableTableAdminClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<RestoreTableRequest, Operation> restoreTableSettings() {
            return this.restoreTableSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreTableRequest, Table, RestoreTableMetadata> restoreTableOperationSettings() {
            return this.restoreTableOperationSettings;
        }

        public UnaryCallSettings.Builder<CopyBackupRequest, Operation> copyBackupSettings() {
            return this.copyBackupSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CopyBackupRequest, Backup, CopyBackupMetadata> copyBackupOperationSettings() {
            return this.copyBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return BigtableTableAdminStubSettings.getDefaultEndpoint();
        }

        public BigtableTableAdminStubSettings build() throws IOException {
            return new BigtableTableAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"no_retry_4_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

