/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithmWithContext;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedRetryAlgorithmWithContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.data.v2.internal.JwtCredentialsWithAudience;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.DefaultChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.cloud.bigtable.data.v2.stub.ConvertExceptionCallable;
import com.google.cloud.bigtable.data.v2.stub.CookiesInterceptor;
import com.google.cloud.bigtable.data.v2.stub.CookiesServerStreamingCallable;
import com.google.cloud.bigtable.data.v2.stub.CookiesUnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlCallable;
import com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlStats;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import com.google.cloud.bigtable.data.v2.stub.RateLimitingServerStreamingCallable;
import com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.cloud.bigtable.data.v2.stub.changestream.ChangeStreamRecordMergingCallable;
import com.google.cloud.bigtable.data.v2.stub.changestream.GenerateInitialChangeStreamPartitionsUserCallable;
import com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamResumptionStrategy;
import com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamUserCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracerStreamingCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracerUnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.StatsHeadersServerStreamingCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.StatsHeadersUnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.TracedBatcherUnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.BulkMutateRowsUserFacingCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsRetryingCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsFirstCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsResumptionStrategy;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsUserCallable;
import com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.cloud.bigtable.gaxx.retrying.ApiResultRetryAlgorithm;
import com.google.cloud.bigtable.gaxx.retrying.Callables;
import com.google.cloud.bigtable.gaxx.retrying.RetryInfoRetryAlgorithm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private static final String CLIENT_NAME = "Bigtable";
    private static final long FLOW_CONTROL_ADJUSTING_INTERVAL_MS = TimeUnit.SECONDS.toMillis(20L);
    private final EnhancedBigtableStubSettings settings;
    private final ClientContext clientContext;
    private final boolean closeClientContext;
    private final RequestContext requestContext;
    private final FlowController bulkMutationFlowController;
    private final DynamicFlowControlStats bulkMutationDynamicFlowControlStats;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<Query, Row> readRowCallable;
    private final UnaryCallable<Query, List<Row>> bulkReadRowsCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;
    private final UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable;
    private final UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable;
    private final UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable;
    private final ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable;
    private final ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        settings = ((EnhancedBigtableStubSettings.Builder)settings.toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory(settings))).build();
        ClientContext clientContext = EnhancedBigtableStub.createClientContext(settings);
        return new EnhancedBigtableStub(settings, clientContext);
    }

    public static EnhancedBigtableStub createWithClientContext(EnhancedBigtableStubSettings settings, ClientContext clientContext) throws IOException {
        return new EnhancedBigtableStub(settings, clientContext, false);
    }

    public static ClientContext createClientContext(EnhancedBigtableStubSettings settings) throws IOException {
        InstantiatingGrpcChannelProvider.Builder transportProvider;
        EnhancedBigtableStubSettings.Builder builder = settings.toBuilder();
        EnhancedBigtableStub.patchCredentials(builder);
        InstantiatingGrpcChannelProvider.Builder builder2 = transportProvider = builder.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider ? ((InstantiatingGrpcChannelProvider)builder.getTransportChannelProvider()).toBuilder() : null;
        if (builder.getEnableRoutingCookie() && transportProvider != null) {
            transportProvider.setInterceptorProvider(() -> ImmutableList.of((Object)new CookiesInterceptor()));
        }
        if (settings.isRefreshingChannel()) {
            Credentials credentials = null;
            if (builder.getCredentialsProvider() != null) {
                credentials = builder.getCredentialsProvider().getCredentials();
            }
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create(credentials));
            if (transportProvider != null) {
                transportProvider.setChannelPrimer((ChannelPrimer)BigtableChannelPrimer.create(credentials, settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId()));
            }
        }
        if (transportProvider != null) {
            builder.setTransportChannelProvider((TransportChannelProvider)transportProvider.build());
        }
        return ClientContext.create((StubSettings)builder.build());
    }

    public static ApiTracerFactory createBigtableTracerFactory(EnhancedBigtableStubSettings settings) {
        return EnhancedBigtableStub.createBigtableTracerFactory(settings, Tags.getTagger(), Stats.getStatsRecorder());
    }

    @VisibleForTesting
    public static ApiTracerFactory createBigtableTracerFactory(EnhancedBigtableStubSettings settings, Tagger tagger, StatsRecorder stats) {
        String projectId = settings.getProjectId();
        String instanceId = settings.getInstanceId();
        String appProfileId = settings.getAppProfileId();
        ImmutableMap attributes = ImmutableMap.builder().put((Object)RpcMeasureConstants.BIGTABLE_PROJECT_ID, (Object)TagValue.create((String)projectId)).put((Object)RpcMeasureConstants.BIGTABLE_INSTANCE_ID, (Object)TagValue.create((String)instanceId)).put((Object)RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID, (Object)TagValue.create((String)appProfileId)).build();
        ImmutableMap builtinAttributes = ImmutableMap.builder().put((Object)"project_id", (Object)projectId).put((Object)"instance", (Object)instanceId).put((Object)"app_profile", (Object)appProfileId).put((Object)"client_name", (Object)("bigtable-java/" + Version.VERSION)).build();
        return new CompositeTracerFactory((List<ApiTracerFactory>)ImmutableList.of((Object)new OpencensusTracerFactory((Map)ImmutableMap.builder().put((Object)RpcMeasureConstants.BIGTABLE_PROJECT_ID.getName(), (Object)projectId).put((Object)RpcMeasureConstants.BIGTABLE_INSTANCE_ID.getName(), (Object)instanceId).put((Object)RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID.getName(), (Object)appProfileId).put((Object)"gax", (Object)GaxGrpcProperties.getGaxGrpcVersion()).put((Object)"grpc", (Object)GaxGrpcProperties.getGrpcVersion()).put((Object)"gapic", (Object)Version.VERSION).build()), (Object)((Object)MetricsTracerFactory.create(tagger, stats, (ImmutableMap<TagKey, TagValue>)attributes)), (Object)((Object)BuiltinMetricsTracerFactory.create((ImmutableMap<String, String>)builtinAttributes)), (Object)settings.getTracerFactory()));
    }

    private static void patchCredentials(EnhancedBigtableStubSettings.Builder settings) throws IOException {
        int i = settings.getEndpoint().lastIndexOf(":");
        String host = settings.getEndpoint().substring(0, i);
        String audience = settings.getJwtAudienceMapping().get(host);
        if (audience == null) {
            return;
        }
        URI audienceUri = null;
        try {
            audienceUri = new URI(audience);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid JWT audience override", e);
        }
        CredentialsProvider credentialsProvider = settings.getCredentialsProvider();
        if (credentialsProvider == null) {
            return;
        }
        Credentials credentials = credentialsProvider.getCredentials();
        if (credentials == null) {
            return;
        }
        if (!(credentials instanceof ServiceAccountJwtAccessCredentials)) {
            return;
        }
        ServiceAccountJwtAccessCredentials jwtCreds = (ServiceAccountJwtAccessCredentials)credentials;
        JwtCredentialsWithAudience patchedCreds = new JwtCredentialsWithAudience(jwtCreds, audienceUri);
        settings.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)patchedCreds));
    }

    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext) {
        this(settings, clientContext, true);
    }

    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext, boolean closeClientContext) {
        this.settings = settings;
        this.clientContext = clientContext;
        this.closeClientContext = closeClientContext;
        this.requestContext = RequestContext.create(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
        this.bulkMutationFlowController = new FlowController(settings.bulkMutateRowsSettings().getDynamicFlowControlSettings());
        this.bulkMutationDynamicFlowControlStats = new DynamicFlowControlStats();
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.readRowCallable = this.createReadRowCallable(new DefaultRowAdapter());
        this.bulkReadRowsCallable = this.createBulkReadRowsCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.mutateRowCallable = this.createMutateRowCallable();
        this.bulkMutateRowsCallable = this.createBulkMutateRowsCallable();
        this.checkAndMutateRowCallable = this.createCheckAndMutateRowCallable();
        this.readModifyWriteRowCallable = this.createReadModifyWriteRowCallable();
        this.generateInitialChangeStreamPartitionsCallable = this.createGenerateInitialChangeStreamPartitionsCallable();
        this.readChangeStreamCallable = this.createReadChangeStreamCallable(new DefaultChangeStreamRecordAdapter());
        this.pingAndWarmCallable = this.createPingAndWarmCallable();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public <RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsRawCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter).withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readRowsUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> UnaryCallable<Query, RowT> createReadRowCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.readRowSettings().getRetryableCodes()).setRetrySettings(this.settings.readRowSettings().getRetrySettings()).setIdleTimeout(this.settings.readRowSettings().getRetrySettings().getTotalTimeout()).build(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        ReadRowsFirstCallable firstRow = new ReadRowsFirstCallable(readRowCallable);
        TracedUnaryCallable traced = new TracedUnaryCallable(firstRow, this.clientContext.getTracerFactory(), this.getSpanName("ReadRow"));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <ReqT, RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsBaseCallable(ServerStreamingCallSettings<ReqT, Row> readRowsSettings, RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRowsRequest>(){

            public Map<String, String> extract(ReadRowsRequest readRowsRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)readRowsRequest.getTableName(), (Object)"app_profile_id", (Object)readRowsRequest.getAppProfileId());
            }
        }).build(), (Set)readRowsSettings.getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse> convertException = new ConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse>(withStatsHeaders);
        RowMergingCallable<RowT> merging = new RowMergingCallable<RowT>(convertException, rowAdapter);
        ServerStreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadRowsResumptionStrategy<RowT>(rowAdapter)).setRetryableCodes(readRowsSettings.getRetryableCodes()).setRetrySettings(readRowsSettings.getRetrySettings()).setIdleTimeout(readRowsSettings.getIdleTimeout()).setWaitTimeout(readRowsSettings.getWaitTimeout()).build();
        ServerStreamingCallable watched = com.google.api.gax.rpc.Callables.watched(merging, (ServerStreamingCallSettings)innerSettings, (ClientContext)this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ReadRowsRetryCompletedCallable retrying1 = new ReadRowsRetryCompletedCallable(withBigtableTracer);
        ServerStreamingCallable retrying2 = this.withRetries(retrying1, innerSettings);
        return new FilterMarkerRowsCallable(retrying2, rowAdapter);
    }

    private <RowT> UnaryCallable<Query, List<RowT>> createBulkReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedBatcherUnaryCallable tracedBatcher = new TracedBatcherUnaryCallable(readRowsUserCallable.all());
        TracedUnaryCallable traced = new TracedUnaryCallable(tracedBatcher, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        String methodName = "SampleRowKeys";
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getSampleRowKeysMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SampleRowKeysRequest>(){

            public Map<String, String> extract(SampleRowKeysRequest sampleRowKeysRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)sampleRowKeysRequest.getTableName(), (Object)"app_profile_id", (Object)sampleRowKeysRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.sampleRowKeysSettings().getRetryableCodes());
        UnaryCallable spoolable = base.all();
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(spoolable);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable retryable = this.withRetries(withBigtableTracer, this.settings.sampleRowKeysSettings());
        return this.createUserFacingUnaryCallable(methodName, new SampleRowKeysCallable(retryable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        String methodName = "MutateRow";
        UnaryCallable base = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateRowRequest>(){

            public Map<String, String> extract(MutateRowRequest mutateRowRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)mutateRowRequest.getTableName(), (Object)"app_profile_id", (Object)mutateRowRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.mutateRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable retrying = this.withRetries(withBigtableTracer, this.settings.mutateRowSettings());
        return this.createUserFacingUnaryCallable(methodName, new MutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<BulkMutation, Void> createBulkMutateRowsCallable() {
        DynamicFlowControlCallable baseCallable;
        DynamicFlowControlCallable withCookie = baseCallable = this.createMutateRowsBaseCallable();
        if (this.settings.getEnableRoutingCookie()) {
            withCookie = new CookiesUnaryCallable<MutateRowsRequest, Void>(baseCallable);
        }
        DynamicFlowControlCallable flowControlCallable = null;
        if (this.settings.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()) {
            flowControlCallable = new DynamicFlowControlCallable(withCookie, this.bulkMutationFlowController, this.bulkMutationDynamicFlowControlStats, this.settings.bulkMutateRowsSettings().getTargetRpcLatencyMs(), FLOW_CONTROL_ADJUSTING_INTERVAL_MS);
        }
        BulkMutateRowsUserFacingCallable userFacing = new BulkMutateRowsUserFacingCallable(flowControlCallable != null ? flowControlCallable : withCookie, this.requestContext);
        SpanName spanName = this.getSpanName("MutateRows");
        TracedBatcherUnaryCallable tracedBatcherUnaryCallable = new TracedBatcherUnaryCallable(userFacing);
        TracedUnaryCallable traced = new TracedUnaryCallable(tracedBatcherUnaryCallable, this.clientContext.getTracerFactory(), spanName);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public Batcher<RowMutationEntry, Void> newMutateRowsBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        return new BatcherImpl(this.settings.bulkMutateRowsSettings().getBatchingDescriptor(), this.bulkMutateRowsCallable, (Object)BulkMutation.create(tableId), this.settings.bulkMutateRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), this.bulkMutationFlowController, (ApiCallContext)MoreObjects.firstNonNull((Object)ctx, (Object)this.clientContext.getDefaultCallContext()));
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(@Nonnull Query query, @Nullable GrpcCallContext ctx) {
        Preconditions.checkNotNull((Object)query, (Object)"query cannot be null");
        return new BatcherImpl(this.settings.bulkReadRowsSettings().getBatchingDescriptor(), this.bulkReadRowsCallable, (Object)query, this.settings.bulkReadRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), null, (ApiCallContext)MoreObjects.firstNonNull((Object)ctx, (Object)this.clientContext.getDefaultCallContext()));
    }

    private UnaryCallable<MutateRowsRequest, Void> createMutateRowsBaseCallable() {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateRowsRequest>(){

            public Map<String, String> extract(MutateRowsRequest mutateRowsRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)mutateRowsRequest.getTableName(), (Object)"app_profile_id", (Object)mutateRowsRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.bulkMutateRowsSettings().getRetryableCodes());
        ServerStreamingCallable callable = new StatsHeadersServerStreamingCallable<MutateRowsRequest, MutateRowsResponse>(base);
        if (this.settings.bulkMutateRowsSettings().isServerInitiatedFlowControlEnabled()) {
            callable = new RateLimitingServerStreamingCallable(callable);
        }
        ConvertExceptionCallable<MutateRowsRequest, MutateRowsResponse> convertException = new ConvertExceptionCallable<MutateRowsRequest, MutateRowsResponse>(callable);
        BigtableTracerStreamingCallable<MutateRowsRequest, MutateRowsResponse> withBigtableTracer = new BigtableTracerStreamingCallable<MutateRowsRequest, MutateRowsResponse>(convertException);
        BasicResultRetryAlgorithm resultRetryAlgorithm = this.settings.getEnableRetryInfo() ? new RetryInfoRetryAlgorithm() : new ApiResultRetryAlgorithm();
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm((ResultRetryAlgorithmWithContext)resultRetryAlgorithm, (TimedRetryAlgorithmWithContext)new ExponentialRetryAlgorithm(this.settings.bulkMutateRowsSettings().getRetrySettings(), this.clientContext.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor(retryAlgorithm, this.clientContext.getExecutor());
        return new MutateRowsRetryingCallable(this.clientContext.getDefaultCallContext(), withBigtableTracer, (RetryingExecutorWithContext<Void>)retryingExecutor, this.settings.bulkMutateRowsSettings().getRetryableCodes(), retryAlgorithm);
    }

    private UnaryCallable<ConditionalRowMutation, Boolean> createCheckAndMutateRowCallable() {
        String methodName = "CheckAndMutateRow";
        UnaryCallable base = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getCheckAndMutateRowMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CheckAndMutateRowRequest>(){

            public Map<String, String> extract(CheckAndMutateRowRequest checkAndMutateRowRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)checkAndMutateRowRequest.getTableName(), (Object)"app_profile_id", (Object)checkAndMutateRowRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.checkAndMutateRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable retrying = this.withRetries(withBigtableTracer, this.settings.checkAndMutateRowSettings());
        return this.createUserFacingUnaryCallable(methodName, new CheckAndMutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<ReadModifyWriteRow, Row> createReadModifyWriteRowCallable() {
        UnaryCallable base = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadModifyWriteRowMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadModifyWriteRowRequest>(){

            public Map<String, String> extract(ReadModifyWriteRowRequest request) {
                return ImmutableMap.of((Object)"table_name", (Object)request.getTableName(), (Object)"app_profile_id", (Object)request.getAppProfileId());
            }
        }).build(), (Set)this.settings.readModifyWriteRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        String methodName = "ReadModifyWriteRow";
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable retrying = this.withRetries(withBigtableTracer, this.settings.readModifyWriteRowSettings());
        return this.createUserFacingUnaryCallable(methodName, new ReadModifyWriteRowCallable(retrying, this.requestContext));
    }

    private ServerStreamingCallable<String, Range.ByteStringRange> createGenerateInitialChangeStreamPartitionsCallable() {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getGenerateInitialChangeStreamPartitionsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GenerateInitialChangeStreamPartitionsRequest>(){

            public Map<String, String> extract(GenerateInitialChangeStreamPartitionsRequest generateInitialChangeStreamPartitionsRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)generateInitialChangeStreamPartitionsRequest.getTableName(), (Object)"app_profile_id", (Object)generateInitialChangeStreamPartitionsRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.generateInitialChangeStreamPartitionsSettings().getRetryableCodes());
        GenerateInitialChangeStreamPartitionsUserCallable userCallable = new GenerateInitialChangeStreamPartitionsUserCallable((ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse>)base, this.requestContext);
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(userCallable);
        ConvertExceptionCallable convertException = new ConvertExceptionCallable(withStatsHeaders);
        ServerStreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.generateInitialChangeStreamPartitionsSettings().getRetryableCodes()).setRetrySettings(this.settings.generateInitialChangeStreamPartitionsSettings().getRetrySettings()).setIdleTimeout(this.settings.generateInitialChangeStreamPartitionsSettings().getIdleTimeout()).setWaitTimeout(this.settings.generateInitialChangeStreamPartitionsSettings().getWaitTimeout()).build();
        ServerStreamingCallable watched = com.google.api.gax.rpc.Callables.watched(convertException, (ServerStreamingCallSettings)innerSettings, (ClientContext)this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ServerStreamingCallable retrying = this.withRetries(withBigtableTracer, innerSettings);
        SpanName span = this.getSpanName("GenerateInitialChangeStreamPartitions");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(retrying, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <ChangeStreamRecordT> ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecordT> createReadChangeStreamCallable(ChangeStreamRecordAdapter<ChangeStreamRecordT> changeStreamRecordAdapter) {
        ServerStreamingCallable base = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadChangeStreamMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadChangeStreamRequest>(){

            public Map<String, String> extract(ReadChangeStreamRequest readChangeStreamRequest) {
                return ImmutableMap.of((Object)"table_name", (Object)readChangeStreamRequest.getTableName(), (Object)"app_profile_id", (Object)readChangeStreamRequest.getAppProfileId());
            }
        }).build(), (Set)this.settings.readChangeStreamSettings().getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> convertException = new ConvertExceptionCallable<ReadChangeStreamRequest, ReadChangeStreamResponse>(withStatsHeaders);
        ChangeStreamRecordMergingCallable<ChangeStreamRecordT> merging = new ChangeStreamRecordMergingCallable<ChangeStreamRecordT>(convertException, changeStreamRecordAdapter);
        ServerStreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadChangeStreamResumptionStrategy<ChangeStreamRecordT>(changeStreamRecordAdapter)).setRetryableCodes(this.settings.readChangeStreamSettings().getRetryableCodes()).setRetrySettings(this.settings.readChangeStreamSettings().getRetrySettings()).setIdleTimeout(this.settings.readChangeStreamSettings().getIdleTimeout()).setWaitTimeout(this.settings.readChangeStreamSettings().getWaitTimeout()).build();
        ServerStreamingCallable watched = com.google.api.gax.rpc.Callables.watched(merging, (ServerStreamingCallSettings)innerSettings, (ClientContext)this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ServerStreamingCallable readChangeStreamCallable = this.withRetries(withBigtableTracer, innerSettings);
        ReadChangeStreamUserCallable readChangeStreamUserCallable = new ReadChangeStreamUserCallable(readChangeStreamCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadChangeStream");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readChangeStreamUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUserFacingUnaryCallable(String methodName, UnaryCallable<RequestT, ResponseT> inner) {
        TracedUnaryCallable traced = new TracedUnaryCallable(inner, this.clientContext.getTracerFactory(), this.getSpanName(methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> createPingAndWarmCallable() {
        UnaryCallable pingAndWarm = GrpcRawCallableFactory.createUnaryCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getPingAndWarmMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<PingAndWarmRequest>(){

            public Map<String, String> extract(PingAndWarmRequest request) {
                return ImmutableMap.of((Object)"name", (Object)request.getName(), (Object)"app_profile_id", (Object)request.getAppProfileId());
            }
        }).build(), Collections.emptySet());
        return pingAndWarm.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> withRetries(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<?, ?> unaryCallSettings) {
        UnaryCallable retrying = this.settings.getEnableRetryInfo() ? Callables.retrying(innerCallable, unaryCallSettings, this.clientContext) : com.google.api.gax.rpc.Callables.retrying(innerCallable, unaryCallSettings, (ClientContext)this.clientContext);
        if (this.settings.getEnableRoutingCookie()) {
            return new CookiesUnaryCallable(retrying);
        }
        return retrying;
    }

    private <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> withRetries(ServerStreamingCallable<RequestT, ResponseT> innerCallable, ServerStreamingCallSettings<RequestT, ResponseT> serverStreamingCallSettings) {
        ServerStreamingCallable retrying = this.settings.getEnableRetryInfo() ? Callables.retrying(innerCallable, serverStreamingCallSettings, this.clientContext) : com.google.api.gax.rpc.Callables.retrying(innerCallable, serverStreamingCallSettings, (ClientContext)this.clientContext);
        if (this.settings.getEnableRoutingCookie()) {
            return new CookiesServerStreamingCallable(retrying);
        }
        return retrying;
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.readRowCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    public UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable() {
        return this.bulkMutateRowsCallable;
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    public ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable() {
        return this.generateInitialChangeStreamPartitionsCallable;
    }

    public ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable() {
        return this.readChangeStreamCallable;
    }

    UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable() {
        return this.pingAndWarmCallable;
    }

    private SpanName getSpanName(String methodName) {
        return SpanName.of((String)CLIENT_NAME, (String)methodName);
    }

    @Override
    public void close() {
        if (this.closeClientContext) {
            for (BackgroundResource backgroundResource : this.clientContext.getBackgroundResources()) {
                try {
                    backgroundResource.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to close resource", e);
                }
            }
        }
    }
}

