/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingExecutorWithContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;

@InternalApi
public class MutateRowsRetryingCallable
extends UnaryCallable<MutateRowsRequest, Void> {
    private final ApiCallContext callContextPrototype;
    private final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> callable;
    private final RetryingExecutorWithContext<Void> executor;
    private final ImmutableSet<StatusCode.Code> retryCodes;
    private final RetryAlgorithm retryAlgorithm;

    public MutateRowsRetryingCallable(@Nonnull ApiCallContext callContextPrototype, @Nonnull ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> callable, @Nonnull RetryingExecutorWithContext<Void> executor, @Nonnull Set<StatusCode.Code> retryCodes, @Nonnull RetryAlgorithm retryAlgorithm) {
        this.callContextPrototype = (ApiCallContext)Preconditions.checkNotNull((Object)callContextPrototype);
        this.callable = (ServerStreamingCallable)Preconditions.checkNotNull(callable);
        this.executor = (RetryingExecutorWithContext)Preconditions.checkNotNull(executor);
        this.retryCodes = ImmutableSet.copyOf(retryCodes);
        this.retryAlgorithm = retryAlgorithm;
    }

    public RetryingFuture<Void> futureCall(MutateRowsRequest request, ApiCallContext inputContext) {
        ApiCallContext context = this.callContextPrototype.nullToSelf(inputContext);
        MutateRowsAttemptCallable retryCallable = new MutateRowsAttemptCallable((UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>>)this.callable.all(), request, context, (Set<StatusCode.Code>)this.retryCodes, (RetryAlgorithm<MutateRowsRequest>)this.retryAlgorithm);
        RetryingFuture retryingFuture = this.executor.createFuture((Callable)retryCallable, (RetryingContext)context);
        retryCallable.setExternalFuture((RetryingFuture<Void>)retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

