package com.google.cloud.bigtable.data.v2.models;

import com.google.protobuf.ByteString;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SetCell extends SetCell {

  private final String familyName;

  private final ByteString qualifier;

  private final long timestamp;

  private final ByteString value;

  AutoValue_SetCell(
      String familyName,
      ByteString qualifier,
      long timestamp,
      ByteString value) {
    if (familyName == null) {
      throw new NullPointerException("Null familyName");
    }
    this.familyName = familyName;
    if (qualifier == null) {
      throw new NullPointerException("Null qualifier");
    }
    this.qualifier = qualifier;
    this.timestamp = timestamp;
    if (value == null) {
      throw new NullPointerException("Null value");
    }
    this.value = value;
  }

  @Nonnull
  @Override
  public String getFamilyName() {
    return familyName;
  }

  @Nonnull
  @Override
  public ByteString getQualifier() {
    return qualifier;
  }

  @Override
  public long getTimestamp() {
    return timestamp;
  }

  @Nonnull
  @Override
  public ByteString getValue() {
    return value;
  }

  @Override
  public String toString() {
    return "SetCell{"
        + "familyName=" + familyName + ", "
        + "qualifier=" + qualifier + ", "
        + "timestamp=" + timestamp + ", "
        + "value=" + value
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SetCell) {
      SetCell that = (SetCell) o;
      return this.familyName.equals(that.getFamilyName())
          && this.qualifier.equals(that.getQualifier())
          && this.timestamp == that.getTimestamp()
          && this.value.equals(that.getValue());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= familyName.hashCode();
    h$ *= 1000003;
    h$ ^= qualifier.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((timestamp >>> 32) ^ timestamp);
    h$ *= 1000003;
    h$ ^= value.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 77123872266724154L;

}
