/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.models.AutoValue_RowCell;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

@InternalExtensionOnly
@AutoValue
public abstract class RowCell
implements Serializable {
    public static Comparator<RowCell> compareByNative() {
        return new Comparator<RowCell>(){

            @Override
            public int compare(RowCell c1, RowCell c2) {
                return ComparisonChain.start().compare((Comparable)((Object)c1.getFamily()), (Comparable)((Object)c2.getFamily())).compare((Object)c1.getQualifier(), (Object)c2.getQualifier(), (Comparator)ByteStringComparator.INSTANCE).compare(c2.getTimestamp(), c1.getTimestamp()).result();
            }
        };
    }

    @InternalApi
    public static RowCell create(@Nonnull String family, @Nonnull ByteString qualifier, long timestamp, @Nonnull List<String> labels, @Nonnull ByteString value) {
        labels = labels.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf((Collection)labels);
        return new AutoValue_RowCell(family, qualifier, timestamp, value, (List<String>)ImmutableList.copyOf((Collection)labels));
    }

    @Nonnull
    public abstract String getFamily();

    @Nonnull
    public abstract ByteString getQualifier();

    public abstract long getTimestamp();

    @Nonnull
    public abstract ByteString getValue();

    @Nonnull
    public abstract List<String> getLabels();
}

