/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.BetaApi;
import com.google.auto.value.AutoValue;
import com.google.bigtable.admin.v2.Type;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate_Aggregator_Hll;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate_Aggregator_Max;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate_Aggregator_Min;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate_Aggregator_Sum;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Bytes;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Bytes_Encoding_Raw;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Int64;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Int64_Encoding_BigEndianBytes;
import com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Raw;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@BetaApi
public interface Type {
    public com.google.bigtable.admin.v2.Type toProto();

    public static Type fromProto(com.google.bigtable.admin.v2.Type source) {
        switch (source.getKindCase()) {
            case INT64_TYPE: {
                return Int64.fromProto(source.getInt64Type());
            }
            case BYTES_TYPE: {
                return Bytes.fromProto(source.getBytesType());
            }
            case AGGREGATE_TYPE: {
                return Aggregate.fromProto(source.getAggregateType());
            }
            case KIND_NOT_SET: {
                return Raw.create();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Raw raw() {
        return Raw.create();
    }

    public static Bytes rawBytes() {
        return Bytes.create(Bytes.Encoding.raw());
    }

    public static Bytes bytes(Bytes.Encoding encoding) {
        return Bytes.create(encoding);
    }

    public static Int64 bigEndianInt64() {
        return Int64.create(Int64.Encoding.BigEndianBytes.create(Type.rawBytes()));
    }

    public static Int64 int64(Int64.Encoding encoding) {
        return Int64.create(encoding);
    }

    public static Aggregate int64Sum() {
        return Type.sum(Type.bigEndianInt64());
    }

    public static Aggregate sum(SumAggregateInput inputType) {
        return Aggregate.create(inputType, Aggregate.Aggregator.Sum.create());
    }

    public static Aggregate int64Min() {
        return Type.min(Type.bigEndianInt64());
    }

    public static Aggregate min(MinAggregateInput inputType) {
        return Aggregate.create(inputType, Aggregate.Aggregator.Min.create());
    }

    public static Aggregate int64Max() {
        return Type.max(Type.bigEndianInt64());
    }

    public static Aggregate max(MaxAggregateInput inputType) {
        return Aggregate.create(inputType, Aggregate.Aggregator.Max.create());
    }

    public static Aggregate int64Hll() {
        return Type.hll(Type.bigEndianInt64());
    }

    public static Aggregate hll(HllAggregateInput inputType) {
        return Aggregate.create(inputType, Aggregate.Aggregator.Hll.create());
    }

    @AutoValue
    public static abstract class Int64
    implements SumAggregateInput,
    MinAggregateInput,
    MaxAggregateInput,
    HllAggregateInput {
        public static Int64 create(Encoding encoding) {
            return new AutoValue_Type_Int64(encoding);
        }

        @Nonnull
        public abstract Encoding getEncoding();

        @Override
        public com.google.bigtable.admin.v2.Type toProto() {
            Type.Builder builder = com.google.bigtable.admin.v2.Type.newBuilder();
            builder.getInt64TypeBuilder().setEncoding(this.getEncoding().toProto());
            return builder.build();
        }

        static Int64 fromProto(Type.Int64 source) {
            return Int64.create(Encoding.fromProto(source.getEncoding()));
        }

        public static abstract class Encoding {
            abstract Type.Int64.Encoding toProto();

            static Encoding fromProto(Type.Int64.Encoding source) {
                switch (source.getEncodingCase()) {
                    case BIG_ENDIAN_BYTES: {
                        return BigEndianBytes.create(Bytes.fromProto(source.getBigEndianBytes().getBytesType()));
                    }
                    case ENCODING_NOT_SET: {
                        return BigEndianBytes.create(Type.rawBytes());
                    }
                }
                throw new UnsupportedOperationException();
            }

            @AutoValue
            public static abstract class BigEndianBytes
            extends Encoding {
                public static BigEndianBytes create(Bytes bytes) {
                    return new AutoValue_Type_Int64_Encoding_BigEndianBytes(bytes);
                }

                @Nonnull
                public abstract Bytes getBytes();

                @Override
                public Type.Int64.Encoding toProto() {
                    Type.Int64.Encoding.Builder builder = Type.Int64.Encoding.newBuilder();
                    builder.getBigEndianBytesBuilder().setBytesType(this.getBytes().toProto().getBytesType());
                    return builder.build();
                }
            }
        }
    }

    @AutoValue
    public static abstract class Bytes
    implements Type {
        public static Bytes create(Encoding encoding) {
            return new AutoValue_Type_Bytes(encoding);
        }

        @Nonnull
        public abstract Encoding getEncoding();

        @Override
        public com.google.bigtable.admin.v2.Type toProto() {
            Type.Builder builder = com.google.bigtable.admin.v2.Type.newBuilder();
            builder.getBytesTypeBuilder().setEncoding(this.getEncoding().toProto());
            return builder.build();
        }

        static Bytes fromProto(Type.Bytes source) {
            return Bytes.create(Encoding.fromProto(source.getEncoding()));
        }

        public static abstract class Encoding {
            abstract Type.Bytes.Encoding toProto();

            static Encoding fromProto(Type.Bytes.Encoding source) {
                switch (source.getEncodingCase()) {
                    case RAW: 
                    case ENCODING_NOT_SET: {
                        return Raw.create();
                    }
                }
                throw new UnsupportedOperationException();
            }

            public static Encoding raw() {
                return Raw.create();
            }

            @AutoValue
            public static abstract class Raw
            extends Encoding {
                private static final Type.Bytes.Encoding PROTO_INSTANCE = Type.Bytes.Encoding.newBuilder().setRaw(Type.Bytes.Encoding.Raw.getDefaultInstance()).build();

                public static Raw create() {
                    return new AutoValue_Type_Bytes_Encoding_Raw();
                }

                @Override
                public Type.Bytes.Encoding toProto() {
                    return PROTO_INSTANCE;
                }
            }
        }
    }

    @AutoValue
    public static abstract class Aggregate
    implements Type {
        public static Aggregate create(Type inputType, Aggregator aggregator) {
            return new AutoValue_Type_Aggregate(inputType, aggregator);
        }

        @Nonnull
        public abstract Type getInputType();

        @Nonnull
        public abstract Aggregator getAggregator();

        @Override
        public com.google.bigtable.admin.v2.Type toProto() {
            Type.Builder typeBuilder = com.google.bigtable.admin.v2.Type.newBuilder();
            Type.Aggregate.Builder aggregateBuilder = typeBuilder.getAggregateTypeBuilder();
            this.getAggregator().buildTo(aggregateBuilder);
            aggregateBuilder.setInputType(this.getInputType().toProto());
            return typeBuilder.build();
        }

        static Aggregate fromProto(Type.Aggregate source) {
            Type inputType = Type.fromProto(source.getInputType());
            Aggregator aggregator = null;
            switch (source.getAggregatorCase()) {
                case SUM: {
                    aggregator = Aggregator.Sum.create();
                    break;
                }
                case MIN: {
                    aggregator = Aggregator.Min.create();
                    break;
                }
                case MAX: {
                    aggregator = Aggregator.Max.create();
                    break;
                }
                case HLLPP_UNIQUE_COUNT: {
                    aggregator = Aggregator.Hll.create();
                    break;
                }
                case AGGREGATOR_NOT_SET: {
                    throw new UnsupportedOperationException();
                }
            }
            return Aggregate.create(inputType, (Aggregator)Preconditions.checkNotNull((Object)aggregator));
        }

        public static abstract class Aggregator {
            abstract void buildTo(Type.Aggregate.Builder var1);

            @AutoValue
            public static abstract class Hll
            extends Aggregator {
                public static Hll create() {
                    return new AutoValue_Type_Aggregate_Aggregator_Hll();
                }

                @Override
                void buildTo(Type.Aggregate.Builder builder) {
                    builder.setHllppUniqueCount(Type.Aggregate.HyperLogLogPlusPlusUniqueCount.getDefaultInstance());
                }
            }

            @AutoValue
            public static abstract class Max
            extends Aggregator {
                public static Max create() {
                    return new AutoValue_Type_Aggregate_Aggregator_Max();
                }

                @Override
                void buildTo(Type.Aggregate.Builder builder) {
                    builder.setMax(Type.Aggregate.Max.getDefaultInstance());
                }
            }

            @AutoValue
            public static abstract class Min
            extends Aggregator {
                public static Min create() {
                    return new AutoValue_Type_Aggregate_Aggregator_Min();
                }

                @Override
                void buildTo(Type.Aggregate.Builder builder) {
                    builder.setMin(Type.Aggregate.Min.getDefaultInstance());
                }
            }

            @AutoValue
            public static abstract class Sum
            extends Aggregator {
                public static Sum create() {
                    return new AutoValue_Type_Aggregate_Aggregator_Sum();
                }

                @Override
                void buildTo(Type.Aggregate.Builder builder) {
                    builder.setSum(Type.Aggregate.Sum.getDefaultInstance());
                }
            }
        }
    }

    @AutoValue
    public static abstract class Raw
    implements Type {
        public static Raw create() {
            return new AutoValue_Type_Raw();
        }

        @Override
        public com.google.bigtable.admin.v2.Type toProto() {
            return com.google.bigtable.admin.v2.Type.getDefaultInstance();
        }
    }

    public static interface SumAggregateInput
    extends Type {
    }

    public static interface MinAggregateInput
    extends Type {
    }

    public static interface MaxAggregateInput
    extends Type {
    }

    public static interface HllAggregateInput
    extends Type {
    }
}

