/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models.sql;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.Type;
import com.google.bigtable.v2.Value;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

@BetaApi
public class Statement {
    private static final Type STRING_TYPE = Type.newBuilder().setStringType(Type.String.getDefaultInstance()).build();
    private static final Type BYTES_TYPE = Type.newBuilder().setBytesType(Type.Bytes.getDefaultInstance()).build();
    private static final Type INT64_TYPE = Type.newBuilder().setInt64Type(Type.Int64.getDefaultInstance()).build();
    private static final Type BOOL_TYPE = Type.newBuilder().setBoolType(Type.Bool.getDefaultInstance()).build();
    private static final Type TIMESTAMP_TYPE = Type.newBuilder().setTimestampType(Type.Timestamp.getDefaultInstance()).build();
    private static final Type DATE_TYPE = Type.newBuilder().setDateType(Type.Date.getDefaultInstance()).build();
    private final String sql;
    private final Map<String, Value> params;

    private Statement(String sql, Map<String, Value> params) {
        this.sql = sql;
        this.params = params;
    }

    public static Statement of(String sql) {
        return Statement.newBuilder(sql).build();
    }

    public static Builder newBuilder(String sql) {
        return new Builder(sql);
    }

    @InternalApi(value="For internal use only")
    public ExecuteQueryRequest toProto(RequestContext requestContext) {
        return ExecuteQueryRequest.newBuilder().setInstanceName(NameUtil.formatInstanceName(requestContext.getProjectId(), requestContext.getInstanceId())).setAppProfileId(requestContext.getAppProfileId()).setQuery(this.sql).putAllParams(this.params).build();
    }

    public static class Builder {
        private final String sql;
        private final Map<String, Value> params;

        private Builder(String sql) {
            this.sql = sql;
            this.params = new HashMap<String, Value>();
        }

        public Statement build() {
            return new Statement(this.sql, (Map)ImmutableMap.copyOf(this.params));
        }

        public Builder setStringParam(String paramName, @Nullable String value) {
            this.params.put(paramName, Builder.stringParamOf(value));
            return this;
        }

        public Builder setBytesParam(String paramName, @Nullable ByteString value) {
            this.params.put(paramName, Builder.bytesParamOf(value));
            return this;
        }

        public Builder setLongParam(String paramName, @Nullable Long value) {
            this.params.put(paramName, Builder.int64ParamOf(value));
            return this;
        }

        public Builder setBooleanParam(String paramName, @Nullable Boolean value) {
            this.params.put(paramName, Builder.booleanParamOf(value));
            return this;
        }

        public Builder setTimestampParam(String paramName, @Nullable Instant value) {
            this.params.put(paramName, Builder.timestampParamOf(value));
            return this;
        }

        public Builder setDateParam(String paramName, @Nullable Date value) {
            this.params.put(paramName, Builder.dateParamOf(value));
            return this;
        }

        private static Value stringParamOf(@Nullable String value) {
            Value.Builder builder = Builder.nullValueWithType(STRING_TYPE);
            if (value != null) {
                builder.setStringValue(value);
            }
            return builder.build();
        }

        private static Value bytesParamOf(@Nullable ByteString value) {
            Value.Builder builder = Builder.nullValueWithType(BYTES_TYPE);
            if (value != null) {
                builder.setBytesValue(value);
            }
            return builder.build();
        }

        private static Value int64ParamOf(@Nullable Long value) {
            Value.Builder builder = Builder.nullValueWithType(INT64_TYPE);
            if (value != null) {
                builder.setIntValue(value.longValue());
            }
            return builder.build();
        }

        private static Value booleanParamOf(@Nullable Boolean value) {
            Value.Builder builder = Builder.nullValueWithType(BOOL_TYPE);
            if (value != null) {
                builder.setBoolValue(value.booleanValue());
            }
            return builder.build();
        }

        private static Value timestampParamOf(@Nullable Instant value) {
            Value.Builder builder = Builder.nullValueWithType(TIMESTAMP_TYPE);
            if (value != null) {
                builder.setTimestampValue(Timestamp.newBuilder().setSeconds(value.getEpochSecond()).setNanos(value.getNano()).build());
            }
            return builder.build();
        }

        private static Value dateParamOf(@Nullable Date value) {
            Value.Builder builder = Builder.nullValueWithType(DATE_TYPE);
            if (value != null) {
                builder.setDateValue(com.google.type.Date.newBuilder().setYear(value.getYear()).setMonth(value.getMonth()).setDay(value.getDayOfMonth()).build());
            }
            return builder.build();
        }

        private static Value.Builder nullValueWithType(Type type) {
            return Value.newBuilder().setType(type);
        }
    }
}

