/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableCloudMonitoringExporter;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;

public class BuiltinMetricsView {
    private BuiltinMetricsView() {
    }

    public static void registerBuiltinMetrics(String projectId, SdkMeterProviderBuilder builder) throws IOException {
        BuiltinMetricsView.registerBuiltinMetrics(projectId, (Credentials)GoogleCredentials.getApplicationDefault(), builder);
    }

    public static void registerBuiltinMetrics(String projectId, @Nullable Credentials credentials, SdkMeterProviderBuilder builder) throws IOException {
        BigtableCloudMonitoringExporter metricExporter = BigtableCloudMonitoringExporter.create(projectId, credentials);
        for (Map.Entry<InstrumentSelector, View> entry : BuiltinMetricsConstants.getAllViews().entrySet()) {
            builder.registerView(entry.getKey(), entry.getValue());
        }
        builder.registerMetricReader((MetricReader)PeriodicMetricReader.create((MetricExporter)metricExporter));
    }
}

