package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.SettableApiFuture;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExecuteQueryCallContext extends ExecuteQueryCallContext {

  private final ExecuteQueryRequest request;

  private final SettableApiFuture<ResultSetMetadata> resultSetMetadataFuture;

  AutoValue_ExecuteQueryCallContext(
      ExecuteQueryRequest request,
      SettableApiFuture<ResultSetMetadata> resultSetMetadataFuture) {
    if (request == null) {
      throw new NullPointerException("Null request");
    }
    this.request = request;
    if (resultSetMetadataFuture == null) {
      throw new NullPointerException("Null resultSetMetadataFuture");
    }
    this.resultSetMetadataFuture = resultSetMetadataFuture;
  }

  @Override
  ExecuteQueryRequest request() {
    return request;
  }

  @Override
  SettableApiFuture<ResultSetMetadata> resultSetMetadataFuture() {
    return resultSetMetadataFuture;
  }

  @Override
  public String toString() {
    return "ExecuteQueryCallContext{"
        + "request=" + request + ", "
        + "resultSetMetadataFuture=" + resultSetMetadataFuture
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExecuteQueryCallContext) {
      ExecuteQueryCallContext that = (ExecuteQueryCallContext) o;
      return this.request.equals(that.request())
          && this.resultSetMetadataFuture.equals(that.resultSetMetadataFuture());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= request.hashCode();
    h$ *= 1000003;
    h$ ^= resultSetMetadataFuture.hashCode();
    return h$;
  }

}
